/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.glue.model.BackfillErrorCode;
import software.amazon.awssdk.services.glue.model.BackfillErroredPartitionsListCopier;
import software.amazon.awssdk.services.glue.model.PartitionValueList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BackfillError
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, BackfillError> {
    private static final SdkField<String> CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Code").getter(BackfillError.getter(BackfillError::codeAsString)).setter(BackfillError.setter(Builder::code)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Code").build()}).build();
    private static final SdkField<List<PartitionValueList>> PARTITIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Partitions").getter(BackfillError.getter(BackfillError::partitions)).setter(BackfillError.setter(Builder::partitions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Partitions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PartitionValueList::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CODE_FIELD, PARTITIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Code", CODE_FIELD);
            this.put("Partitions", PARTITIONS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String code;
    private final List<PartitionValueList> partitions;

    private BackfillError(BuilderImpl builder) {
        this.code = builder.code;
        this.partitions = builder.partitions;
    }

    public final BackfillErrorCode code() {
        return BackfillErrorCode.fromValue(this.code);
    }

    public final String codeAsString() {
        return this.code;
    }

    public final boolean hasPartitions() {
        return this.partitions != null && !(this.partitions instanceof SdkAutoConstructList);
    }

    public final List<PartitionValueList> partitions() {
        return this.partitions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.codeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPartitions() ? this.partitions() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BackfillError)) {
            return false;
        }
        BackfillError other = (BackfillError)obj;
        return Objects.equals(this.codeAsString(), other.codeAsString()) && this.hasPartitions() == other.hasPartitions() && Objects.equals(this.partitions(), other.partitions());
    }

    public final String toString() {
        return ToString.builder((String)"BackfillError").add("Code", (Object)this.codeAsString()).add("Partitions", this.hasPartitions() ? this.partitions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Code": {
                return Optional.ofNullable(clazz.cast(this.codeAsString()));
            }
            case "Partitions": {
                return Optional.ofNullable(clazz.cast(this.partitions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<BackfillError, T> g) {
        return obj -> g.apply((BackfillError)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String code;
        private List<PartitionValueList> partitions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BackfillError model) {
            this.code(model.code);
            this.partitions(model.partitions);
        }

        public final String getCode() {
            return this.code;
        }

        public final void setCode(String code) {
            this.code = code;
        }

        @Override
        public final Builder code(String code) {
            this.code = code;
            return this;
        }

        @Override
        public final Builder code(BackfillErrorCode code) {
            this.code(code == null ? null : code.toString());
            return this;
        }

        public final List<PartitionValueList.Builder> getPartitions() {
            List<PartitionValueList.Builder> result = BackfillErroredPartitionsListCopier.copyToBuilder(this.partitions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPartitions(Collection<PartitionValueList.BuilderImpl> partitions) {
            this.partitions = BackfillErroredPartitionsListCopier.copyFromBuilder(partitions);
        }

        @Override
        public final Builder partitions(Collection<PartitionValueList> partitions) {
            this.partitions = BackfillErroredPartitionsListCopier.copy(partitions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder partitions(PartitionValueList ... partitions) {
            this.partitions(Arrays.asList(partitions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder partitions(Consumer<PartitionValueList.Builder> ... partitions) {
            this.partitions(Stream.of(partitions).map(c -> (PartitionValueList)((PartitionValueList.Builder)PartitionValueList.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public BackfillError build() {
            return new BackfillError(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, BackfillError> {
        public Builder code(String var1);

        public Builder code(BackfillErrorCode var1);

        public Builder partitions(Collection<PartitionValueList> var1);

        public Builder partitions(PartitionValueList ... var1);

        public Builder partitions(Consumer<PartitionValueList.Builder> ... var1);
    }
}

