/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The options to configure an upsert operation when writing to a Redshift target .
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpsertRedshiftTargetOptions implements SdkPojo, Serializable,
        ToCopyableBuilder<UpsertRedshiftTargetOptions.Builder, UpsertRedshiftTargetOptions> {
    private static final SdkField<String> TABLE_LOCATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TableLocation").getter(getter(UpsertRedshiftTargetOptions::tableLocation))
            .setter(setter(Builder::tableLocation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TableLocation").build()).build();

    private static final SdkField<String> CONNECTION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ConnectionName").getter(getter(UpsertRedshiftTargetOptions::connectionName))
            .setter(setter(Builder::connectionName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionName").build()).build();

    private static final SdkField<List<String>> UPSERT_KEYS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("UpsertKeys")
            .getter(getter(UpsertRedshiftTargetOptions::upsertKeys))
            .setter(setter(Builder::upsertKeys))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpsertKeys").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TABLE_LOCATION_FIELD,
            CONNECTION_NAME_FIELD, UPSERT_KEYS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String tableLocation;

    private final String connectionName;

    private final List<String> upsertKeys;

    private UpsertRedshiftTargetOptions(BuilderImpl builder) {
        this.tableLocation = builder.tableLocation;
        this.connectionName = builder.connectionName;
        this.upsertKeys = builder.upsertKeys;
    }

    /**
     * <p>
     * The physical location of the Redshift table.
     * </p>
     * 
     * @return The physical location of the Redshift table.
     */
    public final String tableLocation() {
        return tableLocation;
    }

    /**
     * <p>
     * The name of the connection to use to write to Redshift.
     * </p>
     * 
     * @return The name of the connection to use to write to Redshift.
     */
    public final String connectionName() {
        return connectionName;
    }

    /**
     * For responses, this returns true if the service returned a value for the UpsertKeys property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasUpsertKeys() {
        return upsertKeys != null && !(upsertKeys instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The keys used to determine whether to perform an update or insert.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasUpsertKeys} method.
     * </p>
     * 
     * @return The keys used to determine whether to perform an update or insert.
     */
    public final List<String> upsertKeys() {
        return upsertKeys;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(tableLocation());
        hashCode = 31 * hashCode + Objects.hashCode(connectionName());
        hashCode = 31 * hashCode + Objects.hashCode(hasUpsertKeys() ? upsertKeys() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpsertRedshiftTargetOptions)) {
            return false;
        }
        UpsertRedshiftTargetOptions other = (UpsertRedshiftTargetOptions) obj;
        return Objects.equals(tableLocation(), other.tableLocation()) && Objects.equals(connectionName(), other.connectionName())
                && hasUpsertKeys() == other.hasUpsertKeys() && Objects.equals(upsertKeys(), other.upsertKeys());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpsertRedshiftTargetOptions").add("TableLocation", tableLocation())
                .add("ConnectionName", connectionName()).add("UpsertKeys", hasUpsertKeys() ? upsertKeys() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TableLocation":
            return Optional.ofNullable(clazz.cast(tableLocation()));
        case "ConnectionName":
            return Optional.ofNullable(clazz.cast(connectionName()));
        case "UpsertKeys":
            return Optional.ofNullable(clazz.cast(upsertKeys()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpsertRedshiftTargetOptions, T> g) {
        return obj -> g.apply((UpsertRedshiftTargetOptions) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, UpsertRedshiftTargetOptions> {
        /**
         * <p>
         * The physical location of the Redshift table.
         * </p>
         * 
         * @param tableLocation
         *        The physical location of the Redshift table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tableLocation(String tableLocation);

        /**
         * <p>
         * The name of the connection to use to write to Redshift.
         * </p>
         * 
         * @param connectionName
         *        The name of the connection to use to write to Redshift.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectionName(String connectionName);

        /**
         * <p>
         * The keys used to determine whether to perform an update or insert.
         * </p>
         * 
         * @param upsertKeys
         *        The keys used to determine whether to perform an update or insert.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder upsertKeys(Collection<String> upsertKeys);

        /**
         * <p>
         * The keys used to determine whether to perform an update or insert.
         * </p>
         * 
         * @param upsertKeys
         *        The keys used to determine whether to perform an update or insert.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder upsertKeys(String... upsertKeys);
    }

    static final class BuilderImpl implements Builder {
        private String tableLocation;

        private String connectionName;

        private List<String> upsertKeys = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpsertRedshiftTargetOptions model) {
            tableLocation(model.tableLocation);
            connectionName(model.connectionName);
            upsertKeys(model.upsertKeys);
        }

        public final String getTableLocation() {
            return tableLocation;
        }

        public final void setTableLocation(String tableLocation) {
            this.tableLocation = tableLocation;
        }

        @Override
        public final Builder tableLocation(String tableLocation) {
            this.tableLocation = tableLocation;
            return this;
        }

        public final String getConnectionName() {
            return connectionName;
        }

        public final void setConnectionName(String connectionName) {
            this.connectionName = connectionName;
        }

        @Override
        public final Builder connectionName(String connectionName) {
            this.connectionName = connectionName;
            return this;
        }

        public final Collection<String> getUpsertKeys() {
            if (upsertKeys instanceof SdkAutoConstructList) {
                return null;
            }
            return upsertKeys;
        }

        public final void setUpsertKeys(Collection<String> upsertKeys) {
            this.upsertKeys = EnclosedInStringPropertiesMinOneCopier.copy(upsertKeys);
        }

        @Override
        public final Builder upsertKeys(Collection<String> upsertKeys) {
            this.upsertKeys = EnclosedInStringPropertiesMinOneCopier.copy(upsertKeys);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder upsertKeys(String... upsertKeys) {
            upsertKeys(Arrays.asList(upsertKeys));
            return this;
        }

        @Override
        public UpsertRedshiftTargetOptions build() {
            return new UpsertRedshiftTargetOptions(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
