/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object that contains minimal details for a schema.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SchemaListItem implements SdkPojo, Serializable, ToCopyableBuilder<SchemaListItem.Builder, SchemaListItem> {
    private static final SdkField<String> REGISTRY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RegistryName").getter(getter(SchemaListItem::registryName)).setter(setter(Builder::registryName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RegistryName").build()).build();

    private static final SdkField<String> SCHEMA_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SchemaName").getter(getter(SchemaListItem::schemaName)).setter(setter(Builder::schemaName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SchemaName").build()).build();

    private static final SdkField<String> SCHEMA_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SchemaArn").getter(getter(SchemaListItem::schemaArn)).setter(setter(Builder::schemaArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SchemaArn").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(SchemaListItem::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> SCHEMA_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SchemaStatus").getter(getter(SchemaListItem::schemaStatusAsString))
            .setter(setter(Builder::schemaStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SchemaStatus").build()).build();

    private static final SdkField<String> CREATED_TIME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CreatedTime").getter(getter(SchemaListItem::createdTime)).setter(setter(Builder::createdTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTime").build()).build();

    private static final SdkField<String> UPDATED_TIME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("UpdatedTime").getter(getter(SchemaListItem::updatedTime)).setter(setter(Builder::updatedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdatedTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REGISTRY_NAME_FIELD,
            SCHEMA_NAME_FIELD, SCHEMA_ARN_FIELD, DESCRIPTION_FIELD, SCHEMA_STATUS_FIELD, CREATED_TIME_FIELD, UPDATED_TIME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String registryName;

    private final String schemaName;

    private final String schemaArn;

    private final String description;

    private final String schemaStatus;

    private final String createdTime;

    private final String updatedTime;

    private SchemaListItem(BuilderImpl builder) {
        this.registryName = builder.registryName;
        this.schemaName = builder.schemaName;
        this.schemaArn = builder.schemaArn;
        this.description = builder.description;
        this.schemaStatus = builder.schemaStatus;
        this.createdTime = builder.createdTime;
        this.updatedTime = builder.updatedTime;
    }

    /**
     * <p>
     * the name of the registry where the schema resides.
     * </p>
     * 
     * @return the name of the registry where the schema resides.
     */
    public final String registryName() {
        return registryName;
    }

    /**
     * <p>
     * The name of the schema.
     * </p>
     * 
     * @return The name of the schema.
     */
    public final String schemaName() {
        return schemaName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) for the schema.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) for the schema.
     */
    public final String schemaArn() {
        return schemaArn;
    }

    /**
     * <p>
     * A description for the schema.
     * </p>
     * 
     * @return A description for the schema.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The status of the schema.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #schemaStatus} will
     * return {@link SchemaStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #schemaStatusAsString}.
     * </p>
     * 
     * @return The status of the schema.
     * @see SchemaStatus
     */
    public final SchemaStatus schemaStatus() {
        return SchemaStatus.fromValue(schemaStatus);
    }

    /**
     * <p>
     * The status of the schema.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #schemaStatus} will
     * return {@link SchemaStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #schemaStatusAsString}.
     * </p>
     * 
     * @return The status of the schema.
     * @see SchemaStatus
     */
    public final String schemaStatusAsString() {
        return schemaStatus;
    }

    /**
     * <p>
     * The date and time that a schema was created.
     * </p>
     * 
     * @return The date and time that a schema was created.
     */
    public final String createdTime() {
        return createdTime;
    }

    /**
     * <p>
     * The date and time that a schema was updated.
     * </p>
     * 
     * @return The date and time that a schema was updated.
     */
    public final String updatedTime() {
        return updatedTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(registryName());
        hashCode = 31 * hashCode + Objects.hashCode(schemaName());
        hashCode = 31 * hashCode + Objects.hashCode(schemaArn());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(schemaStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(createdTime());
        hashCode = 31 * hashCode + Objects.hashCode(updatedTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SchemaListItem)) {
            return false;
        }
        SchemaListItem other = (SchemaListItem) obj;
        return Objects.equals(registryName(), other.registryName()) && Objects.equals(schemaName(), other.schemaName())
                && Objects.equals(schemaArn(), other.schemaArn()) && Objects.equals(description(), other.description())
                && Objects.equals(schemaStatusAsString(), other.schemaStatusAsString())
                && Objects.equals(createdTime(), other.createdTime()) && Objects.equals(updatedTime(), other.updatedTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SchemaListItem").add("RegistryName", registryName()).add("SchemaName", schemaName())
                .add("SchemaArn", schemaArn()).add("Description", description()).add("SchemaStatus", schemaStatusAsString())
                .add("CreatedTime", createdTime()).add("UpdatedTime", updatedTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RegistryName":
            return Optional.ofNullable(clazz.cast(registryName()));
        case "SchemaName":
            return Optional.ofNullable(clazz.cast(schemaName()));
        case "SchemaArn":
            return Optional.ofNullable(clazz.cast(schemaArn()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "SchemaStatus":
            return Optional.ofNullable(clazz.cast(schemaStatusAsString()));
        case "CreatedTime":
            return Optional.ofNullable(clazz.cast(createdTime()));
        case "UpdatedTime":
            return Optional.ofNullable(clazz.cast(updatedTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SchemaListItem, T> g) {
        return obj -> g.apply((SchemaListItem) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SchemaListItem> {
        /**
         * <p>
         * the name of the registry where the schema resides.
         * </p>
         * 
         * @param registryName
         *        the name of the registry where the schema resides.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder registryName(String registryName);

        /**
         * <p>
         * The name of the schema.
         * </p>
         * 
         * @param schemaName
         *        The name of the schema.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder schemaName(String schemaName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) for the schema.
         * </p>
         * 
         * @param schemaArn
         *        The Amazon Resource Name (ARN) for the schema.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder schemaArn(String schemaArn);

        /**
         * <p>
         * A description for the schema.
         * </p>
         * 
         * @param description
         *        A description for the schema.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The status of the schema.
         * </p>
         * 
         * @param schemaStatus
         *        The status of the schema.
         * @see SchemaStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SchemaStatus
         */
        Builder schemaStatus(String schemaStatus);

        /**
         * <p>
         * The status of the schema.
         * </p>
         * 
         * @param schemaStatus
         *        The status of the schema.
         * @see SchemaStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SchemaStatus
         */
        Builder schemaStatus(SchemaStatus schemaStatus);

        /**
         * <p>
         * The date and time that a schema was created.
         * </p>
         * 
         * @param createdTime
         *        The date and time that a schema was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdTime(String createdTime);

        /**
         * <p>
         * The date and time that a schema was updated.
         * </p>
         * 
         * @param updatedTime
         *        The date and time that a schema was updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedTime(String updatedTime);
    }

    static final class BuilderImpl implements Builder {
        private String registryName;

        private String schemaName;

        private String schemaArn;

        private String description;

        private String schemaStatus;

        private String createdTime;

        private String updatedTime;

        private BuilderImpl() {
        }

        private BuilderImpl(SchemaListItem model) {
            registryName(model.registryName);
            schemaName(model.schemaName);
            schemaArn(model.schemaArn);
            description(model.description);
            schemaStatus(model.schemaStatus);
            createdTime(model.createdTime);
            updatedTime(model.updatedTime);
        }

        public final String getRegistryName() {
            return registryName;
        }

        public final void setRegistryName(String registryName) {
            this.registryName = registryName;
        }

        @Override
        public final Builder registryName(String registryName) {
            this.registryName = registryName;
            return this;
        }

        public final String getSchemaName() {
            return schemaName;
        }

        public final void setSchemaName(String schemaName) {
            this.schemaName = schemaName;
        }

        @Override
        public final Builder schemaName(String schemaName) {
            this.schemaName = schemaName;
            return this;
        }

        public final String getSchemaArn() {
            return schemaArn;
        }

        public final void setSchemaArn(String schemaArn) {
            this.schemaArn = schemaArn;
        }

        @Override
        public final Builder schemaArn(String schemaArn) {
            this.schemaArn = schemaArn;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getSchemaStatus() {
            return schemaStatus;
        }

        public final void setSchemaStatus(String schemaStatus) {
            this.schemaStatus = schemaStatus;
        }

        @Override
        public final Builder schemaStatus(String schemaStatus) {
            this.schemaStatus = schemaStatus;
            return this;
        }

        @Override
        public final Builder schemaStatus(SchemaStatus schemaStatus) {
            this.schemaStatus(schemaStatus == null ? null : schemaStatus.toString());
            return this;
        }

        public final String getCreatedTime() {
            return createdTime;
        }

        public final void setCreatedTime(String createdTime) {
            this.createdTime = createdTime;
        }

        @Override
        public final Builder createdTime(String createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public final String getUpdatedTime() {
            return updatedTime;
        }

        public final void setUpdatedTime(String updatedTime) {
            this.updatedTime = updatedTime;
        }

        @Override
        public final Builder updatedTime(String updatedTime) {
            this.updatedTime = updatedTime;
            return this;
        }

        @Override
        public SchemaListItem build() {
            return new SchemaListItem(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
