/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DecimalNumber
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DecimalNumber> {
    private static final SdkField<SdkBytes> UNSCALED_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_BYTES).memberName("UnscaledValue").getter(DecimalNumber.getter(DecimalNumber::unscaledValue)).setter(DecimalNumber.setter(Builder::unscaledValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UnscaledValue").build()}).build();
    private static final SdkField<Integer> SCALE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Scale").getter(DecimalNumber.getter(DecimalNumber::scale)).setter(DecimalNumber.setter(Builder::scale)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Scale").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(UNSCALED_VALUE_FIELD, SCALE_FIELD));
    private static final long serialVersionUID = 1L;
    private final SdkBytes unscaledValue;
    private final Integer scale;

    private DecimalNumber(BuilderImpl builder) {
        this.unscaledValue = builder.unscaledValue;
        this.scale = builder.scale;
    }

    public final SdkBytes unscaledValue() {
        return this.unscaledValue;
    }

    public final Integer scale() {
        return this.scale;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.unscaledValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.scale());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DecimalNumber)) {
            return false;
        }
        DecimalNumber other = (DecimalNumber)obj;
        return Objects.equals(this.unscaledValue(), other.unscaledValue()) && Objects.equals(this.scale(), other.scale());
    }

    public final String toString() {
        return ToString.builder((String)"DecimalNumber").add("UnscaledValue", (Object)this.unscaledValue()).add("Scale", (Object)this.scale()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "UnscaledValue": {
                return Optional.ofNullable(clazz.cast(this.unscaledValue()));
            }
            case "Scale": {
                return Optional.ofNullable(clazz.cast(this.scale()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DecimalNumber, T> g) {
        return obj -> g.apply((DecimalNumber)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private SdkBytes unscaledValue;
        private Integer scale;

        private BuilderImpl() {
        }

        private BuilderImpl(DecimalNumber model) {
            this.unscaledValue(model.unscaledValue);
            this.scale(model.scale);
        }

        public final ByteBuffer getUnscaledValue() {
            return this.unscaledValue == null ? null : this.unscaledValue.asByteBuffer();
        }

        public final void setUnscaledValue(ByteBuffer unscaledValue) {
            this.unscaledValue(unscaledValue == null ? null : SdkBytes.fromByteBuffer((ByteBuffer)unscaledValue));
        }

        @Override
        public final Builder unscaledValue(SdkBytes unscaledValue) {
            this.unscaledValue = unscaledValue;
            return this;
        }

        public final Integer getScale() {
            return this.scale;
        }

        public final void setScale(Integer scale) {
            this.scale = scale;
        }

        @Override
        public final Builder scale(Integer scale) {
            this.scale = scale;
            return this;
        }

        public DecimalNumber build() {
            return new DecimalNumber(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DecimalNumber> {
        public Builder unscaledValue(SdkBytes var1);

        public Builder scale(Integer var1);
    }
}

