/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.glue.GlueClient;
import software.amazon.awssdk.services.glue.internal.UserAgentUtils;
import software.amazon.awssdk.services.glue.model.GetConnectionsRequest;
import software.amazon.awssdk.services.glue.model.GetConnectionsResponse;

public class GetConnectionsIterable
implements SdkIterable<GetConnectionsResponse> {
    private final GlueClient client;
    private final GetConnectionsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public GetConnectionsIterable(GlueClient client, GetConnectionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new GetConnectionsResponseFetcher();
    }

    public Iterator<GetConnectionsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class GetConnectionsResponseFetcher
    implements SyncPageFetcher<GetConnectionsResponse> {
        private GetConnectionsResponseFetcher() {
        }

        public boolean hasNextPage(GetConnectionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public GetConnectionsResponse nextPage(GetConnectionsResponse previousPage) {
            if (previousPage == null) {
                return GetConnectionsIterable.this.client.getConnections(GetConnectionsIterable.this.firstRequest);
            }
            return GetConnectionsIterable.this.client.getConnections((GetConnectionsRequest)((Object)GetConnectionsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

