/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.glue.model.SortDirectionType;
import software.amazon.awssdk.services.glue.model.TransformSortColumnType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TransformSortCriteria
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TransformSortCriteria> {
    private static final SdkField<String> COLUMN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Column").getter(TransformSortCriteria.getter(TransformSortCriteria::columnAsString)).setter(TransformSortCriteria.setter(Builder::column)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Column").build()}).build();
    private static final SdkField<String> SORT_DIRECTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SortDirection").getter(TransformSortCriteria.getter(TransformSortCriteria::sortDirectionAsString)).setter(TransformSortCriteria.setter(Builder::sortDirection)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SortDirection").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COLUMN_FIELD, SORT_DIRECTION_FIELD));
    private static final long serialVersionUID = 1L;
    private final String column;
    private final String sortDirection;

    private TransformSortCriteria(BuilderImpl builder) {
        this.column = builder.column;
        this.sortDirection = builder.sortDirection;
    }

    public final TransformSortColumnType column() {
        return TransformSortColumnType.fromValue(this.column);
    }

    public final String columnAsString() {
        return this.column;
    }

    public final SortDirectionType sortDirection() {
        return SortDirectionType.fromValue(this.sortDirection);
    }

    public final String sortDirectionAsString() {
        return this.sortDirection;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.columnAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.sortDirectionAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TransformSortCriteria)) {
            return false;
        }
        TransformSortCriteria other = (TransformSortCriteria)obj;
        return Objects.equals(this.columnAsString(), other.columnAsString()) && Objects.equals(this.sortDirectionAsString(), other.sortDirectionAsString());
    }

    public final String toString() {
        return ToString.builder((String)"TransformSortCriteria").add("Column", (Object)this.columnAsString()).add("SortDirection", (Object)this.sortDirectionAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Column": {
                return Optional.ofNullable(clazz.cast(this.columnAsString()));
            }
            case "SortDirection": {
                return Optional.ofNullable(clazz.cast(this.sortDirectionAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TransformSortCriteria, T> g) {
        return obj -> g.apply((TransformSortCriteria)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String column;
        private String sortDirection;

        private BuilderImpl() {
        }

        private BuilderImpl(TransformSortCriteria model) {
            this.column(model.column);
            this.sortDirection(model.sortDirection);
        }

        public final String getColumn() {
            return this.column;
        }

        public final void setColumn(String column) {
            this.column = column;
        }

        @Override
        public final Builder column(String column) {
            this.column = column;
            return this;
        }

        @Override
        public final Builder column(TransformSortColumnType column) {
            this.column(column == null ? null : column.toString());
            return this;
        }

        public final String getSortDirection() {
            return this.sortDirection;
        }

        public final void setSortDirection(String sortDirection) {
            this.sortDirection = sortDirection;
        }

        @Override
        public final Builder sortDirection(String sortDirection) {
            this.sortDirection = sortDirection;
            return this;
        }

        @Override
        public final Builder sortDirection(SortDirectionType sortDirection) {
            this.sortDirection(sortDirection == null ? null : sortDirection.toString());
            return this;
        }

        public TransformSortCriteria build() {
            return new TransformSortCriteria(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TransformSortCriteria> {
        public Builder column(String var1);

        public Builder column(TransformSortColumnType var1);

        public Builder sortDirection(String var1);

        public Builder sortDirection(SortDirectionType var1);
    }
}

