/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.glue.GlueAsyncClient;
import software.amazon.awssdk.services.glue.internal.UserAgentUtils;
import software.amazon.awssdk.services.glue.model.GetTriggersRequest;
import software.amazon.awssdk.services.glue.model.GetTriggersResponse;
import software.amazon.awssdk.services.glue.model.Trigger;

public class GetTriggersPublisher
implements SdkPublisher<GetTriggersResponse> {
    private final GlueAsyncClient client;
    private final GetTriggersRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public GetTriggersPublisher(GlueAsyncClient client, GetTriggersRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private GetTriggersPublisher(GlueAsyncClient client, GetTriggersRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new GetTriggersResponseFetcher();
    }

    public void subscribe(Subscriber<? super GetTriggersResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<Trigger> triggers() {
        Function<GetTriggersResponse, Iterator> getIterator = response -> {
            if (response != null && response.triggers() != null) {
                return response.triggers().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new GetTriggersResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class GetTriggersResponseFetcher
    implements AsyncPageFetcher<GetTriggersResponse> {
        private GetTriggersResponseFetcher() {
        }

        public boolean hasNextPage(GetTriggersResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<GetTriggersResponse> nextPage(GetTriggersResponse previousPage) {
            if (previousPage == null) {
                return GetTriggersPublisher.this.client.getTriggers(GetTriggersPublisher.this.firstRequest);
            }
            return GetTriggersPublisher.this.client.getTriggers((GetTriggersRequest)((Object)GetTriggersPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

