/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ResumeWorkflowRunRequest extends GlueRequest implements
        ToCopyableBuilder<ResumeWorkflowRunRequest.Builder, ResumeWorkflowRunRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(ResumeWorkflowRunRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> RUN_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("RunId")
            .getter(getter(ResumeWorkflowRunRequest::runId)).setter(setter(Builder::runId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RunId").build()).build();

    private static final SdkField<List<String>> NODE_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("NodeIds")
            .getter(getter(ResumeWorkflowRunRequest::nodeIds))
            .setter(setter(Builder::nodeIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NodeIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, RUN_ID_FIELD,
            NODE_IDS_FIELD));

    private final String name;

    private final String runId;

    private final List<String> nodeIds;

    private ResumeWorkflowRunRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.runId = builder.runId;
        this.nodeIds = builder.nodeIds;
    }

    /**
     * <p>
     * The name of the workflow to resume.
     * </p>
     * 
     * @return The name of the workflow to resume.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The ID of the workflow run to resume.
     * </p>
     * 
     * @return The ID of the workflow run to resume.
     */
    public final String runId() {
        return runId;
    }

    /**
     * For responses, this returns true if the service returned a value for the NodeIds property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasNodeIds() {
        return nodeIds != null && !(nodeIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of the node IDs for the nodes you want to restart. The nodes that are to be restarted must have a run
     * attempt in the original run.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasNodeIds} method.
     * </p>
     * 
     * @return A list of the node IDs for the nodes you want to restart. The nodes that are to be restarted must have a
     *         run attempt in the original run.
     */
    public final List<String> nodeIds() {
        return nodeIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(runId());
        hashCode = 31 * hashCode + Objects.hashCode(hasNodeIds() ? nodeIds() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResumeWorkflowRunRequest)) {
            return false;
        }
        ResumeWorkflowRunRequest other = (ResumeWorkflowRunRequest) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(runId(), other.runId())
                && hasNodeIds() == other.hasNodeIds() && Objects.equals(nodeIds(), other.nodeIds());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ResumeWorkflowRunRequest").add("Name", name()).add("RunId", runId())
                .add("NodeIds", hasNodeIds() ? nodeIds() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "RunId":
            return Optional.ofNullable(clazz.cast(runId()));
        case "NodeIds":
            return Optional.ofNullable(clazz.cast(nodeIds()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ResumeWorkflowRunRequest, T> g) {
        return obj -> g.apply((ResumeWorkflowRunRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GlueRequest.Builder, SdkPojo, CopyableBuilder<Builder, ResumeWorkflowRunRequest> {
        /**
         * <p>
         * The name of the workflow to resume.
         * </p>
         * 
         * @param name
         *        The name of the workflow to resume.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The ID of the workflow run to resume.
         * </p>
         * 
         * @param runId
         *        The ID of the workflow run to resume.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder runId(String runId);

        /**
         * <p>
         * A list of the node IDs for the nodes you want to restart. The nodes that are to be restarted must have a run
         * attempt in the original run.
         * </p>
         * 
         * @param nodeIds
         *        A list of the node IDs for the nodes you want to restart. The nodes that are to be restarted must have
         *        a run attempt in the original run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nodeIds(Collection<String> nodeIds);

        /**
         * <p>
         * A list of the node IDs for the nodes you want to restart. The nodes that are to be restarted must have a run
         * attempt in the original run.
         * </p>
         * 
         * @param nodeIds
         *        A list of the node IDs for the nodes you want to restart. The nodes that are to be restarted must have
         *        a run attempt in the original run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nodeIds(String... nodeIds);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends GlueRequest.BuilderImpl implements Builder {
        private String name;

        private String runId;

        private List<String> nodeIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ResumeWorkflowRunRequest model) {
            super(model);
            name(model.name);
            runId(model.runId);
            nodeIds(model.nodeIds);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getRunId() {
            return runId;
        }

        public final void setRunId(String runId) {
            this.runId = runId;
        }

        @Override
        public final Builder runId(String runId) {
            this.runId = runId;
            return this;
        }

        public final Collection<String> getNodeIds() {
            if (nodeIds instanceof SdkAutoConstructList) {
                return null;
            }
            return nodeIds;
        }

        public final void setNodeIds(Collection<String> nodeIds) {
            this.nodeIds = NodeIdListCopier.copy(nodeIds);
        }

        @Override
        public final Builder nodeIds(Collection<String> nodeIds) {
            this.nodeIds = NodeIdListCopier.copy(nodeIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder nodeIds(String... nodeIds) {
            nodeIds(Arrays.asList(nodeIds));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ResumeWorkflowRunRequest build() {
            return new ResumeWorkflowRunRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
