/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies a transform that groups rows by chosen fields and computes the aggregated value by specified function.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Aggregate implements SdkPojo, Serializable, ToCopyableBuilder<Aggregate.Builder, Aggregate> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(Aggregate::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<List<String>> INPUTS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Inputs")
            .getter(getter(Aggregate::inputs))
            .setter(setter(Builder::inputs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Inputs").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<List<String>>> GROUPS_FIELD = SdkField
            .<List<List<String>>> builder(MarshallingType.LIST)
            .memberName("Groups")
            .getter(getter(Aggregate::groups))
            .setter(setter(Builder::groups))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Groups").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<List<String>> builder(MarshallingType.LIST)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build(),
                                                    ListTrait
                                                            .builder()
                                                            .memberLocationName(null)
                                                            .memberFieldInfo(
                                                                    SdkField.<String> builder(MarshallingType.STRING)
                                                                            .traits(LocationTrait.builder()
                                                                                    .location(MarshallLocation.PAYLOAD)
                                                                                    .locationName("member").build()).build())
                                                            .build()).build()).build()).build();

    private static final SdkField<List<AggregateOperation>> AGGS_FIELD = SdkField
            .<List<AggregateOperation>> builder(MarshallingType.LIST)
            .memberName("Aggs")
            .getter(getter(Aggregate::aggs))
            .setter(setter(Builder::aggs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Aggs").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AggregateOperation> builder(MarshallingType.SDK_POJO)
                                            .constructor(AggregateOperation::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, INPUTS_FIELD,
            GROUPS_FIELD, AGGS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String name;

    private final List<String> inputs;

    private final List<List<String>> groups;

    private final List<AggregateOperation> aggs;

    private Aggregate(BuilderImpl builder) {
        this.name = builder.name;
        this.inputs = builder.inputs;
        this.groups = builder.groups;
        this.aggs = builder.aggs;
    }

    /**
     * <p>
     * The name of the transform node.
     * </p>
     * 
     * @return The name of the transform node.
     */
    public final String name() {
        return name;
    }

    /**
     * For responses, this returns true if the service returned a value for the Inputs property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasInputs() {
        return inputs != null && !(inputs instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Specifies the fields and rows to use as inputs for the aggregate transform.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasInputs} method.
     * </p>
     * 
     * @return Specifies the fields and rows to use as inputs for the aggregate transform.
     */
    public final List<String> inputs() {
        return inputs;
    }

    /**
     * For responses, this returns true if the service returned a value for the Groups property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasGroups() {
        return groups != null && !(groups instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Specifies the fields to group by.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasGroups} method.
     * </p>
     * 
     * @return Specifies the fields to group by.
     */
    public final List<List<String>> groups() {
        return groups;
    }

    /**
     * For responses, this returns true if the service returned a value for the Aggs property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasAggs() {
        return aggs != null && !(aggs instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Specifies the aggregate functions to be performed on specified fields.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAggs} method.
     * </p>
     * 
     * @return Specifies the aggregate functions to be performed on specified fields.
     */
    public final List<AggregateOperation> aggs() {
        return aggs;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(hasInputs() ? inputs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasGroups() ? groups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasAggs() ? aggs() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Aggregate)) {
            return false;
        }
        Aggregate other = (Aggregate) obj;
        return Objects.equals(name(), other.name()) && hasInputs() == other.hasInputs()
                && Objects.equals(inputs(), other.inputs()) && hasGroups() == other.hasGroups()
                && Objects.equals(groups(), other.groups()) && hasAggs() == other.hasAggs()
                && Objects.equals(aggs(), other.aggs());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Aggregate").add("Name", name()).add("Inputs", hasInputs() ? inputs() : null)
                .add("Groups", hasGroups() ? groups() : null).add("Aggs", hasAggs() ? aggs() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Inputs":
            return Optional.ofNullable(clazz.cast(inputs()));
        case "Groups":
            return Optional.ofNullable(clazz.cast(groups()));
        case "Aggs":
            return Optional.ofNullable(clazz.cast(aggs()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Aggregate, T> g) {
        return obj -> g.apply((Aggregate) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Aggregate> {
        /**
         * <p>
         * The name of the transform node.
         * </p>
         * 
         * @param name
         *        The name of the transform node.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * Specifies the fields and rows to use as inputs for the aggregate transform.
         * </p>
         * 
         * @param inputs
         *        Specifies the fields and rows to use as inputs for the aggregate transform.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputs(Collection<String> inputs);

        /**
         * <p>
         * Specifies the fields and rows to use as inputs for the aggregate transform.
         * </p>
         * 
         * @param inputs
         *        Specifies the fields and rows to use as inputs for the aggregate transform.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputs(String... inputs);

        /**
         * <p>
         * Specifies the fields to group by.
         * </p>
         * 
         * @param groups
         *        Specifies the fields to group by.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groups(Collection<? extends Collection<String>> groups);

        /**
         * <p>
         * Specifies the fields to group by.
         * </p>
         * 
         * @param groups
         *        Specifies the fields to group by.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groups(Collection<String>... groups);

        /**
         * <p>
         * Specifies the aggregate functions to be performed on specified fields.
         * </p>
         * 
         * @param aggs
         *        Specifies the aggregate functions to be performed on specified fields.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder aggs(Collection<AggregateOperation> aggs);

        /**
         * <p>
         * Specifies the aggregate functions to be performed on specified fields.
         * </p>
         * 
         * @param aggs
         *        Specifies the aggregate functions to be performed on specified fields.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder aggs(AggregateOperation... aggs);

        /**
         * <p>
         * Specifies the aggregate functions to be performed on specified fields.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.glue.model.AggregateOperation.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.glue.model.AggregateOperation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.glue.model.AggregateOperation.Builder#build()} is called immediately
         * and its result is passed to {@link #aggs(List<AggregateOperation>)}.
         * 
         * @param aggs
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.glue.model.AggregateOperation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #aggs(java.util.Collection<AggregateOperation>)
         */
        Builder aggs(Consumer<AggregateOperation.Builder>... aggs);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private List<String> inputs = DefaultSdkAutoConstructList.getInstance();

        private List<List<String>> groups = DefaultSdkAutoConstructList.getInstance();

        private List<AggregateOperation> aggs = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Aggregate model) {
            name(model.name);
            inputs(model.inputs);
            groups(model.groups);
            aggs(model.aggs);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Collection<String> getInputs() {
            if (inputs instanceof SdkAutoConstructList) {
                return null;
            }
            return inputs;
        }

        public final void setInputs(Collection<String> inputs) {
            this.inputs = OneInputCopier.copy(inputs);
        }

        @Override
        public final Builder inputs(Collection<String> inputs) {
            this.inputs = OneInputCopier.copy(inputs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputs(String... inputs) {
            inputs(Arrays.asList(inputs));
            return this;
        }

        public final Collection<? extends Collection<String>> getGroups() {
            if (groups instanceof SdkAutoConstructList) {
                return null;
            }
            return groups;
        }

        public final void setGroups(Collection<? extends Collection<String>> groups) {
            this.groups = GlueStudioPathListCopier.copy(groups);
        }

        @Override
        public final Builder groups(Collection<? extends Collection<String>> groups) {
            this.groups = GlueStudioPathListCopier.copy(groups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groups(Collection<String>... groups) {
            groups(Arrays.asList(groups));
            return this;
        }

        public final List<AggregateOperation.Builder> getAggs() {
            List<AggregateOperation.Builder> result = AggregateOperationsCopier.copyToBuilder(this.aggs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAggs(Collection<AggregateOperation.BuilderImpl> aggs) {
            this.aggs = AggregateOperationsCopier.copyFromBuilder(aggs);
        }

        @Override
        public final Builder aggs(Collection<AggregateOperation> aggs) {
            this.aggs = AggregateOperationsCopier.copy(aggs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder aggs(AggregateOperation... aggs) {
            aggs(Arrays.asList(aggs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder aggs(Consumer<AggregateOperation.Builder>... aggs) {
            aggs(Stream.of(aggs).map(c -> AggregateOperation.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Aggregate build() {
            return new Aggregate(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
