/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.glue.GlueClient;
import software.amazon.awssdk.services.glue.internal.UserAgentUtils;
import software.amazon.awssdk.services.glue.model.GetUserDefinedFunctionsRequest;
import software.amazon.awssdk.services.glue.model.GetUserDefinedFunctionsResponse;

public class GetUserDefinedFunctionsIterable
implements SdkIterable<GetUserDefinedFunctionsResponse> {
    private final GlueClient client;
    private final GetUserDefinedFunctionsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public GetUserDefinedFunctionsIterable(GlueClient client, GetUserDefinedFunctionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new GetUserDefinedFunctionsResponseFetcher();
    }

    public Iterator<GetUserDefinedFunctionsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class GetUserDefinedFunctionsResponseFetcher
    implements SyncPageFetcher<GetUserDefinedFunctionsResponse> {
        private GetUserDefinedFunctionsResponseFetcher() {
        }

        public boolean hasNextPage(GetUserDefinedFunctionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public GetUserDefinedFunctionsResponse nextPage(GetUserDefinedFunctionsResponse previousPage) {
            if (previousPage == null) {
                return GetUserDefinedFunctionsIterable.this.client.getUserDefinedFunctions(GetUserDefinedFunctionsIterable.this.firstRequest);
            }
            return GetUserDefinedFunctionsIterable.this.client.getUserDefinedFunctions((GetUserDefinedFunctionsRequest)((Object)GetUserDefinedFunctionsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

