/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DynamoDBTarget
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DynamoDBTarget> {
    private static final SdkField<String> PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Path").getter(DynamoDBTarget.getter(DynamoDBTarget::path)).setter(DynamoDBTarget.setter(Builder::path)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Path").build()}).build();
    private static final SdkField<Boolean> SCAN_ALL_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("scanAll").getter(DynamoDBTarget.getter(DynamoDBTarget::scanAll)).setter(DynamoDBTarget.setter(Builder::scanAll)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scanAll").build()}).build();
    private static final SdkField<Double> SCAN_RATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("scanRate").getter(DynamoDBTarget.getter(DynamoDBTarget::scanRate)).setter(DynamoDBTarget.setter(Builder::scanRate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scanRate").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PATH_FIELD, SCAN_ALL_FIELD, SCAN_RATE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String path;
    private final Boolean scanAll;
    private final Double scanRate;

    private DynamoDBTarget(BuilderImpl builder) {
        this.path = builder.path;
        this.scanAll = builder.scanAll;
        this.scanRate = builder.scanRate;
    }

    public final String path() {
        return this.path;
    }

    public final Boolean scanAll() {
        return this.scanAll;
    }

    public final Double scanRate() {
        return this.scanRate;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.path());
        hashCode = 31 * hashCode + Objects.hashCode(this.scanAll());
        hashCode = 31 * hashCode + Objects.hashCode(this.scanRate());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DynamoDBTarget)) {
            return false;
        }
        DynamoDBTarget other = (DynamoDBTarget)obj;
        return Objects.equals(this.path(), other.path()) && Objects.equals(this.scanAll(), other.scanAll()) && Objects.equals(this.scanRate(), other.scanRate());
    }

    public final String toString() {
        return ToString.builder((String)"DynamoDBTarget").add("Path", (Object)this.path()).add("ScanAll", (Object)this.scanAll()).add("ScanRate", (Object)this.scanRate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Path": {
                return Optional.ofNullable(clazz.cast(this.path()));
            }
            case "scanAll": {
                return Optional.ofNullable(clazz.cast(this.scanAll()));
            }
            case "scanRate": {
                return Optional.ofNullable(clazz.cast(this.scanRate()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DynamoDBTarget, T> g) {
        return obj -> g.apply((DynamoDBTarget)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String path;
        private Boolean scanAll;
        private Double scanRate;

        private BuilderImpl() {
        }

        private BuilderImpl(DynamoDBTarget model) {
            this.path(model.path);
            this.scanAll(model.scanAll);
            this.scanRate(model.scanRate);
        }

        public final String getPath() {
            return this.path;
        }

        public final void setPath(String path) {
            this.path = path;
        }

        @Override
        public final Builder path(String path) {
            this.path = path;
            return this;
        }

        public final Boolean getScanAll() {
            return this.scanAll;
        }

        public final void setScanAll(Boolean scanAll) {
            this.scanAll = scanAll;
        }

        @Override
        public final Builder scanAll(Boolean scanAll) {
            this.scanAll = scanAll;
            return this;
        }

        public final Double getScanRate() {
            return this.scanRate;
        }

        public final void setScanRate(Double scanRate) {
            this.scanRate = scanRate;
        }

        @Override
        public final Builder scanRate(Double scanRate) {
            this.scanRate = scanRate;
            return this;
        }

        public DynamoDBTarget build() {
            return new DynamoDBTarget(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DynamoDBTarget> {
        public Builder path(String var1);

        public Builder scanAll(Boolean var1);

        public Builder scanRate(Double var1);
    }
}

