/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListCustomEntityTypesResponse extends GlueResponse implements
        ToCopyableBuilder<ListCustomEntityTypesResponse.Builder, ListCustomEntityTypesResponse> {
    private static final SdkField<List<CustomEntityType>> CUSTOM_ENTITY_TYPES_FIELD = SdkField
            .<List<CustomEntityType>> builder(MarshallingType.LIST)
            .memberName("CustomEntityTypes")
            .getter(getter(ListCustomEntityTypesResponse::customEntityTypes))
            .setter(setter(Builder::customEntityTypes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomEntityTypes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CustomEntityType> builder(MarshallingType.SDK_POJO)
                                            .constructor(CustomEntityType::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListCustomEntityTypesResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CUSTOM_ENTITY_TYPES_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<CustomEntityType> customEntityTypes;

    private final String nextToken;

    private ListCustomEntityTypesResponse(BuilderImpl builder) {
        super(builder);
        this.customEntityTypes = builder.customEntityTypes;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the CustomEntityTypes property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasCustomEntityTypes() {
        return customEntityTypes != null && !(customEntityTypes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of <code>CustomEntityType</code> objects representing custom patterns.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCustomEntityTypes} method.
     * </p>
     * 
     * @return A list of <code>CustomEntityType</code> objects representing custom patterns.
     */
    public final List<CustomEntityType> customEntityTypes() {
        return customEntityTypes;
    }

    /**
     * <p>
     * A pagination token, if more results are available.
     * </p>
     * 
     * @return A pagination token, if more results are available.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasCustomEntityTypes() ? customEntityTypes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListCustomEntityTypesResponse)) {
            return false;
        }
        ListCustomEntityTypesResponse other = (ListCustomEntityTypesResponse) obj;
        return hasCustomEntityTypes() == other.hasCustomEntityTypes()
                && Objects.equals(customEntityTypes(), other.customEntityTypes())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListCustomEntityTypesResponse")
                .add("CustomEntityTypes", hasCustomEntityTypes() ? customEntityTypes() : null).add("NextToken", nextToken())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CustomEntityTypes":
            return Optional.ofNullable(clazz.cast(customEntityTypes()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListCustomEntityTypesResponse, T> g) {
        return obj -> g.apply((ListCustomEntityTypesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GlueResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListCustomEntityTypesResponse> {
        /**
         * <p>
         * A list of <code>CustomEntityType</code> objects representing custom patterns.
         * </p>
         * 
         * @param customEntityTypes
         *        A list of <code>CustomEntityType</code> objects representing custom patterns.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customEntityTypes(Collection<CustomEntityType> customEntityTypes);

        /**
         * <p>
         * A list of <code>CustomEntityType</code> objects representing custom patterns.
         * </p>
         * 
         * @param customEntityTypes
         *        A list of <code>CustomEntityType</code> objects representing custom patterns.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customEntityTypes(CustomEntityType... customEntityTypes);

        /**
         * <p>
         * A list of <code>CustomEntityType</code> objects representing custom patterns.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.glue.model.CustomEntityType.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.glue.model.CustomEntityType#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.glue.model.CustomEntityType.Builder#build()} is called immediately and
         * its result is passed to {@link #customEntityTypes(List<CustomEntityType>)}.
         * 
         * @param customEntityTypes
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.glue.model.CustomEntityType.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #customEntityTypes(java.util.Collection<CustomEntityType>)
         */
        Builder customEntityTypes(Consumer<CustomEntityType.Builder>... customEntityTypes);

        /**
         * <p>
         * A pagination token, if more results are available.
         * </p>
         * 
         * @param nextToken
         *        A pagination token, if more results are available.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends GlueResponse.BuilderImpl implements Builder {
        private List<CustomEntityType> customEntityTypes = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListCustomEntityTypesResponse model) {
            super(model);
            customEntityTypes(model.customEntityTypes);
            nextToken(model.nextToken);
        }

        public final List<CustomEntityType.Builder> getCustomEntityTypes() {
            List<CustomEntityType.Builder> result = CustomEntityTypesCopier.copyToBuilder(this.customEntityTypes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCustomEntityTypes(Collection<CustomEntityType.BuilderImpl> customEntityTypes) {
            this.customEntityTypes = CustomEntityTypesCopier.copyFromBuilder(customEntityTypes);
        }

        @Override
        public final Builder customEntityTypes(Collection<CustomEntityType> customEntityTypes) {
            this.customEntityTypes = CustomEntityTypesCopier.copy(customEntityTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder customEntityTypes(CustomEntityType... customEntityTypes) {
            customEntityTypes(Arrays.asList(customEntityTypes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder customEntityTypes(Consumer<CustomEntityType.Builder>... customEntityTypes) {
            customEntityTypes(Stream.of(customEntityTypes).map(c -> CustomEntityType.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListCustomEntityTypesResponse build() {
            return new ListCustomEntityTypesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
