/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.glue.DefaultGlueBaseClientBuilder;
import software.amazon.awssdk.services.glue.DefaultGlueClient;
import software.amazon.awssdk.services.glue.GlueClient;
import software.amazon.awssdk.services.glue.GlueClientBuilder;
import software.amazon.awssdk.services.glue.GlueServiceClientConfiguration;
import software.amazon.awssdk.services.glue.endpoints.GlueEndpointProvider;

@SdkInternalApi
final class DefaultGlueClientBuilder
extends DefaultGlueBaseClientBuilder<GlueClientBuilder, GlueClient>
implements GlueClientBuilder {
    DefaultGlueClientBuilder() {
    }

    @Override
    public DefaultGlueClientBuilder endpointProvider(GlueEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final GlueClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.syncClientConfiguration();
        DefaultGlueClientBuilder.validateClientOptions(clientConfiguration);
        GlueServiceClientConfiguration serviceClientConfiguration = GlueServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfiguration.option((ClientOption)AwsClientOption.AWS_REGION)).build();
        return new DefaultGlueClient(serviceClientConfiguration, clientConfiguration);
    }
}

