/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class JobCommand
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, JobCommand> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(JobCommand.getter(JobCommand::name)).setter(JobCommand.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> SCRIPT_LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ScriptLocation").getter(JobCommand.getter(JobCommand::scriptLocation)).setter(JobCommand.setter(Builder::scriptLocation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScriptLocation").build()}).build();
    private static final SdkField<String> PYTHON_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PythonVersion").getter(JobCommand.getter(JobCommand::pythonVersion)).setter(JobCommand.setter(Builder::pythonVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PythonVersion").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, SCRIPT_LOCATION_FIELD, PYTHON_VERSION_FIELD));
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String scriptLocation;
    private final String pythonVersion;

    private JobCommand(BuilderImpl builder) {
        this.name = builder.name;
        this.scriptLocation = builder.scriptLocation;
        this.pythonVersion = builder.pythonVersion;
    }

    public final String name() {
        return this.name;
    }

    public final String scriptLocation() {
        return this.scriptLocation;
    }

    public final String pythonVersion() {
        return this.pythonVersion;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.scriptLocation());
        hashCode = 31 * hashCode + Objects.hashCode(this.pythonVersion());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JobCommand)) {
            return false;
        }
        JobCommand other = (JobCommand)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.scriptLocation(), other.scriptLocation()) && Objects.equals(this.pythonVersion(), other.pythonVersion());
    }

    public final String toString() {
        return ToString.builder((String)"JobCommand").add("Name", (Object)this.name()).add("ScriptLocation", (Object)this.scriptLocation()).add("PythonVersion", (Object)this.pythonVersion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "ScriptLocation": {
                return Optional.ofNullable(clazz.cast(this.scriptLocation()));
            }
            case "PythonVersion": {
                return Optional.ofNullable(clazz.cast(this.pythonVersion()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<JobCommand, T> g) {
        return obj -> g.apply((JobCommand)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String scriptLocation;
        private String pythonVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(JobCommand model) {
            this.name(model.name);
            this.scriptLocation(model.scriptLocation);
            this.pythonVersion(model.pythonVersion);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getScriptLocation() {
            return this.scriptLocation;
        }

        public final void setScriptLocation(String scriptLocation) {
            this.scriptLocation = scriptLocation;
        }

        @Override
        public final Builder scriptLocation(String scriptLocation) {
            this.scriptLocation = scriptLocation;
            return this;
        }

        public final String getPythonVersion() {
            return this.pythonVersion;
        }

        public final void setPythonVersion(String pythonVersion) {
            this.pythonVersion = pythonVersion;
        }

        @Override
        public final Builder pythonVersion(String pythonVersion) {
            this.pythonVersion = pythonVersion;
            return this;
        }

        public JobCommand build() {
            return new JobCommand(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, JobCommand> {
        public Builder name(String var1);

        public Builder scriptLocation(String var1);

        public Builder pythonVersion(String var1);
    }
}

