/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.glue.GlueAsyncClient;
import software.amazon.awssdk.services.glue.model.ListDataQualityRulesetsRequest;
import software.amazon.awssdk.services.glue.model.ListDataQualityRulesetsResponse;

public class ListDataQualityRulesetsPublisher
implements SdkPublisher<ListDataQualityRulesetsResponse> {
    private final GlueAsyncClient client;
    private final ListDataQualityRulesetsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListDataQualityRulesetsPublisher(GlueAsyncClient client, ListDataQualityRulesetsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListDataQualityRulesetsPublisher(GlueAsyncClient client, ListDataQualityRulesetsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListDataQualityRulesetsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListDataQualityRulesetsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListDataQualityRulesetsResponseFetcher
    implements AsyncPageFetcher<ListDataQualityRulesetsResponse> {
        private ListDataQualityRulesetsResponseFetcher() {
        }

        public boolean hasNextPage(ListDataQualityRulesetsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListDataQualityRulesetsResponse> nextPage(ListDataQualityRulesetsResponse previousPage) {
            if (previousPage == null) {
                return ListDataQualityRulesetsPublisher.this.client.listDataQualityRulesets(ListDataQualityRulesetsPublisher.this.firstRequest);
            }
            return ListDataQualityRulesetsPublisher.this.client.listDataQualityRulesets((ListDataQualityRulesetsRequest)((Object)ListDataQualityRulesetsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

