/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SchemaVersionNumber
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SchemaVersionNumber> {
    private static final SdkField<Boolean> LATEST_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("LatestVersion").getter(SchemaVersionNumber.getter(SchemaVersionNumber::latestVersion)).setter(SchemaVersionNumber.setter(Builder::latestVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LatestVersion").build()}).build();
    private static final SdkField<Long> VERSION_NUMBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("VersionNumber").getter(SchemaVersionNumber.getter(SchemaVersionNumber::versionNumber)).setter(SchemaVersionNumber.setter(Builder::versionNumber)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VersionNumber").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LATEST_VERSION_FIELD, VERSION_NUMBER_FIELD));
    private static final long serialVersionUID = 1L;
    private final Boolean latestVersion;
    private final Long versionNumber;

    private SchemaVersionNumber(BuilderImpl builder) {
        this.latestVersion = builder.latestVersion;
        this.versionNumber = builder.versionNumber;
    }

    public final Boolean latestVersion() {
        return this.latestVersion;
    }

    public final Long versionNumber() {
        return this.versionNumber;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.latestVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.versionNumber());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SchemaVersionNumber)) {
            return false;
        }
        SchemaVersionNumber other = (SchemaVersionNumber)obj;
        return Objects.equals(this.latestVersion(), other.latestVersion()) && Objects.equals(this.versionNumber(), other.versionNumber());
    }

    public final String toString() {
        return ToString.builder((String)"SchemaVersionNumber").add("LatestVersion", (Object)this.latestVersion()).add("VersionNumber", (Object)this.versionNumber()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LatestVersion": {
                return Optional.ofNullable(clazz.cast(this.latestVersion()));
            }
            case "VersionNumber": {
                return Optional.ofNullable(clazz.cast(this.versionNumber()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SchemaVersionNumber, T> g) {
        return obj -> g.apply((SchemaVersionNumber)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Boolean latestVersion;
        private Long versionNumber;

        private BuilderImpl() {
        }

        private BuilderImpl(SchemaVersionNumber model) {
            this.latestVersion(model.latestVersion);
            this.versionNumber(model.versionNumber);
        }

        public final Boolean getLatestVersion() {
            return this.latestVersion;
        }

        public final void setLatestVersion(Boolean latestVersion) {
            this.latestVersion = latestVersion;
        }

        @Override
        public final Builder latestVersion(Boolean latestVersion) {
            this.latestVersion = latestVersion;
            return this;
        }

        public final Long getVersionNumber() {
            return this.versionNumber;
        }

        public final void setVersionNumber(Long versionNumber) {
            this.versionNumber = versionNumber;
        }

        @Override
        public final Builder versionNumber(Long versionNumber) {
            this.versionNumber = versionNumber;
            return this;
        }

        public SchemaVersionNumber build() {
            return new SchemaVersionNumber(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SchemaVersionNumber> {
        public Builder latestVersion(Boolean var1);

        public Builder versionNumber(Long var1);
    }
}

