/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.glue.model.AuditContext;
import software.amazon.awssdk.services.glue.model.GlueRequest;
import software.amazon.awssdk.services.glue.model.PermissionType;
import software.amazon.awssdk.services.glue.model.PermissionTypeListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetUnfilteredTableMetadataRequest
extends GlueRequest
implements ToCopyableBuilder<Builder, GetUnfilteredTableMetadataRequest> {
    private static final SdkField<String> CATALOG_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CatalogId").getter(GetUnfilteredTableMetadataRequest.getter(GetUnfilteredTableMetadataRequest::catalogId)).setter(GetUnfilteredTableMetadataRequest.setter(Builder::catalogId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CatalogId").build()}).build();
    private static final SdkField<String> DATABASE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DatabaseName").getter(GetUnfilteredTableMetadataRequest.getter(GetUnfilteredTableMetadataRequest::databaseName)).setter(GetUnfilteredTableMetadataRequest.setter(Builder::databaseName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatabaseName").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(GetUnfilteredTableMetadataRequest.getter(GetUnfilteredTableMetadataRequest::name)).setter(GetUnfilteredTableMetadataRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<AuditContext> AUDIT_CONTEXT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AuditContext").getter(GetUnfilteredTableMetadataRequest.getter(GetUnfilteredTableMetadataRequest::auditContext)).setter(GetUnfilteredTableMetadataRequest.setter(Builder::auditContext)).constructor(AuditContext::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuditContext").build()}).build();
    private static final SdkField<List<String>> SUPPORTED_PERMISSION_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SupportedPermissionTypes").getter(GetUnfilteredTableMetadataRequest.getter(GetUnfilteredTableMetadataRequest::supportedPermissionTypesAsStrings)).setter(GetUnfilteredTableMetadataRequest.setter(Builder::supportedPermissionTypesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SupportedPermissionTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CATALOG_ID_FIELD, DATABASE_NAME_FIELD, NAME_FIELD, AUDIT_CONTEXT_FIELD, SUPPORTED_PERMISSION_TYPES_FIELD));
    private final String catalogId;
    private final String databaseName;
    private final String name;
    private final AuditContext auditContext;
    private final List<String> supportedPermissionTypes;

    private GetUnfilteredTableMetadataRequest(BuilderImpl builder) {
        super(builder);
        this.catalogId = builder.catalogId;
        this.databaseName = builder.databaseName;
        this.name = builder.name;
        this.auditContext = builder.auditContext;
        this.supportedPermissionTypes = builder.supportedPermissionTypes;
    }

    public final String catalogId() {
        return this.catalogId;
    }

    public final String databaseName() {
        return this.databaseName;
    }

    public final String name() {
        return this.name;
    }

    public final AuditContext auditContext() {
        return this.auditContext;
    }

    public final List<PermissionType> supportedPermissionTypes() {
        return PermissionTypeListCopier.copyStringToEnum(this.supportedPermissionTypes);
    }

    public final boolean hasSupportedPermissionTypes() {
        return this.supportedPermissionTypes != null && !(this.supportedPermissionTypes instanceof SdkAutoConstructList);
    }

    public final List<String> supportedPermissionTypesAsStrings() {
        return this.supportedPermissionTypes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.catalogId());
        hashCode = 31 * hashCode + Objects.hashCode(this.databaseName());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.auditContext());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSupportedPermissionTypes() ? this.supportedPermissionTypesAsStrings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetUnfilteredTableMetadataRequest)) {
            return false;
        }
        GetUnfilteredTableMetadataRequest other = (GetUnfilteredTableMetadataRequest)((Object)obj);
        return Objects.equals(this.catalogId(), other.catalogId()) && Objects.equals(this.databaseName(), other.databaseName()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.auditContext(), other.auditContext()) && this.hasSupportedPermissionTypes() == other.hasSupportedPermissionTypes() && Objects.equals(this.supportedPermissionTypesAsStrings(), other.supportedPermissionTypesAsStrings());
    }

    public final String toString() {
        return ToString.builder((String)"GetUnfilteredTableMetadataRequest").add("CatalogId", (Object)this.catalogId()).add("DatabaseName", (Object)this.databaseName()).add("Name", (Object)this.name()).add("AuditContext", (Object)this.auditContext()).add("SupportedPermissionTypes", this.hasSupportedPermissionTypes() ? this.supportedPermissionTypesAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CatalogId": {
                return Optional.ofNullable(clazz.cast(this.catalogId()));
            }
            case "DatabaseName": {
                return Optional.ofNullable(clazz.cast(this.databaseName()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "AuditContext": {
                return Optional.ofNullable(clazz.cast(this.auditContext()));
            }
            case "SupportedPermissionTypes": {
                return Optional.ofNullable(clazz.cast(this.supportedPermissionTypesAsStrings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetUnfilteredTableMetadataRequest, T> g) {
        return obj -> g.apply((GetUnfilteredTableMetadataRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GlueRequest.BuilderImpl
    implements Builder {
        private String catalogId;
        private String databaseName;
        private String name;
        private AuditContext auditContext;
        private List<String> supportedPermissionTypes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetUnfilteredTableMetadataRequest model) {
            super(model);
            this.catalogId(model.catalogId);
            this.databaseName(model.databaseName);
            this.name(model.name);
            this.auditContext(model.auditContext);
            this.supportedPermissionTypesWithStrings(model.supportedPermissionTypes);
        }

        public final String getCatalogId() {
            return this.catalogId;
        }

        public final void setCatalogId(String catalogId) {
            this.catalogId = catalogId;
        }

        @Override
        public final Builder catalogId(String catalogId) {
            this.catalogId = catalogId;
            return this;
        }

        public final String getDatabaseName() {
            return this.databaseName;
        }

        public final void setDatabaseName(String databaseName) {
            this.databaseName = databaseName;
        }

        @Override
        public final Builder databaseName(String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final AuditContext.Builder getAuditContext() {
            return this.auditContext != null ? this.auditContext.toBuilder() : null;
        }

        public final void setAuditContext(AuditContext.BuilderImpl auditContext) {
            this.auditContext = auditContext != null ? auditContext.build() : null;
        }

        @Override
        public final Builder auditContext(AuditContext auditContext) {
            this.auditContext = auditContext;
            return this;
        }

        public final Collection<String> getSupportedPermissionTypes() {
            if (this.supportedPermissionTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.supportedPermissionTypes;
        }

        public final void setSupportedPermissionTypes(Collection<String> supportedPermissionTypes) {
            this.supportedPermissionTypes = PermissionTypeListCopier.copy(supportedPermissionTypes);
        }

        @Override
        public final Builder supportedPermissionTypesWithStrings(Collection<String> supportedPermissionTypes) {
            this.supportedPermissionTypes = PermissionTypeListCopier.copy(supportedPermissionTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedPermissionTypesWithStrings(String ... supportedPermissionTypes) {
            this.supportedPermissionTypesWithStrings(Arrays.asList(supportedPermissionTypes));
            return this;
        }

        @Override
        public final Builder supportedPermissionTypes(Collection<PermissionType> supportedPermissionTypes) {
            this.supportedPermissionTypes = PermissionTypeListCopier.copyEnumToString(supportedPermissionTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedPermissionTypes(PermissionType ... supportedPermissionTypes) {
            this.supportedPermissionTypes(Arrays.asList(supportedPermissionTypes));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetUnfilteredTableMetadataRequest build() {
            return new GetUnfilteredTableMetadataRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends GlueRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetUnfilteredTableMetadataRequest> {
        public Builder catalogId(String var1);

        public Builder databaseName(String var1);

        public Builder name(String var1);

        public Builder auditContext(AuditContext var1);

        default public Builder auditContext(Consumer<AuditContext.Builder> auditContext) {
            return this.auditContext((AuditContext)((AuditContext.Builder)AuditContext.builder().applyMutation(auditContext)).build());
        }

        public Builder supportedPermissionTypesWithStrings(Collection<String> var1);

        public Builder supportedPermissionTypesWithStrings(String ... var1);

        public Builder supportedPermissionTypes(Collection<PermissionType> var1);

        public Builder supportedPermissionTypes(PermissionType ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

