/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.glue.GlueClient;
import software.amazon.awssdk.services.glue.model.ListDataQualityRulesetsRequest;
import software.amazon.awssdk.services.glue.model.ListDataQualityRulesetsResponse;

public class ListDataQualityRulesetsIterable
implements SdkIterable<ListDataQualityRulesetsResponse> {
    private final GlueClient client;
    private final ListDataQualityRulesetsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListDataQualityRulesetsIterable(GlueClient client, ListDataQualityRulesetsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListDataQualityRulesetsResponseFetcher();
    }

    public Iterator<ListDataQualityRulesetsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListDataQualityRulesetsResponseFetcher
    implements SyncPageFetcher<ListDataQualityRulesetsResponse> {
        private ListDataQualityRulesetsResponseFetcher() {
        }

        public boolean hasNextPage(ListDataQualityRulesetsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListDataQualityRulesetsResponse nextPage(ListDataQualityRulesetsResponse previousPage) {
            if (previousPage == null) {
                return ListDataQualityRulesetsIterable.this.client.listDataQualityRulesets(ListDataQualityRulesetsIterable.this.firstRequest);
            }
            return ListDataQualityRulesetsIterable.this.client.listDataQualityRulesets((ListDataQualityRulesetsRequest)((Object)ListDataQualityRulesetsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

