/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LongColumnStatisticsData
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LongColumnStatisticsData> {
    private static final SdkField<Long> MINIMUM_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("MinimumValue").getter(LongColumnStatisticsData.getter(LongColumnStatisticsData::minimumValue)).setter(LongColumnStatisticsData.setter(Builder::minimumValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MinimumValue").build()}).build();
    private static final SdkField<Long> MAXIMUM_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("MaximumValue").getter(LongColumnStatisticsData.getter(LongColumnStatisticsData::maximumValue)).setter(LongColumnStatisticsData.setter(Builder::maximumValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaximumValue").build()}).build();
    private static final SdkField<Long> NUMBER_OF_NULLS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("NumberOfNulls").getter(LongColumnStatisticsData.getter(LongColumnStatisticsData::numberOfNulls)).setter(LongColumnStatisticsData.setter(Builder::numberOfNulls)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberOfNulls").build()}).build();
    private static final SdkField<Long> NUMBER_OF_DISTINCT_VALUES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("NumberOfDistinctValues").getter(LongColumnStatisticsData.getter(LongColumnStatisticsData::numberOfDistinctValues)).setter(LongColumnStatisticsData.setter(Builder::numberOfDistinctValues)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberOfDistinctValues").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MINIMUM_VALUE_FIELD, MAXIMUM_VALUE_FIELD, NUMBER_OF_NULLS_FIELD, NUMBER_OF_DISTINCT_VALUES_FIELD));
    private static final long serialVersionUID = 1L;
    private final Long minimumValue;
    private final Long maximumValue;
    private final Long numberOfNulls;
    private final Long numberOfDistinctValues;

    private LongColumnStatisticsData(BuilderImpl builder) {
        this.minimumValue = builder.minimumValue;
        this.maximumValue = builder.maximumValue;
        this.numberOfNulls = builder.numberOfNulls;
        this.numberOfDistinctValues = builder.numberOfDistinctValues;
    }

    public final Long minimumValue() {
        return this.minimumValue;
    }

    public final Long maximumValue() {
        return this.maximumValue;
    }

    public final Long numberOfNulls() {
        return this.numberOfNulls;
    }

    public final Long numberOfDistinctValues() {
        return this.numberOfDistinctValues;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.minimumValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.maximumValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.numberOfNulls());
        hashCode = 31 * hashCode + Objects.hashCode(this.numberOfDistinctValues());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LongColumnStatisticsData)) {
            return false;
        }
        LongColumnStatisticsData other = (LongColumnStatisticsData)obj;
        return Objects.equals(this.minimumValue(), other.minimumValue()) && Objects.equals(this.maximumValue(), other.maximumValue()) && Objects.equals(this.numberOfNulls(), other.numberOfNulls()) && Objects.equals(this.numberOfDistinctValues(), other.numberOfDistinctValues());
    }

    public final String toString() {
        return ToString.builder((String)"LongColumnStatisticsData").add("MinimumValue", (Object)this.minimumValue()).add("MaximumValue", (Object)this.maximumValue()).add("NumberOfNulls", (Object)this.numberOfNulls()).add("NumberOfDistinctValues", (Object)this.numberOfDistinctValues()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MinimumValue": {
                return Optional.ofNullable(clazz.cast(this.minimumValue()));
            }
            case "MaximumValue": {
                return Optional.ofNullable(clazz.cast(this.maximumValue()));
            }
            case "NumberOfNulls": {
                return Optional.ofNullable(clazz.cast(this.numberOfNulls()));
            }
            case "NumberOfDistinctValues": {
                return Optional.ofNullable(clazz.cast(this.numberOfDistinctValues()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LongColumnStatisticsData, T> g) {
        return obj -> g.apply((LongColumnStatisticsData)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Long minimumValue;
        private Long maximumValue;
        private Long numberOfNulls;
        private Long numberOfDistinctValues;

        private BuilderImpl() {
        }

        private BuilderImpl(LongColumnStatisticsData model) {
            this.minimumValue(model.minimumValue);
            this.maximumValue(model.maximumValue);
            this.numberOfNulls(model.numberOfNulls);
            this.numberOfDistinctValues(model.numberOfDistinctValues);
        }

        public final Long getMinimumValue() {
            return this.minimumValue;
        }

        public final void setMinimumValue(Long minimumValue) {
            this.minimumValue = minimumValue;
        }

        @Override
        public final Builder minimumValue(Long minimumValue) {
            this.minimumValue = minimumValue;
            return this;
        }

        public final Long getMaximumValue() {
            return this.maximumValue;
        }

        public final void setMaximumValue(Long maximumValue) {
            this.maximumValue = maximumValue;
        }

        @Override
        public final Builder maximumValue(Long maximumValue) {
            this.maximumValue = maximumValue;
            return this;
        }

        public final Long getNumberOfNulls() {
            return this.numberOfNulls;
        }

        public final void setNumberOfNulls(Long numberOfNulls) {
            this.numberOfNulls = numberOfNulls;
        }

        @Override
        public final Builder numberOfNulls(Long numberOfNulls) {
            this.numberOfNulls = numberOfNulls;
            return this;
        }

        public final Long getNumberOfDistinctValues() {
            return this.numberOfDistinctValues;
        }

        public final void setNumberOfDistinctValues(Long numberOfDistinctValues) {
            this.numberOfDistinctValues = numberOfDistinctValues;
        }

        @Override
        public final Builder numberOfDistinctValues(Long numberOfDistinctValues) {
            this.numberOfDistinctValues = numberOfDistinctValues;
            return this;
        }

        public LongColumnStatisticsData build() {
            return new LongColumnStatisticsData(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LongColumnStatisticsData> {
        public Builder minimumValue(Long var1);

        public Builder maximumValue(Long var1);

        public Builder numberOfNulls(Long var1);

        public Builder numberOfDistinctValues(Long var1);
    }
}

