/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum QuoteChar {
    QUOTE("quote"),
    QUILLEMET("quillemet"),
    SINGLE_QUOTE("single_quote"),
    DISABLED("disabled"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, QuoteChar> VALUE_MAP;
    private final String value;

    private QuoteChar(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static QuoteChar fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<QuoteChar> knownValues() {
        EnumSet<QuoteChar> knownValues = EnumSet.allOf(QuoteChar.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(QuoteChar.class, QuoteChar::toString);
    }
}

