/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum RecrawlBehavior {
    CRAWL_EVERYTHING("CRAWL_EVERYTHING"),
    CRAWL_NEW_FOLDERS_ONLY("CRAWL_NEW_FOLDERS_ONLY"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, RecrawlBehavior> VALUE_MAP;
    private final String value;

    private RecrawlBehavior(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static RecrawlBehavior fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<RecrawlBehavior> knownValues() {
        EnumSet<RecrawlBehavior> knownValues = EnumSet.allOf(RecrawlBehavior.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(RecrawlBehavior.class, RecrawlBehavior::toString);
    }
}

