/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class WorkflowRunStatistics
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, WorkflowRunStatistics> {
    private static final SdkField<Integer> TOTAL_ACTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("TotalActions").getter(WorkflowRunStatistics.getter(WorkflowRunStatistics::totalActions)).setter(WorkflowRunStatistics.setter(Builder::totalActions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalActions").build()}).build();
    private static final SdkField<Integer> TIMEOUT_ACTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("TimeoutActions").getter(WorkflowRunStatistics.getter(WorkflowRunStatistics::timeoutActions)).setter(WorkflowRunStatistics.setter(Builder::timeoutActions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimeoutActions").build()}).build();
    private static final SdkField<Integer> FAILED_ACTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("FailedActions").getter(WorkflowRunStatistics.getter(WorkflowRunStatistics::failedActions)).setter(WorkflowRunStatistics.setter(Builder::failedActions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailedActions").build()}).build();
    private static final SdkField<Integer> STOPPED_ACTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("StoppedActions").getter(WorkflowRunStatistics.getter(WorkflowRunStatistics::stoppedActions)).setter(WorkflowRunStatistics.setter(Builder::stoppedActions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StoppedActions").build()}).build();
    private static final SdkField<Integer> SUCCEEDED_ACTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("SucceededActions").getter(WorkflowRunStatistics.getter(WorkflowRunStatistics::succeededActions)).setter(WorkflowRunStatistics.setter(Builder::succeededActions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SucceededActions").build()}).build();
    private static final SdkField<Integer> RUNNING_ACTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("RunningActions").getter(WorkflowRunStatistics.getter(WorkflowRunStatistics::runningActions)).setter(WorkflowRunStatistics.setter(Builder::runningActions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RunningActions").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TOTAL_ACTIONS_FIELD, TIMEOUT_ACTIONS_FIELD, FAILED_ACTIONS_FIELD, STOPPED_ACTIONS_FIELD, SUCCEEDED_ACTIONS_FIELD, RUNNING_ACTIONS_FIELD));
    private static final long serialVersionUID = 1L;
    private final Integer totalActions;
    private final Integer timeoutActions;
    private final Integer failedActions;
    private final Integer stoppedActions;
    private final Integer succeededActions;
    private final Integer runningActions;

    private WorkflowRunStatistics(BuilderImpl builder) {
        this.totalActions = builder.totalActions;
        this.timeoutActions = builder.timeoutActions;
        this.failedActions = builder.failedActions;
        this.stoppedActions = builder.stoppedActions;
        this.succeededActions = builder.succeededActions;
        this.runningActions = builder.runningActions;
    }

    public final Integer totalActions() {
        return this.totalActions;
    }

    public final Integer timeoutActions() {
        return this.timeoutActions;
    }

    public final Integer failedActions() {
        return this.failedActions;
    }

    public final Integer stoppedActions() {
        return this.stoppedActions;
    }

    public final Integer succeededActions() {
        return this.succeededActions;
    }

    public final Integer runningActions() {
        return this.runningActions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.totalActions());
        hashCode = 31 * hashCode + Objects.hashCode(this.timeoutActions());
        hashCode = 31 * hashCode + Objects.hashCode(this.failedActions());
        hashCode = 31 * hashCode + Objects.hashCode(this.stoppedActions());
        hashCode = 31 * hashCode + Objects.hashCode(this.succeededActions());
        hashCode = 31 * hashCode + Objects.hashCode(this.runningActions());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WorkflowRunStatistics)) {
            return false;
        }
        WorkflowRunStatistics other = (WorkflowRunStatistics)obj;
        return Objects.equals(this.totalActions(), other.totalActions()) && Objects.equals(this.timeoutActions(), other.timeoutActions()) && Objects.equals(this.failedActions(), other.failedActions()) && Objects.equals(this.stoppedActions(), other.stoppedActions()) && Objects.equals(this.succeededActions(), other.succeededActions()) && Objects.equals(this.runningActions(), other.runningActions());
    }

    public final String toString() {
        return ToString.builder((String)"WorkflowRunStatistics").add("TotalActions", (Object)this.totalActions()).add("TimeoutActions", (Object)this.timeoutActions()).add("FailedActions", (Object)this.failedActions()).add("StoppedActions", (Object)this.stoppedActions()).add("SucceededActions", (Object)this.succeededActions()).add("RunningActions", (Object)this.runningActions()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TotalActions": {
                return Optional.ofNullable(clazz.cast(this.totalActions()));
            }
            case "TimeoutActions": {
                return Optional.ofNullable(clazz.cast(this.timeoutActions()));
            }
            case "FailedActions": {
                return Optional.ofNullable(clazz.cast(this.failedActions()));
            }
            case "StoppedActions": {
                return Optional.ofNullable(clazz.cast(this.stoppedActions()));
            }
            case "SucceededActions": {
                return Optional.ofNullable(clazz.cast(this.succeededActions()));
            }
            case "RunningActions": {
                return Optional.ofNullable(clazz.cast(this.runningActions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<WorkflowRunStatistics, T> g) {
        return obj -> g.apply((WorkflowRunStatistics)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer totalActions;
        private Integer timeoutActions;
        private Integer failedActions;
        private Integer stoppedActions;
        private Integer succeededActions;
        private Integer runningActions;

        private BuilderImpl() {
        }

        private BuilderImpl(WorkflowRunStatistics model) {
            this.totalActions(model.totalActions);
            this.timeoutActions(model.timeoutActions);
            this.failedActions(model.failedActions);
            this.stoppedActions(model.stoppedActions);
            this.succeededActions(model.succeededActions);
            this.runningActions(model.runningActions);
        }

        public final Integer getTotalActions() {
            return this.totalActions;
        }

        public final void setTotalActions(Integer totalActions) {
            this.totalActions = totalActions;
        }

        @Override
        public final Builder totalActions(Integer totalActions) {
            this.totalActions = totalActions;
            return this;
        }

        public final Integer getTimeoutActions() {
            return this.timeoutActions;
        }

        public final void setTimeoutActions(Integer timeoutActions) {
            this.timeoutActions = timeoutActions;
        }

        @Override
        public final Builder timeoutActions(Integer timeoutActions) {
            this.timeoutActions = timeoutActions;
            return this;
        }

        public final Integer getFailedActions() {
            return this.failedActions;
        }

        public final void setFailedActions(Integer failedActions) {
            this.failedActions = failedActions;
        }

        @Override
        public final Builder failedActions(Integer failedActions) {
            this.failedActions = failedActions;
            return this;
        }

        public final Integer getStoppedActions() {
            return this.stoppedActions;
        }

        public final void setStoppedActions(Integer stoppedActions) {
            this.stoppedActions = stoppedActions;
        }

        @Override
        public final Builder stoppedActions(Integer stoppedActions) {
            this.stoppedActions = stoppedActions;
            return this;
        }

        public final Integer getSucceededActions() {
            return this.succeededActions;
        }

        public final void setSucceededActions(Integer succeededActions) {
            this.succeededActions = succeededActions;
        }

        @Override
        public final Builder succeededActions(Integer succeededActions) {
            this.succeededActions = succeededActions;
            return this;
        }

        public final Integer getRunningActions() {
            return this.runningActions;
        }

        public final void setRunningActions(Integer runningActions) {
            this.runningActions = runningActions;
        }

        @Override
        public final Builder runningActions(Integer runningActions) {
            this.runningActions = runningActions;
            return this;
        }

        public WorkflowRunStatistics build() {
            return new WorkflowRunStatistics(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, WorkflowRunStatistics> {
        public Builder totalActions(Integer var1);

        public Builder timeoutActions(Integer var1);

        public Builder failedActions(Integer var1);

        public Builder stoppedActions(Integer var1);

        public Builder succeededActions(Integer var1);

        public Builder runningActions(Integer var1);
    }
}

