/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.glue.model.DatabaseIdentifier;
import software.amazon.awssdk.services.glue.model.ParametersMapCopier;
import software.amazon.awssdk.services.glue.model.PrincipalPermissions;
import software.amazon.awssdk.services.glue.model.PrincipalPermissionsListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Database
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Database> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(Database.getter(Database::name)).setter(Database.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(Database.getter(Database::description)).setter(Database.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> LOCATION_URI_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LocationUri").getter(Database.getter(Database::locationUri)).setter(Database.setter(Builder::locationUri)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LocationUri").build()}).build();
    private static final SdkField<Map<String, String>> PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Parameters").getter(Database.getter(Database::parameters)).setter(Database.setter(Builder::parameters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Parameters").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Instant> CREATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreateTime").getter(Database.getter(Database::createTime)).setter(Database.setter(Builder::createTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreateTime").build()}).build();
    private static final SdkField<List<PrincipalPermissions>> CREATE_TABLE_DEFAULT_PERMISSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("CreateTableDefaultPermissions").getter(Database.getter(Database::createTableDefaultPermissions)).setter(Database.setter(Builder::createTableDefaultPermissions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreateTableDefaultPermissions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PrincipalPermissions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<DatabaseIdentifier> TARGET_DATABASE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TargetDatabase").getter(Database.getter(Database::targetDatabase)).setter(Database.setter(Builder::targetDatabase)).constructor(DatabaseIdentifier::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetDatabase").build()}).build();
    private static final SdkField<String> CATALOG_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CatalogId").getter(Database.getter(Database::catalogId)).setter(Database.setter(Builder::catalogId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CatalogId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DESCRIPTION_FIELD, LOCATION_URI_FIELD, PARAMETERS_FIELD, CREATE_TIME_FIELD, CREATE_TABLE_DEFAULT_PERMISSIONS_FIELD, TARGET_DATABASE_FIELD, CATALOG_ID_FIELD));
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String description;
    private final String locationUri;
    private final Map<String, String> parameters;
    private final Instant createTime;
    private final List<PrincipalPermissions> createTableDefaultPermissions;
    private final DatabaseIdentifier targetDatabase;
    private final String catalogId;

    private Database(BuilderImpl builder) {
        this.name = builder.name;
        this.description = builder.description;
        this.locationUri = builder.locationUri;
        this.parameters = builder.parameters;
        this.createTime = builder.createTime;
        this.createTableDefaultPermissions = builder.createTableDefaultPermissions;
        this.targetDatabase = builder.targetDatabase;
        this.catalogId = builder.catalogId;
    }

    public final String name() {
        return this.name;
    }

    public final String description() {
        return this.description;
    }

    public final String locationUri() {
        return this.locationUri;
    }

    public final boolean hasParameters() {
        return this.parameters != null && !(this.parameters instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> parameters() {
        return this.parameters;
    }

    public final Instant createTime() {
        return this.createTime;
    }

    public final boolean hasCreateTableDefaultPermissions() {
        return this.createTableDefaultPermissions != null && !(this.createTableDefaultPermissions instanceof SdkAutoConstructList);
    }

    public final List<PrincipalPermissions> createTableDefaultPermissions() {
        return this.createTableDefaultPermissions;
    }

    public final DatabaseIdentifier targetDatabase() {
        return this.targetDatabase;
    }

    public final String catalogId() {
        return this.catalogId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.locationUri());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasParameters() ? this.parameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.createTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCreateTableDefaultPermissions() ? this.createTableDefaultPermissions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.targetDatabase());
        hashCode = 31 * hashCode + Objects.hashCode(this.catalogId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Database)) {
            return false;
        }
        Database other = (Database)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.locationUri(), other.locationUri()) && this.hasParameters() == other.hasParameters() && Objects.equals(this.parameters(), other.parameters()) && Objects.equals(this.createTime(), other.createTime()) && this.hasCreateTableDefaultPermissions() == other.hasCreateTableDefaultPermissions() && Objects.equals(this.createTableDefaultPermissions(), other.createTableDefaultPermissions()) && Objects.equals(this.targetDatabase(), other.targetDatabase()) && Objects.equals(this.catalogId(), other.catalogId());
    }

    public final String toString() {
        return ToString.builder((String)"Database").add("Name", (Object)this.name()).add("Description", (Object)this.description()).add("LocationUri", (Object)this.locationUri()).add("Parameters", this.hasParameters() ? this.parameters() : null).add("CreateTime", (Object)this.createTime()).add("CreateTableDefaultPermissions", this.hasCreateTableDefaultPermissions() ? this.createTableDefaultPermissions() : null).add("TargetDatabase", (Object)this.targetDatabase()).add("CatalogId", (Object)this.catalogId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "LocationUri": {
                return Optional.ofNullable(clazz.cast(this.locationUri()));
            }
            case "Parameters": {
                return Optional.ofNullable(clazz.cast(this.parameters()));
            }
            case "CreateTime": {
                return Optional.ofNullable(clazz.cast(this.createTime()));
            }
            case "CreateTableDefaultPermissions": {
                return Optional.ofNullable(clazz.cast(this.createTableDefaultPermissions()));
            }
            case "TargetDatabase": {
                return Optional.ofNullable(clazz.cast(this.targetDatabase()));
            }
            case "CatalogId": {
                return Optional.ofNullable(clazz.cast(this.catalogId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Database, T> g) {
        return obj -> g.apply((Database)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String description;
        private String locationUri;
        private Map<String, String> parameters = DefaultSdkAutoConstructMap.getInstance();
        private Instant createTime;
        private List<PrincipalPermissions> createTableDefaultPermissions = DefaultSdkAutoConstructList.getInstance();
        private DatabaseIdentifier targetDatabase;
        private String catalogId;

        private BuilderImpl() {
        }

        private BuilderImpl(Database model) {
            this.name(model.name);
            this.description(model.description);
            this.locationUri(model.locationUri);
            this.parameters(model.parameters);
            this.createTime(model.createTime);
            this.createTableDefaultPermissions(model.createTableDefaultPermissions);
            this.targetDatabase(model.targetDatabase);
            this.catalogId(model.catalogId);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getLocationUri() {
            return this.locationUri;
        }

        public final void setLocationUri(String locationUri) {
            this.locationUri = locationUri;
        }

        @Override
        public final Builder locationUri(String locationUri) {
            this.locationUri = locationUri;
            return this;
        }

        public final Map<String, String> getParameters() {
            if (this.parameters instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.parameters;
        }

        public final void setParameters(Map<String, String> parameters) {
            this.parameters = ParametersMapCopier.copy(parameters);
        }

        @Override
        public final Builder parameters(Map<String, String> parameters) {
            this.parameters = ParametersMapCopier.copy(parameters);
            return this;
        }

        public final Instant getCreateTime() {
            return this.createTime;
        }

        public final void setCreateTime(Instant createTime) {
            this.createTime = createTime;
        }

        @Override
        public final Builder createTime(Instant createTime) {
            this.createTime = createTime;
            return this;
        }

        public final List<PrincipalPermissions.Builder> getCreateTableDefaultPermissions() {
            List<PrincipalPermissions.Builder> result = PrincipalPermissionsListCopier.copyToBuilder(this.createTableDefaultPermissions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCreateTableDefaultPermissions(Collection<PrincipalPermissions.BuilderImpl> createTableDefaultPermissions) {
            this.createTableDefaultPermissions = PrincipalPermissionsListCopier.copyFromBuilder(createTableDefaultPermissions);
        }

        @Override
        public final Builder createTableDefaultPermissions(Collection<PrincipalPermissions> createTableDefaultPermissions) {
            this.createTableDefaultPermissions = PrincipalPermissionsListCopier.copy(createTableDefaultPermissions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder createTableDefaultPermissions(PrincipalPermissions ... createTableDefaultPermissions) {
            this.createTableDefaultPermissions(Arrays.asList(createTableDefaultPermissions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder createTableDefaultPermissions(Consumer<PrincipalPermissions.Builder> ... createTableDefaultPermissions) {
            this.createTableDefaultPermissions(Stream.of(createTableDefaultPermissions).map(c -> (PrincipalPermissions)((PrincipalPermissions.Builder)PrincipalPermissions.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final DatabaseIdentifier.Builder getTargetDatabase() {
            return this.targetDatabase != null ? this.targetDatabase.toBuilder() : null;
        }

        public final void setTargetDatabase(DatabaseIdentifier.BuilderImpl targetDatabase) {
            this.targetDatabase = targetDatabase != null ? targetDatabase.build() : null;
        }

        @Override
        public final Builder targetDatabase(DatabaseIdentifier targetDatabase) {
            this.targetDatabase = targetDatabase;
            return this;
        }

        public final String getCatalogId() {
            return this.catalogId;
        }

        public final void setCatalogId(String catalogId) {
            this.catalogId = catalogId;
        }

        @Override
        public final Builder catalogId(String catalogId) {
            this.catalogId = catalogId;
            return this;
        }

        public Database build() {
            return new Database(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Database> {
        public Builder name(String var1);

        public Builder description(String var1);

        public Builder locationUri(String var1);

        public Builder parameters(Map<String, String> var1);

        public Builder createTime(Instant var1);

        public Builder createTableDefaultPermissions(Collection<PrincipalPermissions> var1);

        public Builder createTableDefaultPermissions(PrincipalPermissions ... var1);

        public Builder createTableDefaultPermissions(Consumer<PrincipalPermissions.Builder> ... var1);

        public Builder targetDatabase(DatabaseIdentifier var1);

        default public Builder targetDatabase(Consumer<DatabaseIdentifier.Builder> targetDatabase) {
            return this.targetDatabase((DatabaseIdentifier)((DatabaseIdentifier.Builder)DatabaseIdentifier.builder().applyMutation(targetDatabase)).build());
        }

        public Builder catalogId(String var1);
    }
}

