/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.glue.model.BoundedPartitionValueListCopier;
import software.amazon.awssdk.services.glue.model.PartitionInput;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchUpdatePartitionRequestEntry
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, BatchUpdatePartitionRequestEntry> {
    private static final SdkField<List<String>> PARTITION_VALUE_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("PartitionValueList").getter(BatchUpdatePartitionRequestEntry.getter(BatchUpdatePartitionRequestEntry::partitionValueList)).setter(BatchUpdatePartitionRequestEntry.setter(Builder::partitionValueList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PartitionValueList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<PartitionInput> PARTITION_INPUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("PartitionInput").getter(BatchUpdatePartitionRequestEntry.getter(BatchUpdatePartitionRequestEntry::partitionInput)).setter(BatchUpdatePartitionRequestEntry.setter(Builder::partitionInput)).constructor(PartitionInput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PartitionInput").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PARTITION_VALUE_LIST_FIELD, PARTITION_INPUT_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<String> partitionValueList;
    private final PartitionInput partitionInput;

    private BatchUpdatePartitionRequestEntry(BuilderImpl builder) {
        this.partitionValueList = builder.partitionValueList;
        this.partitionInput = builder.partitionInput;
    }

    public final boolean hasPartitionValueList() {
        return this.partitionValueList != null && !(this.partitionValueList instanceof SdkAutoConstructList);
    }

    public final List<String> partitionValueList() {
        return this.partitionValueList;
    }

    public final PartitionInput partitionInput() {
        return this.partitionInput;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPartitionValueList() ? this.partitionValueList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.partitionInput());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchUpdatePartitionRequestEntry)) {
            return false;
        }
        BatchUpdatePartitionRequestEntry other = (BatchUpdatePartitionRequestEntry)obj;
        return this.hasPartitionValueList() == other.hasPartitionValueList() && Objects.equals(this.partitionValueList(), other.partitionValueList()) && Objects.equals(this.partitionInput(), other.partitionInput());
    }

    public final String toString() {
        return ToString.builder((String)"BatchUpdatePartitionRequestEntry").add("PartitionValueList", this.hasPartitionValueList() ? this.partitionValueList() : null).add("PartitionInput", (Object)this.partitionInput()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PartitionValueList": {
                return Optional.ofNullable(clazz.cast(this.partitionValueList()));
            }
            case "PartitionInput": {
                return Optional.ofNullable(clazz.cast(this.partitionInput()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchUpdatePartitionRequestEntry, T> g) {
        return obj -> g.apply((BatchUpdatePartitionRequestEntry)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> partitionValueList = DefaultSdkAutoConstructList.getInstance();
        private PartitionInput partitionInput;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchUpdatePartitionRequestEntry model) {
            this.partitionValueList(model.partitionValueList);
            this.partitionInput(model.partitionInput);
        }

        public final Collection<String> getPartitionValueList() {
            if (this.partitionValueList instanceof SdkAutoConstructList) {
                return null;
            }
            return this.partitionValueList;
        }

        public final void setPartitionValueList(Collection<String> partitionValueList) {
            this.partitionValueList = BoundedPartitionValueListCopier.copy(partitionValueList);
        }

        @Override
        @Transient
        public final Builder partitionValueList(Collection<String> partitionValueList) {
            this.partitionValueList = BoundedPartitionValueListCopier.copy(partitionValueList);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder partitionValueList(String ... partitionValueList) {
            this.partitionValueList(Arrays.asList(partitionValueList));
            return this;
        }

        public final PartitionInput.Builder getPartitionInput() {
            return this.partitionInput != null ? this.partitionInput.toBuilder() : null;
        }

        public final void setPartitionInput(PartitionInput.BuilderImpl partitionInput) {
            this.partitionInput = partitionInput != null ? partitionInput.build() : null;
        }

        @Override
        @Transient
        public final Builder partitionInput(PartitionInput partitionInput) {
            this.partitionInput = partitionInput;
            return this;
        }

        public BatchUpdatePartitionRequestEntry build() {
            return new BatchUpdatePartitionRequestEntry(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, BatchUpdatePartitionRequestEntry> {
        public Builder partitionValueList(Collection<String> var1);

        public Builder partitionValueList(String ... var1);

        public Builder partitionInput(PartitionInput var1);

        default public Builder partitionInput(Consumer<PartitionInput.Builder> partitionInput) {
            return this.partitionInput((PartitionInput)((PartitionInput.Builder)PartitionInput.builder().applyMutation(partitionInput)).build());
        }
    }
}

