/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.glue.model.GlueRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RunStatementRequest
extends GlueRequest
implements ToCopyableBuilder<Builder, RunStatementRequest> {
    private static final SdkField<String> SESSION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SessionId").getter(RunStatementRequest.getter(RunStatementRequest::sessionId)).setter(RunStatementRequest.setter(Builder::sessionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SessionId").build()}).build();
    private static final SdkField<String> CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Code").getter(RunStatementRequest.getter(RunStatementRequest::code)).setter(RunStatementRequest.setter(Builder::code)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Code").build()}).build();
    private static final SdkField<String> REQUEST_ORIGIN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RequestOrigin").getter(RunStatementRequest.getter(RunStatementRequest::requestOrigin)).setter(RunStatementRequest.setter(Builder::requestOrigin)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestOrigin").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SESSION_ID_FIELD, CODE_FIELD, REQUEST_ORIGIN_FIELD));
    private final String sessionId;
    private final String code;
    private final String requestOrigin;

    private RunStatementRequest(BuilderImpl builder) {
        super(builder);
        this.sessionId = builder.sessionId;
        this.code = builder.code;
        this.requestOrigin = builder.requestOrigin;
    }

    public final String sessionId() {
        return this.sessionId;
    }

    public final String code() {
        return this.code;
    }

    public final String requestOrigin() {
        return this.requestOrigin;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.sessionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.code());
        hashCode = 31 * hashCode + Objects.hashCode(this.requestOrigin());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RunStatementRequest)) {
            return false;
        }
        RunStatementRequest other = (RunStatementRequest)((Object)obj);
        return Objects.equals(this.sessionId(), other.sessionId()) && Objects.equals(this.code(), other.code()) && Objects.equals(this.requestOrigin(), other.requestOrigin());
    }

    public final String toString() {
        return ToString.builder((String)"RunStatementRequest").add("SessionId", (Object)this.sessionId()).add("Code", (Object)this.code()).add("RequestOrigin", (Object)this.requestOrigin()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SessionId": {
                return Optional.ofNullable(clazz.cast(this.sessionId()));
            }
            case "Code": {
                return Optional.ofNullable(clazz.cast(this.code()));
            }
            case "RequestOrigin": {
                return Optional.ofNullable(clazz.cast(this.requestOrigin()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RunStatementRequest, T> g) {
        return obj -> g.apply((RunStatementRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GlueRequest.BuilderImpl
    implements Builder {
        private String sessionId;
        private String code;
        private String requestOrigin;

        private BuilderImpl() {
        }

        private BuilderImpl(RunStatementRequest model) {
            super(model);
            this.sessionId(model.sessionId);
            this.code(model.code);
            this.requestOrigin(model.requestOrigin);
        }

        public final String getSessionId() {
            return this.sessionId;
        }

        public final void setSessionId(String sessionId) {
            this.sessionId = sessionId;
        }

        @Override
        @Transient
        public final Builder sessionId(String sessionId) {
            this.sessionId = sessionId;
            return this;
        }

        public final String getCode() {
            return this.code;
        }

        public final void setCode(String code) {
            this.code = code;
        }

        @Override
        @Transient
        public final Builder code(String code) {
            this.code = code;
            return this;
        }

        public final String getRequestOrigin() {
            return this.requestOrigin;
        }

        public final void setRequestOrigin(String requestOrigin) {
            this.requestOrigin = requestOrigin;
        }

        @Override
        @Transient
        public final Builder requestOrigin(String requestOrigin) {
            this.requestOrigin = requestOrigin;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RunStatementRequest build() {
            return new RunStatementRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends GlueRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, RunStatementRequest> {
        public Builder sessionId(String var1);

        public Builder code(String var1);

        public Builder requestOrigin(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

