/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.glue.model.DataCatalogEncryptionSettings;
import software.amazon.awssdk.services.glue.model.GlueRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PutDataCatalogEncryptionSettingsRequest
extends GlueRequest
implements ToCopyableBuilder<Builder, PutDataCatalogEncryptionSettingsRequest> {
    private static final SdkField<String> CATALOG_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CatalogId").getter(PutDataCatalogEncryptionSettingsRequest.getter(PutDataCatalogEncryptionSettingsRequest::catalogId)).setter(PutDataCatalogEncryptionSettingsRequest.setter(Builder::catalogId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CatalogId").build()}).build();
    private static final SdkField<DataCatalogEncryptionSettings> DATA_CATALOG_ENCRYPTION_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DataCatalogEncryptionSettings").getter(PutDataCatalogEncryptionSettingsRequest.getter(PutDataCatalogEncryptionSettingsRequest::dataCatalogEncryptionSettings)).setter(PutDataCatalogEncryptionSettingsRequest.setter(Builder::dataCatalogEncryptionSettings)).constructor(DataCatalogEncryptionSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataCatalogEncryptionSettings").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CATALOG_ID_FIELD, DATA_CATALOG_ENCRYPTION_SETTINGS_FIELD));
    private final String catalogId;
    private final DataCatalogEncryptionSettings dataCatalogEncryptionSettings;

    private PutDataCatalogEncryptionSettingsRequest(BuilderImpl builder) {
        super(builder);
        this.catalogId = builder.catalogId;
        this.dataCatalogEncryptionSettings = builder.dataCatalogEncryptionSettings;
    }

    public final String catalogId() {
        return this.catalogId;
    }

    public final DataCatalogEncryptionSettings dataCatalogEncryptionSettings() {
        return this.dataCatalogEncryptionSettings;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.catalogId());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataCatalogEncryptionSettings());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutDataCatalogEncryptionSettingsRequest)) {
            return false;
        }
        PutDataCatalogEncryptionSettingsRequest other = (PutDataCatalogEncryptionSettingsRequest)((Object)obj);
        return Objects.equals(this.catalogId(), other.catalogId()) && Objects.equals(this.dataCatalogEncryptionSettings(), other.dataCatalogEncryptionSettings());
    }

    public final String toString() {
        return ToString.builder((String)"PutDataCatalogEncryptionSettingsRequest").add("CatalogId", (Object)this.catalogId()).add("DataCatalogEncryptionSettings", (Object)this.dataCatalogEncryptionSettings()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CatalogId": {
                return Optional.ofNullable(clazz.cast(this.catalogId()));
            }
            case "DataCatalogEncryptionSettings": {
                return Optional.ofNullable(clazz.cast(this.dataCatalogEncryptionSettings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutDataCatalogEncryptionSettingsRequest, T> g) {
        return obj -> g.apply((PutDataCatalogEncryptionSettingsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GlueRequest.BuilderImpl
    implements Builder {
        private String catalogId;
        private DataCatalogEncryptionSettings dataCatalogEncryptionSettings;

        private BuilderImpl() {
        }

        private BuilderImpl(PutDataCatalogEncryptionSettingsRequest model) {
            super(model);
            this.catalogId(model.catalogId);
            this.dataCatalogEncryptionSettings(model.dataCatalogEncryptionSettings);
        }

        public final String getCatalogId() {
            return this.catalogId;
        }

        public final void setCatalogId(String catalogId) {
            this.catalogId = catalogId;
        }

        @Override
        @Transient
        public final Builder catalogId(String catalogId) {
            this.catalogId = catalogId;
            return this;
        }

        public final DataCatalogEncryptionSettings.Builder getDataCatalogEncryptionSettings() {
            return this.dataCatalogEncryptionSettings != null ? this.dataCatalogEncryptionSettings.toBuilder() : null;
        }

        public final void setDataCatalogEncryptionSettings(DataCatalogEncryptionSettings.BuilderImpl dataCatalogEncryptionSettings) {
            this.dataCatalogEncryptionSettings = dataCatalogEncryptionSettings != null ? dataCatalogEncryptionSettings.build() : null;
        }

        @Override
        @Transient
        public final Builder dataCatalogEncryptionSettings(DataCatalogEncryptionSettings dataCatalogEncryptionSettings) {
            this.dataCatalogEncryptionSettings = dataCatalogEncryptionSettings;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutDataCatalogEncryptionSettingsRequest build() {
            return new PutDataCatalogEncryptionSettingsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends GlueRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PutDataCatalogEncryptionSettingsRequest> {
        public Builder catalogId(String var1);

        public Builder dataCatalogEncryptionSettings(DataCatalogEncryptionSettings var1);

        default public Builder dataCatalogEncryptionSettings(Consumer<DataCatalogEncryptionSettings.Builder> dataCatalogEncryptionSettings) {
            return this.dataCatalogEncryptionSettings((DataCatalogEncryptionSettings)((DataCatalogEncryptionSettings.Builder)DataCatalogEncryptionSettings.builder().applyMutation(dataCatalogEncryptionSettings)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

