/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.glue.model.GlueRequest;
import software.amazon.awssdk.services.glue.model.MapValueCopier;
import software.amazon.awssdk.services.glue.model.PublicKeysListCopier;
import software.amazon.awssdk.services.glue.model.StringListCopier;
import software.amazon.awssdk.services.glue.model.TagsMapCopier;
import software.amazon.awssdk.services.glue.model.WorkerType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateDevEndpointRequest
extends GlueRequest
implements ToCopyableBuilder<Builder, CreateDevEndpointRequest> {
    private static final SdkField<String> ENDPOINT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EndpointName").getter(CreateDevEndpointRequest.getter(CreateDevEndpointRequest::endpointName)).setter(CreateDevEndpointRequest.setter(Builder::endpointName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointName").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RoleArn").getter(CreateDevEndpointRequest.getter(CreateDevEndpointRequest::roleArn)).setter(CreateDevEndpointRequest.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()}).build();
    private static final SdkField<List<String>> SECURITY_GROUP_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SecurityGroupIds").getter(CreateDevEndpointRequest.getter(CreateDevEndpointRequest::securityGroupIds)).setter(CreateDevEndpointRequest.setter(Builder::securityGroupIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityGroupIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> SUBNET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SubnetId").getter(CreateDevEndpointRequest.getter(CreateDevEndpointRequest::subnetId)).setter(CreateDevEndpointRequest.setter(Builder::subnetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetId").build()}).build();
    private static final SdkField<String> PUBLIC_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PublicKey").getter(CreateDevEndpointRequest.getter(CreateDevEndpointRequest::publicKey)).setter(CreateDevEndpointRequest.setter(Builder::publicKey)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PublicKey").build()}).build();
    private static final SdkField<List<String>> PUBLIC_KEYS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("PublicKeys").getter(CreateDevEndpointRequest.getter(CreateDevEndpointRequest::publicKeys)).setter(CreateDevEndpointRequest.setter(Builder::publicKeys)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PublicKeys").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Integer> NUMBER_OF_NODES_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("NumberOfNodes").getter(CreateDevEndpointRequest.getter(CreateDevEndpointRequest::numberOfNodes)).setter(CreateDevEndpointRequest.setter(Builder::numberOfNodes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberOfNodes").build()}).build();
    private static final SdkField<String> WORKER_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WorkerType").getter(CreateDevEndpointRequest.getter(CreateDevEndpointRequest::workerTypeAsString)).setter(CreateDevEndpointRequest.setter(Builder::workerType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkerType").build()}).build();
    private static final SdkField<String> GLUE_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GlueVersion").getter(CreateDevEndpointRequest.getter(CreateDevEndpointRequest::glueVersion)).setter(CreateDevEndpointRequest.setter(Builder::glueVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GlueVersion").build()}).build();
    private static final SdkField<Integer> NUMBER_OF_WORKERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("NumberOfWorkers").getter(CreateDevEndpointRequest.getter(CreateDevEndpointRequest::numberOfWorkers)).setter(CreateDevEndpointRequest.setter(Builder::numberOfWorkers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberOfWorkers").build()}).build();
    private static final SdkField<String> EXTRA_PYTHON_LIBS_S3_PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ExtraPythonLibsS3Path").getter(CreateDevEndpointRequest.getter(CreateDevEndpointRequest::extraPythonLibsS3Path)).setter(CreateDevEndpointRequest.setter(Builder::extraPythonLibsS3Path)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExtraPythonLibsS3Path").build()}).build();
    private static final SdkField<String> EXTRA_JARS_S3_PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ExtraJarsS3Path").getter(CreateDevEndpointRequest.getter(CreateDevEndpointRequest::extraJarsS3Path)).setter(CreateDevEndpointRequest.setter(Builder::extraJarsS3Path)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExtraJarsS3Path").build()}).build();
    private static final SdkField<String> SECURITY_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SecurityConfiguration").getter(CreateDevEndpointRequest.getter(CreateDevEndpointRequest::securityConfiguration)).setter(CreateDevEndpointRequest.setter(Builder::securityConfiguration)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityConfiguration").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Tags").getter(CreateDevEndpointRequest.getter(CreateDevEndpointRequest::tags)).setter(CreateDevEndpointRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Map<String, String>> ARGUMENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Arguments").getter(CreateDevEndpointRequest.getter(CreateDevEndpointRequest::arguments)).setter(CreateDevEndpointRequest.setter(Builder::arguments)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arguments").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENDPOINT_NAME_FIELD, ROLE_ARN_FIELD, SECURITY_GROUP_IDS_FIELD, SUBNET_ID_FIELD, PUBLIC_KEY_FIELD, PUBLIC_KEYS_FIELD, NUMBER_OF_NODES_FIELD, WORKER_TYPE_FIELD, GLUE_VERSION_FIELD, NUMBER_OF_WORKERS_FIELD, EXTRA_PYTHON_LIBS_S3_PATH_FIELD, EXTRA_JARS_S3_PATH_FIELD, SECURITY_CONFIGURATION_FIELD, TAGS_FIELD, ARGUMENTS_FIELD));
    private final String endpointName;
    private final String roleArn;
    private final List<String> securityGroupIds;
    private final String subnetId;
    private final String publicKey;
    private final List<String> publicKeys;
    private final Integer numberOfNodes;
    private final String workerType;
    private final String glueVersion;
    private final Integer numberOfWorkers;
    private final String extraPythonLibsS3Path;
    private final String extraJarsS3Path;
    private final String securityConfiguration;
    private final Map<String, String> tags;
    private final Map<String, String> arguments;

    private CreateDevEndpointRequest(BuilderImpl builder) {
        super(builder);
        this.endpointName = builder.endpointName;
        this.roleArn = builder.roleArn;
        this.securityGroupIds = builder.securityGroupIds;
        this.subnetId = builder.subnetId;
        this.publicKey = builder.publicKey;
        this.publicKeys = builder.publicKeys;
        this.numberOfNodes = builder.numberOfNodes;
        this.workerType = builder.workerType;
        this.glueVersion = builder.glueVersion;
        this.numberOfWorkers = builder.numberOfWorkers;
        this.extraPythonLibsS3Path = builder.extraPythonLibsS3Path;
        this.extraJarsS3Path = builder.extraJarsS3Path;
        this.securityConfiguration = builder.securityConfiguration;
        this.tags = builder.tags;
        this.arguments = builder.arguments;
    }

    public final String endpointName() {
        return this.endpointName;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    public final boolean hasSecurityGroupIds() {
        return this.securityGroupIds != null && !(this.securityGroupIds instanceof SdkAutoConstructList);
    }

    public final List<String> securityGroupIds() {
        return this.securityGroupIds;
    }

    public final String subnetId() {
        return this.subnetId;
    }

    public final String publicKey() {
        return this.publicKey;
    }

    public final boolean hasPublicKeys() {
        return this.publicKeys != null && !(this.publicKeys instanceof SdkAutoConstructList);
    }

    public final List<String> publicKeys() {
        return this.publicKeys;
    }

    public final Integer numberOfNodes() {
        return this.numberOfNodes;
    }

    public final WorkerType workerType() {
        return WorkerType.fromValue(this.workerType);
    }

    public final String workerTypeAsString() {
        return this.workerType;
    }

    public final String glueVersion() {
        return this.glueVersion;
    }

    public final Integer numberOfWorkers() {
        return this.numberOfWorkers;
    }

    public final String extraPythonLibsS3Path() {
        return this.extraPythonLibsS3Path;
    }

    public final String extraJarsS3Path() {
        return this.extraJarsS3Path;
    }

    public final String securityConfiguration() {
        return this.securityConfiguration;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final boolean hasArguments() {
        return this.arguments != null && !(this.arguments instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> arguments() {
        return this.arguments;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.endpointName());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSecurityGroupIds() ? this.securityGroupIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.subnetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.publicKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPublicKeys() ? this.publicKeys() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.numberOfNodes());
        hashCode = 31 * hashCode + Objects.hashCode(this.workerTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.glueVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.numberOfWorkers());
        hashCode = 31 * hashCode + Objects.hashCode(this.extraPythonLibsS3Path());
        hashCode = 31 * hashCode + Objects.hashCode(this.extraJarsS3Path());
        hashCode = 31 * hashCode + Objects.hashCode(this.securityConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasArguments() ? this.arguments() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDevEndpointRequest)) {
            return false;
        }
        CreateDevEndpointRequest other = (CreateDevEndpointRequest)((Object)obj);
        return Objects.equals(this.endpointName(), other.endpointName()) && Objects.equals(this.roleArn(), other.roleArn()) && this.hasSecurityGroupIds() == other.hasSecurityGroupIds() && Objects.equals(this.securityGroupIds(), other.securityGroupIds()) && Objects.equals(this.subnetId(), other.subnetId()) && Objects.equals(this.publicKey(), other.publicKey()) && this.hasPublicKeys() == other.hasPublicKeys() && Objects.equals(this.publicKeys(), other.publicKeys()) && Objects.equals(this.numberOfNodes(), other.numberOfNodes()) && Objects.equals(this.workerTypeAsString(), other.workerTypeAsString()) && Objects.equals(this.glueVersion(), other.glueVersion()) && Objects.equals(this.numberOfWorkers(), other.numberOfWorkers()) && Objects.equals(this.extraPythonLibsS3Path(), other.extraPythonLibsS3Path()) && Objects.equals(this.extraJarsS3Path(), other.extraJarsS3Path()) && Objects.equals(this.securityConfiguration(), other.securityConfiguration()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && this.hasArguments() == other.hasArguments() && Objects.equals(this.arguments(), other.arguments());
    }

    public final String toString() {
        return ToString.builder((String)"CreateDevEndpointRequest").add("EndpointName", (Object)this.endpointName()).add("RoleArn", (Object)this.roleArn()).add("SecurityGroupIds", this.hasSecurityGroupIds() ? this.securityGroupIds() : null).add("SubnetId", (Object)this.subnetId()).add("PublicKey", (Object)this.publicKey()).add("PublicKeys", this.hasPublicKeys() ? this.publicKeys() : null).add("NumberOfNodes", (Object)this.numberOfNodes()).add("WorkerType", (Object)this.workerTypeAsString()).add("GlueVersion", (Object)this.glueVersion()).add("NumberOfWorkers", (Object)this.numberOfWorkers()).add("ExtraPythonLibsS3Path", (Object)this.extraPythonLibsS3Path()).add("ExtraJarsS3Path", (Object)this.extraJarsS3Path()).add("SecurityConfiguration", (Object)this.securityConfiguration()).add("Tags", this.hasTags() ? this.tags() : null).add("Arguments", this.hasArguments() ? this.arguments() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EndpointName": {
                return Optional.ofNullable(clazz.cast(this.endpointName()));
            }
            case "RoleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "SecurityGroupIds": {
                return Optional.ofNullable(clazz.cast(this.securityGroupIds()));
            }
            case "SubnetId": {
                return Optional.ofNullable(clazz.cast(this.subnetId()));
            }
            case "PublicKey": {
                return Optional.ofNullable(clazz.cast(this.publicKey()));
            }
            case "PublicKeys": {
                return Optional.ofNullable(clazz.cast(this.publicKeys()));
            }
            case "NumberOfNodes": {
                return Optional.ofNullable(clazz.cast(this.numberOfNodes()));
            }
            case "WorkerType": {
                return Optional.ofNullable(clazz.cast(this.workerTypeAsString()));
            }
            case "GlueVersion": {
                return Optional.ofNullable(clazz.cast(this.glueVersion()));
            }
            case "NumberOfWorkers": {
                return Optional.ofNullable(clazz.cast(this.numberOfWorkers()));
            }
            case "ExtraPythonLibsS3Path": {
                return Optional.ofNullable(clazz.cast(this.extraPythonLibsS3Path()));
            }
            case "ExtraJarsS3Path": {
                return Optional.ofNullable(clazz.cast(this.extraJarsS3Path()));
            }
            case "SecurityConfiguration": {
                return Optional.ofNullable(clazz.cast(this.securityConfiguration()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "Arguments": {
                return Optional.ofNullable(clazz.cast(this.arguments()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateDevEndpointRequest, T> g) {
        return obj -> g.apply((CreateDevEndpointRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GlueRequest.BuilderImpl
    implements Builder {
        private String endpointName;
        private String roleArn;
        private List<String> securityGroupIds = DefaultSdkAutoConstructList.getInstance();
        private String subnetId;
        private String publicKey;
        private List<String> publicKeys = DefaultSdkAutoConstructList.getInstance();
        private Integer numberOfNodes;
        private String workerType;
        private String glueVersion;
        private Integer numberOfWorkers;
        private String extraPythonLibsS3Path;
        private String extraJarsS3Path;
        private String securityConfiguration;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private Map<String, String> arguments = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDevEndpointRequest model) {
            super(model);
            this.endpointName(model.endpointName);
            this.roleArn(model.roleArn);
            this.securityGroupIds(model.securityGroupIds);
            this.subnetId(model.subnetId);
            this.publicKey(model.publicKey);
            this.publicKeys(model.publicKeys);
            this.numberOfNodes(model.numberOfNodes);
            this.workerType(model.workerType);
            this.glueVersion(model.glueVersion);
            this.numberOfWorkers(model.numberOfWorkers);
            this.extraPythonLibsS3Path(model.extraPythonLibsS3Path);
            this.extraJarsS3Path(model.extraJarsS3Path);
            this.securityConfiguration(model.securityConfiguration);
            this.tags(model.tags);
            this.arguments(model.arguments);
        }

        public final String getEndpointName() {
            return this.endpointName;
        }

        public final void setEndpointName(String endpointName) {
            this.endpointName = endpointName;
        }

        @Override
        @Transient
        public final Builder endpointName(String endpointName) {
            this.endpointName = endpointName;
            return this;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        @Transient
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final Collection<String> getSecurityGroupIds() {
            if (this.securityGroupIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.securityGroupIds;
        }

        public final void setSecurityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = StringListCopier.copy(securityGroupIds);
        }

        @Override
        @Transient
        public final Builder securityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = StringListCopier.copy(securityGroupIds);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder securityGroupIds(String ... securityGroupIds) {
            this.securityGroupIds(Arrays.asList(securityGroupIds));
            return this;
        }

        public final String getSubnetId() {
            return this.subnetId;
        }

        public final void setSubnetId(String subnetId) {
            this.subnetId = subnetId;
        }

        @Override
        @Transient
        public final Builder subnetId(String subnetId) {
            this.subnetId = subnetId;
            return this;
        }

        public final String getPublicKey() {
            return this.publicKey;
        }

        public final void setPublicKey(String publicKey) {
            this.publicKey = publicKey;
        }

        @Override
        @Transient
        public final Builder publicKey(String publicKey) {
            this.publicKey = publicKey;
            return this;
        }

        public final Collection<String> getPublicKeys() {
            if (this.publicKeys instanceof SdkAutoConstructList) {
                return null;
            }
            return this.publicKeys;
        }

        public final void setPublicKeys(Collection<String> publicKeys) {
            this.publicKeys = PublicKeysListCopier.copy(publicKeys);
        }

        @Override
        @Transient
        public final Builder publicKeys(Collection<String> publicKeys) {
            this.publicKeys = PublicKeysListCopier.copy(publicKeys);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder publicKeys(String ... publicKeys) {
            this.publicKeys(Arrays.asList(publicKeys));
            return this;
        }

        public final Integer getNumberOfNodes() {
            return this.numberOfNodes;
        }

        public final void setNumberOfNodes(Integer numberOfNodes) {
            this.numberOfNodes = numberOfNodes;
        }

        @Override
        @Transient
        public final Builder numberOfNodes(Integer numberOfNodes) {
            this.numberOfNodes = numberOfNodes;
            return this;
        }

        public final String getWorkerType() {
            return this.workerType;
        }

        public final void setWorkerType(String workerType) {
            this.workerType = workerType;
        }

        @Override
        @Transient
        public final Builder workerType(String workerType) {
            this.workerType = workerType;
            return this;
        }

        @Override
        @Transient
        public final Builder workerType(WorkerType workerType) {
            this.workerType(workerType == null ? null : workerType.toString());
            return this;
        }

        public final String getGlueVersion() {
            return this.glueVersion;
        }

        public final void setGlueVersion(String glueVersion) {
            this.glueVersion = glueVersion;
        }

        @Override
        @Transient
        public final Builder glueVersion(String glueVersion) {
            this.glueVersion = glueVersion;
            return this;
        }

        public final Integer getNumberOfWorkers() {
            return this.numberOfWorkers;
        }

        public final void setNumberOfWorkers(Integer numberOfWorkers) {
            this.numberOfWorkers = numberOfWorkers;
        }

        @Override
        @Transient
        public final Builder numberOfWorkers(Integer numberOfWorkers) {
            this.numberOfWorkers = numberOfWorkers;
            return this;
        }

        public final String getExtraPythonLibsS3Path() {
            return this.extraPythonLibsS3Path;
        }

        public final void setExtraPythonLibsS3Path(String extraPythonLibsS3Path) {
            this.extraPythonLibsS3Path = extraPythonLibsS3Path;
        }

        @Override
        @Transient
        public final Builder extraPythonLibsS3Path(String extraPythonLibsS3Path) {
            this.extraPythonLibsS3Path = extraPythonLibsS3Path;
            return this;
        }

        public final String getExtraJarsS3Path() {
            return this.extraJarsS3Path;
        }

        public final void setExtraJarsS3Path(String extraJarsS3Path) {
            this.extraJarsS3Path = extraJarsS3Path;
        }

        @Override
        @Transient
        public final Builder extraJarsS3Path(String extraJarsS3Path) {
            this.extraJarsS3Path = extraJarsS3Path;
            return this;
        }

        public final String getSecurityConfiguration() {
            return this.securityConfiguration;
        }

        public final void setSecurityConfiguration(String securityConfiguration) {
            this.securityConfiguration = securityConfiguration;
        }

        @Override
        @Transient
        public final Builder securityConfiguration(String securityConfiguration) {
            this.securityConfiguration = securityConfiguration;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
        }

        @Override
        @Transient
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
            return this;
        }

        public final Map<String, String> getArguments() {
            if (this.arguments instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.arguments;
        }

        public final void setArguments(Map<String, String> arguments) {
            this.arguments = MapValueCopier.copy(arguments);
        }

        @Override
        @Transient
        public final Builder arguments(Map<String, String> arguments) {
            this.arguments = MapValueCopier.copy(arguments);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateDevEndpointRequest build() {
            return new CreateDevEndpointRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends GlueRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateDevEndpointRequest> {
        public Builder endpointName(String var1);

        public Builder roleArn(String var1);

        public Builder securityGroupIds(Collection<String> var1);

        public Builder securityGroupIds(String ... var1);

        public Builder subnetId(String var1);

        public Builder publicKey(String var1);

        public Builder publicKeys(Collection<String> var1);

        public Builder publicKeys(String ... var1);

        public Builder numberOfNodes(Integer var1);

        public Builder workerType(String var1);

        public Builder workerType(WorkerType var1);

        public Builder glueVersion(String var1);

        public Builder numberOfWorkers(Integer var1);

        public Builder extraPythonLibsS3Path(String var1);

        public Builder extraJarsS3Path(String var1);

        public Builder securityConfiguration(String var1);

        public Builder tags(Map<String, String> var1);

        public Builder arguments(Map<String, String> var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

