/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.glue.model.GlueRequest;
import software.amazon.awssdk.services.glue.model.WorkflowRunPropertiesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateWorkflowRequest
extends GlueRequest
implements ToCopyableBuilder<Builder, UpdateWorkflowRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(UpdateWorkflowRequest.getter(UpdateWorkflowRequest::name)).setter(UpdateWorkflowRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(UpdateWorkflowRequest.getter(UpdateWorkflowRequest::description)).setter(UpdateWorkflowRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<Map<String, String>> DEFAULT_RUN_PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("DefaultRunProperties").getter(UpdateWorkflowRequest.getter(UpdateWorkflowRequest::defaultRunProperties)).setter(UpdateWorkflowRequest.setter(Builder::defaultRunProperties)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultRunProperties").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Integer> MAX_CONCURRENT_RUNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxConcurrentRuns").getter(UpdateWorkflowRequest.getter(UpdateWorkflowRequest::maxConcurrentRuns)).setter(UpdateWorkflowRequest.setter(Builder::maxConcurrentRuns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxConcurrentRuns").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DESCRIPTION_FIELD, DEFAULT_RUN_PROPERTIES_FIELD, MAX_CONCURRENT_RUNS_FIELD));
    private final String name;
    private final String description;
    private final Map<String, String> defaultRunProperties;
    private final Integer maxConcurrentRuns;

    private UpdateWorkflowRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.description = builder.description;
        this.defaultRunProperties = builder.defaultRunProperties;
        this.maxConcurrentRuns = builder.maxConcurrentRuns;
    }

    public final String name() {
        return this.name;
    }

    public final String description() {
        return this.description;
    }

    public final boolean hasDefaultRunProperties() {
        return this.defaultRunProperties != null && !(this.defaultRunProperties instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> defaultRunProperties() {
        return this.defaultRunProperties;
    }

    public final Integer maxConcurrentRuns() {
        return this.maxConcurrentRuns;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDefaultRunProperties() ? this.defaultRunProperties() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.maxConcurrentRuns());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateWorkflowRequest)) {
            return false;
        }
        UpdateWorkflowRequest other = (UpdateWorkflowRequest)((Object)obj);
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && this.hasDefaultRunProperties() == other.hasDefaultRunProperties() && Objects.equals(this.defaultRunProperties(), other.defaultRunProperties()) && Objects.equals(this.maxConcurrentRuns(), other.maxConcurrentRuns());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateWorkflowRequest").add("Name", (Object)this.name()).add("Description", (Object)this.description()).add("DefaultRunProperties", this.hasDefaultRunProperties() ? this.defaultRunProperties() : null).add("MaxConcurrentRuns", (Object)this.maxConcurrentRuns()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "DefaultRunProperties": {
                return Optional.ofNullable(clazz.cast(this.defaultRunProperties()));
            }
            case "MaxConcurrentRuns": {
                return Optional.ofNullable(clazz.cast(this.maxConcurrentRuns()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateWorkflowRequest, T> g) {
        return obj -> g.apply((UpdateWorkflowRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GlueRequest.BuilderImpl
    implements Builder {
        private String name;
        private String description;
        private Map<String, String> defaultRunProperties = DefaultSdkAutoConstructMap.getInstance();
        private Integer maxConcurrentRuns;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateWorkflowRequest model) {
            super(model);
            this.name(model.name);
            this.description(model.description);
            this.defaultRunProperties(model.defaultRunProperties);
            this.maxConcurrentRuns(model.maxConcurrentRuns);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Map<String, String> getDefaultRunProperties() {
            if (this.defaultRunProperties instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.defaultRunProperties;
        }

        @Override
        public final Builder defaultRunProperties(Map<String, String> defaultRunProperties) {
            this.defaultRunProperties = WorkflowRunPropertiesCopier.copy(defaultRunProperties);
            return this;
        }

        public final void setDefaultRunProperties(Map<String, String> defaultRunProperties) {
            this.defaultRunProperties = WorkflowRunPropertiesCopier.copy(defaultRunProperties);
        }

        public final Integer getMaxConcurrentRuns() {
            return this.maxConcurrentRuns;
        }

        @Override
        public final Builder maxConcurrentRuns(Integer maxConcurrentRuns) {
            this.maxConcurrentRuns = maxConcurrentRuns;
            return this;
        }

        public final void setMaxConcurrentRuns(Integer maxConcurrentRuns) {
            this.maxConcurrentRuns = maxConcurrentRuns;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateWorkflowRequest build() {
            return new UpdateWorkflowRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends GlueRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateWorkflowRequest> {
        public Builder name(String var1);

        public Builder description(String var1);

        public Builder defaultRunProperties(Map<String, String> var1);

        public Builder maxConcurrentRuns(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

