/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.glue.model.GlueResponse;
import software.amazon.awssdk.services.glue.model.Partition;
import software.amazon.awssdk.services.glue.model.PartitionListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetPartitionsResponse
extends GlueResponse
implements ToCopyableBuilder<Builder, GetPartitionsResponse> {
    private static final SdkField<List<Partition>> PARTITIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Partitions").getter(GetPartitionsResponse.getter(GetPartitionsResponse::partitions)).setter(GetPartitionsResponse.setter(Builder::partitions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Partitions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Partition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(GetPartitionsResponse.getter(GetPartitionsResponse::nextToken)).setter(GetPartitionsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PARTITIONS_FIELD, NEXT_TOKEN_FIELD));
    private final List<Partition> partitions;
    private final String nextToken;

    private GetPartitionsResponse(BuilderImpl builder) {
        super(builder);
        this.partitions = builder.partitions;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasPartitions() {
        return this.partitions != null && !(this.partitions instanceof SdkAutoConstructList);
    }

    public final List<Partition> partitions() {
        return this.partitions;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPartitions() ? this.partitions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetPartitionsResponse)) {
            return false;
        }
        GetPartitionsResponse other = (GetPartitionsResponse)((Object)obj);
        return this.hasPartitions() == other.hasPartitions() && Objects.equals(this.partitions(), other.partitions()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"GetPartitionsResponse").add("Partitions", this.hasPartitions() ? this.partitions() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Partitions": {
                return Optional.ofNullable(clazz.cast(this.partitions()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetPartitionsResponse, T> g) {
        return obj -> g.apply((GetPartitionsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GlueResponse.BuilderImpl
    implements Builder {
        private List<Partition> partitions = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetPartitionsResponse model) {
            super(model);
            this.partitions(model.partitions);
            this.nextToken(model.nextToken);
        }

        public final List<Partition.Builder> getPartitions() {
            List<Partition.Builder> result = PartitionListCopier.copyToBuilder(this.partitions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder partitions(Collection<Partition> partitions) {
            this.partitions = PartitionListCopier.copy(partitions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder partitions(Partition ... partitions) {
            this.partitions(Arrays.asList(partitions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder partitions(Consumer<Partition.Builder> ... partitions) {
            this.partitions(Stream.of(partitions).map(c -> (Partition)((Partition.Builder)Partition.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setPartitions(Collection<Partition.BuilderImpl> partitions) {
            this.partitions = PartitionListCopier.copyFromBuilder(partitions);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public GetPartitionsResponse build() {
            return new GetPartitionsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends GlueResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetPartitionsResponse> {
        public Builder partitions(Collection<Partition> var1);

        public Builder partitions(Partition ... var1);

        public Builder partitions(Consumer<Partition.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

