/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.glue.GlueClient;
import software.amazon.awssdk.services.glue.model.GetDatabasesRequest;
import software.amazon.awssdk.services.glue.model.GetDatabasesResponse;

public class GetDatabasesIterable
implements SdkIterable<GetDatabasesResponse> {
    private final GlueClient client;
    private final GetDatabasesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public GetDatabasesIterable(GlueClient client, GetDatabasesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new GetDatabasesResponseFetcher();
    }

    public Iterator<GetDatabasesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class GetDatabasesResponseFetcher
    implements SyncPageFetcher<GetDatabasesResponse> {
        private GetDatabasesResponseFetcher() {
        }

        public boolean hasNextPage(GetDatabasesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public GetDatabasesResponse nextPage(GetDatabasesResponse previousPage) {
            if (previousPage == null) {
                return GetDatabasesIterable.this.client.getDatabases(GetDatabasesIterable.this.firstRequest);
            }
            return GetDatabasesIterable.this.client.getDatabases((GetDatabasesRequest)((Object)GetDatabasesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

