/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.glue.model.MapValueCopier;
import software.amazon.awssdk.services.glue.model.PublicKeysListCopier;
import software.amazon.awssdk.services.glue.model.StringListCopier;
import software.amazon.awssdk.services.glue.model.WorkerType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DevEndpoint
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DevEndpoint> {
    private static final SdkField<String> ENDPOINT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EndpointName").getter(DevEndpoint.getter(DevEndpoint::endpointName)).setter(DevEndpoint.setter(Builder::endpointName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointName").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RoleArn").getter(DevEndpoint.getter(DevEndpoint::roleArn)).setter(DevEndpoint.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()}).build();
    private static final SdkField<List<String>> SECURITY_GROUP_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SecurityGroupIds").getter(DevEndpoint.getter(DevEndpoint::securityGroupIds)).setter(DevEndpoint.setter(Builder::securityGroupIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityGroupIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> SUBNET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SubnetId").getter(DevEndpoint.getter(DevEndpoint::subnetId)).setter(DevEndpoint.setter(Builder::subnetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetId").build()}).build();
    private static final SdkField<String> YARN_ENDPOINT_ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("YarnEndpointAddress").getter(DevEndpoint.getter(DevEndpoint::yarnEndpointAddress)).setter(DevEndpoint.setter(Builder::yarnEndpointAddress)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("YarnEndpointAddress").build()}).build();
    private static final SdkField<String> PRIVATE_ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PrivateAddress").getter(DevEndpoint.getter(DevEndpoint::privateAddress)).setter(DevEndpoint.setter(Builder::privateAddress)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrivateAddress").build()}).build();
    private static final SdkField<Integer> ZEPPELIN_REMOTE_SPARK_INTERPRETER_PORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ZeppelinRemoteSparkInterpreterPort").getter(DevEndpoint.getter(DevEndpoint::zeppelinRemoteSparkInterpreterPort)).setter(DevEndpoint.setter(Builder::zeppelinRemoteSparkInterpreterPort)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ZeppelinRemoteSparkInterpreterPort").build()}).build();
    private static final SdkField<String> PUBLIC_ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PublicAddress").getter(DevEndpoint.getter(DevEndpoint::publicAddress)).setter(DevEndpoint.setter(Builder::publicAddress)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PublicAddress").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(DevEndpoint.getter(DevEndpoint::status)).setter(DevEndpoint.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> WORKER_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WorkerType").getter(DevEndpoint.getter(DevEndpoint::workerTypeAsString)).setter(DevEndpoint.setter(Builder::workerType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkerType").build()}).build();
    private static final SdkField<String> GLUE_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GlueVersion").getter(DevEndpoint.getter(DevEndpoint::glueVersion)).setter(DevEndpoint.setter(Builder::glueVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GlueVersion").build()}).build();
    private static final SdkField<Integer> NUMBER_OF_WORKERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("NumberOfWorkers").getter(DevEndpoint.getter(DevEndpoint::numberOfWorkers)).setter(DevEndpoint.setter(Builder::numberOfWorkers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberOfWorkers").build()}).build();
    private static final SdkField<Integer> NUMBER_OF_NODES_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("NumberOfNodes").getter(DevEndpoint.getter(DevEndpoint::numberOfNodes)).setter(DevEndpoint.setter(Builder::numberOfNodes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberOfNodes").build()}).build();
    private static final SdkField<String> AVAILABILITY_ZONE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AvailabilityZone").getter(DevEndpoint.getter(DevEndpoint::availabilityZone)).setter(DevEndpoint.setter(Builder::availabilityZone)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZone").build()}).build();
    private static final SdkField<String> VPC_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VpcId").getter(DevEndpoint.getter(DevEndpoint::vpcId)).setter(DevEndpoint.setter(Builder::vpcId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcId").build()}).build();
    private static final SdkField<String> EXTRA_PYTHON_LIBS_S3_PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ExtraPythonLibsS3Path").getter(DevEndpoint.getter(DevEndpoint::extraPythonLibsS3Path)).setter(DevEndpoint.setter(Builder::extraPythonLibsS3Path)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExtraPythonLibsS3Path").build()}).build();
    private static final SdkField<String> EXTRA_JARS_S3_PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ExtraJarsS3Path").getter(DevEndpoint.getter(DevEndpoint::extraJarsS3Path)).setter(DevEndpoint.setter(Builder::extraJarsS3Path)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExtraJarsS3Path").build()}).build();
    private static final SdkField<String> FAILURE_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FailureReason").getter(DevEndpoint.getter(DevEndpoint::failureReason)).setter(DevEndpoint.setter(Builder::failureReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureReason").build()}).build();
    private static final SdkField<String> LAST_UPDATE_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LastUpdateStatus").getter(DevEndpoint.getter(DevEndpoint::lastUpdateStatus)).setter(DevEndpoint.setter(Builder::lastUpdateStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdateStatus").build()}).build();
    private static final SdkField<Instant> CREATED_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedTimestamp").getter(DevEndpoint.getter(DevEndpoint::createdTimestamp)).setter(DevEndpoint.setter(Builder::createdTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTimestamp").build()}).build();
    private static final SdkField<Instant> LAST_MODIFIED_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastModifiedTimestamp").getter(DevEndpoint.getter(DevEndpoint::lastModifiedTimestamp)).setter(DevEndpoint.setter(Builder::lastModifiedTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTimestamp").build()}).build();
    private static final SdkField<String> PUBLIC_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PublicKey").getter(DevEndpoint.getter(DevEndpoint::publicKey)).setter(DevEndpoint.setter(Builder::publicKey)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PublicKey").build()}).build();
    private static final SdkField<List<String>> PUBLIC_KEYS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("PublicKeys").getter(DevEndpoint.getter(DevEndpoint::publicKeys)).setter(DevEndpoint.setter(Builder::publicKeys)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PublicKeys").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> SECURITY_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SecurityConfiguration").getter(DevEndpoint.getter(DevEndpoint::securityConfiguration)).setter(DevEndpoint.setter(Builder::securityConfiguration)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityConfiguration").build()}).build();
    private static final SdkField<Map<String, String>> ARGUMENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Arguments").getter(DevEndpoint.getter(DevEndpoint::arguments)).setter(DevEndpoint.setter(Builder::arguments)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arguments").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENDPOINT_NAME_FIELD, ROLE_ARN_FIELD, SECURITY_GROUP_IDS_FIELD, SUBNET_ID_FIELD, YARN_ENDPOINT_ADDRESS_FIELD, PRIVATE_ADDRESS_FIELD, ZEPPELIN_REMOTE_SPARK_INTERPRETER_PORT_FIELD, PUBLIC_ADDRESS_FIELD, STATUS_FIELD, WORKER_TYPE_FIELD, GLUE_VERSION_FIELD, NUMBER_OF_WORKERS_FIELD, NUMBER_OF_NODES_FIELD, AVAILABILITY_ZONE_FIELD, VPC_ID_FIELD, EXTRA_PYTHON_LIBS_S3_PATH_FIELD, EXTRA_JARS_S3_PATH_FIELD, FAILURE_REASON_FIELD, LAST_UPDATE_STATUS_FIELD, CREATED_TIMESTAMP_FIELD, LAST_MODIFIED_TIMESTAMP_FIELD, PUBLIC_KEY_FIELD, PUBLIC_KEYS_FIELD, SECURITY_CONFIGURATION_FIELD, ARGUMENTS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String endpointName;
    private final String roleArn;
    private final List<String> securityGroupIds;
    private final String subnetId;
    private final String yarnEndpointAddress;
    private final String privateAddress;
    private final Integer zeppelinRemoteSparkInterpreterPort;
    private final String publicAddress;
    private final String status;
    private final String workerType;
    private final String glueVersion;
    private final Integer numberOfWorkers;
    private final Integer numberOfNodes;
    private final String availabilityZone;
    private final String vpcId;
    private final String extraPythonLibsS3Path;
    private final String extraJarsS3Path;
    private final String failureReason;
    private final String lastUpdateStatus;
    private final Instant createdTimestamp;
    private final Instant lastModifiedTimestamp;
    private final String publicKey;
    private final List<String> publicKeys;
    private final String securityConfiguration;
    private final Map<String, String> arguments;

    private DevEndpoint(BuilderImpl builder) {
        this.endpointName = builder.endpointName;
        this.roleArn = builder.roleArn;
        this.securityGroupIds = builder.securityGroupIds;
        this.subnetId = builder.subnetId;
        this.yarnEndpointAddress = builder.yarnEndpointAddress;
        this.privateAddress = builder.privateAddress;
        this.zeppelinRemoteSparkInterpreterPort = builder.zeppelinRemoteSparkInterpreterPort;
        this.publicAddress = builder.publicAddress;
        this.status = builder.status;
        this.workerType = builder.workerType;
        this.glueVersion = builder.glueVersion;
        this.numberOfWorkers = builder.numberOfWorkers;
        this.numberOfNodes = builder.numberOfNodes;
        this.availabilityZone = builder.availabilityZone;
        this.vpcId = builder.vpcId;
        this.extraPythonLibsS3Path = builder.extraPythonLibsS3Path;
        this.extraJarsS3Path = builder.extraJarsS3Path;
        this.failureReason = builder.failureReason;
        this.lastUpdateStatus = builder.lastUpdateStatus;
        this.createdTimestamp = builder.createdTimestamp;
        this.lastModifiedTimestamp = builder.lastModifiedTimestamp;
        this.publicKey = builder.publicKey;
        this.publicKeys = builder.publicKeys;
        this.securityConfiguration = builder.securityConfiguration;
        this.arguments = builder.arguments;
    }

    public String endpointName() {
        return this.endpointName;
    }

    public String roleArn() {
        return this.roleArn;
    }

    public boolean hasSecurityGroupIds() {
        return this.securityGroupIds != null && !(this.securityGroupIds instanceof SdkAutoConstructList);
    }

    public List<String> securityGroupIds() {
        return this.securityGroupIds;
    }

    public String subnetId() {
        return this.subnetId;
    }

    public String yarnEndpointAddress() {
        return this.yarnEndpointAddress;
    }

    public String privateAddress() {
        return this.privateAddress;
    }

    public Integer zeppelinRemoteSparkInterpreterPort() {
        return this.zeppelinRemoteSparkInterpreterPort;
    }

    public String publicAddress() {
        return this.publicAddress;
    }

    public String status() {
        return this.status;
    }

    public WorkerType workerType() {
        return WorkerType.fromValue(this.workerType);
    }

    public String workerTypeAsString() {
        return this.workerType;
    }

    public String glueVersion() {
        return this.glueVersion;
    }

    public Integer numberOfWorkers() {
        return this.numberOfWorkers;
    }

    public Integer numberOfNodes() {
        return this.numberOfNodes;
    }

    public String availabilityZone() {
        return this.availabilityZone;
    }

    public String vpcId() {
        return this.vpcId;
    }

    public String extraPythonLibsS3Path() {
        return this.extraPythonLibsS3Path;
    }

    public String extraJarsS3Path() {
        return this.extraJarsS3Path;
    }

    public String failureReason() {
        return this.failureReason;
    }

    public String lastUpdateStatus() {
        return this.lastUpdateStatus;
    }

    public Instant createdTimestamp() {
        return this.createdTimestamp;
    }

    public Instant lastModifiedTimestamp() {
        return this.lastModifiedTimestamp;
    }

    public String publicKey() {
        return this.publicKey;
    }

    public boolean hasPublicKeys() {
        return this.publicKeys != null && !(this.publicKeys instanceof SdkAutoConstructList);
    }

    public List<String> publicKeys() {
        return this.publicKeys;
    }

    public String securityConfiguration() {
        return this.securityConfiguration;
    }

    public boolean hasArguments() {
        return this.arguments != null && !(this.arguments instanceof SdkAutoConstructMap);
    }

    public Map<String, String> arguments() {
        return this.arguments;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.endpointName());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.securityGroupIds());
        hashCode = 31 * hashCode + Objects.hashCode(this.subnetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.yarnEndpointAddress());
        hashCode = 31 * hashCode + Objects.hashCode(this.privateAddress());
        hashCode = 31 * hashCode + Objects.hashCode(this.zeppelinRemoteSparkInterpreterPort());
        hashCode = 31 * hashCode + Objects.hashCode(this.publicAddress());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.workerTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.glueVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.numberOfWorkers());
        hashCode = 31 * hashCode + Objects.hashCode(this.numberOfNodes());
        hashCode = 31 * hashCode + Objects.hashCode(this.availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcId());
        hashCode = 31 * hashCode + Objects.hashCode(this.extraPythonLibsS3Path());
        hashCode = 31 * hashCode + Objects.hashCode(this.extraJarsS3Path());
        hashCode = 31 * hashCode + Objects.hashCode(this.failureReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdateStatus());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.publicKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.publicKeys());
        hashCode = 31 * hashCode + Objects.hashCode(this.securityConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.arguments());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DevEndpoint)) {
            return false;
        }
        DevEndpoint other = (DevEndpoint)obj;
        return Objects.equals(this.endpointName(), other.endpointName()) && Objects.equals(this.roleArn(), other.roleArn()) && Objects.equals(this.securityGroupIds(), other.securityGroupIds()) && Objects.equals(this.subnetId(), other.subnetId()) && Objects.equals(this.yarnEndpointAddress(), other.yarnEndpointAddress()) && Objects.equals(this.privateAddress(), other.privateAddress()) && Objects.equals(this.zeppelinRemoteSparkInterpreterPort(), other.zeppelinRemoteSparkInterpreterPort()) && Objects.equals(this.publicAddress(), other.publicAddress()) && Objects.equals(this.status(), other.status()) && Objects.equals(this.workerTypeAsString(), other.workerTypeAsString()) && Objects.equals(this.glueVersion(), other.glueVersion()) && Objects.equals(this.numberOfWorkers(), other.numberOfWorkers()) && Objects.equals(this.numberOfNodes(), other.numberOfNodes()) && Objects.equals(this.availabilityZone(), other.availabilityZone()) && Objects.equals(this.vpcId(), other.vpcId()) && Objects.equals(this.extraPythonLibsS3Path(), other.extraPythonLibsS3Path()) && Objects.equals(this.extraJarsS3Path(), other.extraJarsS3Path()) && Objects.equals(this.failureReason(), other.failureReason()) && Objects.equals(this.lastUpdateStatus(), other.lastUpdateStatus()) && Objects.equals(this.createdTimestamp(), other.createdTimestamp()) && Objects.equals(this.lastModifiedTimestamp(), other.lastModifiedTimestamp()) && Objects.equals(this.publicKey(), other.publicKey()) && Objects.equals(this.publicKeys(), other.publicKeys()) && Objects.equals(this.securityConfiguration(), other.securityConfiguration()) && Objects.equals(this.arguments(), other.arguments());
    }

    public String toString() {
        return ToString.builder((String)"DevEndpoint").add("EndpointName", (Object)this.endpointName()).add("RoleArn", (Object)this.roleArn()).add("SecurityGroupIds", this.securityGroupIds()).add("SubnetId", (Object)this.subnetId()).add("YarnEndpointAddress", (Object)this.yarnEndpointAddress()).add("PrivateAddress", (Object)this.privateAddress()).add("ZeppelinRemoteSparkInterpreterPort", (Object)this.zeppelinRemoteSparkInterpreterPort()).add("PublicAddress", (Object)this.publicAddress()).add("Status", (Object)this.status()).add("WorkerType", (Object)this.workerTypeAsString()).add("GlueVersion", (Object)this.glueVersion()).add("NumberOfWorkers", (Object)this.numberOfWorkers()).add("NumberOfNodes", (Object)this.numberOfNodes()).add("AvailabilityZone", (Object)this.availabilityZone()).add("VpcId", (Object)this.vpcId()).add("ExtraPythonLibsS3Path", (Object)this.extraPythonLibsS3Path()).add("ExtraJarsS3Path", (Object)this.extraJarsS3Path()).add("FailureReason", (Object)this.failureReason()).add("LastUpdateStatus", (Object)this.lastUpdateStatus()).add("CreatedTimestamp", (Object)this.createdTimestamp()).add("LastModifiedTimestamp", (Object)this.lastModifiedTimestamp()).add("PublicKey", (Object)this.publicKey()).add("PublicKeys", this.publicKeys()).add("SecurityConfiguration", (Object)this.securityConfiguration()).add("Arguments", this.arguments()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EndpointName": {
                return Optional.ofNullable(clazz.cast(this.endpointName()));
            }
            case "RoleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "SecurityGroupIds": {
                return Optional.ofNullable(clazz.cast(this.securityGroupIds()));
            }
            case "SubnetId": {
                return Optional.ofNullable(clazz.cast(this.subnetId()));
            }
            case "YarnEndpointAddress": {
                return Optional.ofNullable(clazz.cast(this.yarnEndpointAddress()));
            }
            case "PrivateAddress": {
                return Optional.ofNullable(clazz.cast(this.privateAddress()));
            }
            case "ZeppelinRemoteSparkInterpreterPort": {
                return Optional.ofNullable(clazz.cast(this.zeppelinRemoteSparkInterpreterPort()));
            }
            case "PublicAddress": {
                return Optional.ofNullable(clazz.cast(this.publicAddress()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
            case "WorkerType": {
                return Optional.ofNullable(clazz.cast(this.workerTypeAsString()));
            }
            case "GlueVersion": {
                return Optional.ofNullable(clazz.cast(this.glueVersion()));
            }
            case "NumberOfWorkers": {
                return Optional.ofNullable(clazz.cast(this.numberOfWorkers()));
            }
            case "NumberOfNodes": {
                return Optional.ofNullable(clazz.cast(this.numberOfNodes()));
            }
            case "AvailabilityZone": {
                return Optional.ofNullable(clazz.cast(this.availabilityZone()));
            }
            case "VpcId": {
                return Optional.ofNullable(clazz.cast(this.vpcId()));
            }
            case "ExtraPythonLibsS3Path": {
                return Optional.ofNullable(clazz.cast(this.extraPythonLibsS3Path()));
            }
            case "ExtraJarsS3Path": {
                return Optional.ofNullable(clazz.cast(this.extraJarsS3Path()));
            }
            case "FailureReason": {
                return Optional.ofNullable(clazz.cast(this.failureReason()));
            }
            case "LastUpdateStatus": {
                return Optional.ofNullable(clazz.cast(this.lastUpdateStatus()));
            }
            case "CreatedTimestamp": {
                return Optional.ofNullable(clazz.cast(this.createdTimestamp()));
            }
            case "LastModifiedTimestamp": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedTimestamp()));
            }
            case "PublicKey": {
                return Optional.ofNullable(clazz.cast(this.publicKey()));
            }
            case "PublicKeys": {
                return Optional.ofNullable(clazz.cast(this.publicKeys()));
            }
            case "SecurityConfiguration": {
                return Optional.ofNullable(clazz.cast(this.securityConfiguration()));
            }
            case "Arguments": {
                return Optional.ofNullable(clazz.cast(this.arguments()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DevEndpoint, T> g) {
        return obj -> g.apply((DevEndpoint)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String endpointName;
        private String roleArn;
        private List<String> securityGroupIds = DefaultSdkAutoConstructList.getInstance();
        private String subnetId;
        private String yarnEndpointAddress;
        private String privateAddress;
        private Integer zeppelinRemoteSparkInterpreterPort;
        private String publicAddress;
        private String status;
        private String workerType;
        private String glueVersion;
        private Integer numberOfWorkers;
        private Integer numberOfNodes;
        private String availabilityZone;
        private String vpcId;
        private String extraPythonLibsS3Path;
        private String extraJarsS3Path;
        private String failureReason;
        private String lastUpdateStatus;
        private Instant createdTimestamp;
        private Instant lastModifiedTimestamp;
        private String publicKey;
        private List<String> publicKeys = DefaultSdkAutoConstructList.getInstance();
        private String securityConfiguration;
        private Map<String, String> arguments = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DevEndpoint model) {
            this.endpointName(model.endpointName);
            this.roleArn(model.roleArn);
            this.securityGroupIds(model.securityGroupIds);
            this.subnetId(model.subnetId);
            this.yarnEndpointAddress(model.yarnEndpointAddress);
            this.privateAddress(model.privateAddress);
            this.zeppelinRemoteSparkInterpreterPort(model.zeppelinRemoteSparkInterpreterPort);
            this.publicAddress(model.publicAddress);
            this.status(model.status);
            this.workerType(model.workerType);
            this.glueVersion(model.glueVersion);
            this.numberOfWorkers(model.numberOfWorkers);
            this.numberOfNodes(model.numberOfNodes);
            this.availabilityZone(model.availabilityZone);
            this.vpcId(model.vpcId);
            this.extraPythonLibsS3Path(model.extraPythonLibsS3Path);
            this.extraJarsS3Path(model.extraJarsS3Path);
            this.failureReason(model.failureReason);
            this.lastUpdateStatus(model.lastUpdateStatus);
            this.createdTimestamp(model.createdTimestamp);
            this.lastModifiedTimestamp(model.lastModifiedTimestamp);
            this.publicKey(model.publicKey);
            this.publicKeys(model.publicKeys);
            this.securityConfiguration(model.securityConfiguration);
            this.arguments(model.arguments);
        }

        public final String getEndpointName() {
            return this.endpointName;
        }

        @Override
        public final Builder endpointName(String endpointName) {
            this.endpointName = endpointName;
            return this;
        }

        public final void setEndpointName(String endpointName) {
            this.endpointName = endpointName;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        public final Collection<String> getSecurityGroupIds() {
            return this.securityGroupIds;
        }

        @Override
        public final Builder securityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = StringListCopier.copy(securityGroupIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroupIds(String ... securityGroupIds) {
            this.securityGroupIds(Arrays.asList(securityGroupIds));
            return this;
        }

        public final void setSecurityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = StringListCopier.copy(securityGroupIds);
        }

        public final String getSubnetId() {
            return this.subnetId;
        }

        @Override
        public final Builder subnetId(String subnetId) {
            this.subnetId = subnetId;
            return this;
        }

        public final void setSubnetId(String subnetId) {
            this.subnetId = subnetId;
        }

        public final String getYarnEndpointAddress() {
            return this.yarnEndpointAddress;
        }

        @Override
        public final Builder yarnEndpointAddress(String yarnEndpointAddress) {
            this.yarnEndpointAddress = yarnEndpointAddress;
            return this;
        }

        public final void setYarnEndpointAddress(String yarnEndpointAddress) {
            this.yarnEndpointAddress = yarnEndpointAddress;
        }

        public final String getPrivateAddress() {
            return this.privateAddress;
        }

        @Override
        public final Builder privateAddress(String privateAddress) {
            this.privateAddress = privateAddress;
            return this;
        }

        public final void setPrivateAddress(String privateAddress) {
            this.privateAddress = privateAddress;
        }

        public final Integer getZeppelinRemoteSparkInterpreterPort() {
            return this.zeppelinRemoteSparkInterpreterPort;
        }

        @Override
        public final Builder zeppelinRemoteSparkInterpreterPort(Integer zeppelinRemoteSparkInterpreterPort) {
            this.zeppelinRemoteSparkInterpreterPort = zeppelinRemoteSparkInterpreterPort;
            return this;
        }

        public final void setZeppelinRemoteSparkInterpreterPort(Integer zeppelinRemoteSparkInterpreterPort) {
            this.zeppelinRemoteSparkInterpreterPort = zeppelinRemoteSparkInterpreterPort;
        }

        public final String getPublicAddress() {
            return this.publicAddress;
        }

        @Override
        public final Builder publicAddress(String publicAddress) {
            this.publicAddress = publicAddress;
            return this;
        }

        public final void setPublicAddress(String publicAddress) {
            this.publicAddress = publicAddress;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getWorkerType() {
            return this.workerType;
        }

        @Override
        public final Builder workerType(String workerType) {
            this.workerType = workerType;
            return this;
        }

        @Override
        public final Builder workerType(WorkerType workerType) {
            this.workerType(workerType == null ? null : workerType.toString());
            return this;
        }

        public final void setWorkerType(String workerType) {
            this.workerType = workerType;
        }

        public final String getGlueVersion() {
            return this.glueVersion;
        }

        @Override
        public final Builder glueVersion(String glueVersion) {
            this.glueVersion = glueVersion;
            return this;
        }

        public final void setGlueVersion(String glueVersion) {
            this.glueVersion = glueVersion;
        }

        public final Integer getNumberOfWorkers() {
            return this.numberOfWorkers;
        }

        @Override
        public final Builder numberOfWorkers(Integer numberOfWorkers) {
            this.numberOfWorkers = numberOfWorkers;
            return this;
        }

        public final void setNumberOfWorkers(Integer numberOfWorkers) {
            this.numberOfWorkers = numberOfWorkers;
        }

        public final Integer getNumberOfNodes() {
            return this.numberOfNodes;
        }

        @Override
        public final Builder numberOfNodes(Integer numberOfNodes) {
            this.numberOfNodes = numberOfNodes;
            return this;
        }

        public final void setNumberOfNodes(Integer numberOfNodes) {
            this.numberOfNodes = numberOfNodes;
        }

        public final String getAvailabilityZone() {
            return this.availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        public final String getVpcId() {
            return this.vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        public final String getExtraPythonLibsS3Path() {
            return this.extraPythonLibsS3Path;
        }

        @Override
        public final Builder extraPythonLibsS3Path(String extraPythonLibsS3Path) {
            this.extraPythonLibsS3Path = extraPythonLibsS3Path;
            return this;
        }

        public final void setExtraPythonLibsS3Path(String extraPythonLibsS3Path) {
            this.extraPythonLibsS3Path = extraPythonLibsS3Path;
        }

        public final String getExtraJarsS3Path() {
            return this.extraJarsS3Path;
        }

        @Override
        public final Builder extraJarsS3Path(String extraJarsS3Path) {
            this.extraJarsS3Path = extraJarsS3Path;
            return this;
        }

        public final void setExtraJarsS3Path(String extraJarsS3Path) {
            this.extraJarsS3Path = extraJarsS3Path;
        }

        public final String getFailureReason() {
            return this.failureReason;
        }

        @Override
        public final Builder failureReason(String failureReason) {
            this.failureReason = failureReason;
            return this;
        }

        public final void setFailureReason(String failureReason) {
            this.failureReason = failureReason;
        }

        public final String getLastUpdateStatus() {
            return this.lastUpdateStatus;
        }

        @Override
        public final Builder lastUpdateStatus(String lastUpdateStatus) {
            this.lastUpdateStatus = lastUpdateStatus;
            return this;
        }

        public final void setLastUpdateStatus(String lastUpdateStatus) {
            this.lastUpdateStatus = lastUpdateStatus;
        }

        public final Instant getCreatedTimestamp() {
            return this.createdTimestamp;
        }

        @Override
        public final Builder createdTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
            return this;
        }

        public final void setCreatedTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
        }

        public final Instant getLastModifiedTimestamp() {
            return this.lastModifiedTimestamp;
        }

        @Override
        public final Builder lastModifiedTimestamp(Instant lastModifiedTimestamp) {
            this.lastModifiedTimestamp = lastModifiedTimestamp;
            return this;
        }

        public final void setLastModifiedTimestamp(Instant lastModifiedTimestamp) {
            this.lastModifiedTimestamp = lastModifiedTimestamp;
        }

        public final String getPublicKey() {
            return this.publicKey;
        }

        @Override
        public final Builder publicKey(String publicKey) {
            this.publicKey = publicKey;
            return this;
        }

        public final void setPublicKey(String publicKey) {
            this.publicKey = publicKey;
        }

        public final Collection<String> getPublicKeys() {
            return this.publicKeys;
        }

        @Override
        public final Builder publicKeys(Collection<String> publicKeys) {
            this.publicKeys = PublicKeysListCopier.copy(publicKeys);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder publicKeys(String ... publicKeys) {
            this.publicKeys(Arrays.asList(publicKeys));
            return this;
        }

        public final void setPublicKeys(Collection<String> publicKeys) {
            this.publicKeys = PublicKeysListCopier.copy(publicKeys);
        }

        public final String getSecurityConfiguration() {
            return this.securityConfiguration;
        }

        @Override
        public final Builder securityConfiguration(String securityConfiguration) {
            this.securityConfiguration = securityConfiguration;
            return this;
        }

        public final void setSecurityConfiguration(String securityConfiguration) {
            this.securityConfiguration = securityConfiguration;
        }

        public final Map<String, String> getArguments() {
            return this.arguments;
        }

        @Override
        public final Builder arguments(Map<String, String> arguments) {
            this.arguments = MapValueCopier.copy(arguments);
            return this;
        }

        public final void setArguments(Map<String, String> arguments) {
            this.arguments = MapValueCopier.copy(arguments);
        }

        public DevEndpoint build() {
            return new DevEndpoint(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DevEndpoint> {
        public Builder endpointName(String var1);

        public Builder roleArn(String var1);

        public Builder securityGroupIds(Collection<String> var1);

        public Builder securityGroupIds(String ... var1);

        public Builder subnetId(String var1);

        public Builder yarnEndpointAddress(String var1);

        public Builder privateAddress(String var1);

        public Builder zeppelinRemoteSparkInterpreterPort(Integer var1);

        public Builder publicAddress(String var1);

        public Builder status(String var1);

        public Builder workerType(String var1);

        public Builder workerType(WorkerType var1);

        public Builder glueVersion(String var1);

        public Builder numberOfWorkers(Integer var1);

        public Builder numberOfNodes(Integer var1);

        public Builder availabilityZone(String var1);

        public Builder vpcId(String var1);

        public Builder extraPythonLibsS3Path(String var1);

        public Builder extraJarsS3Path(String var1);

        public Builder failureReason(String var1);

        public Builder lastUpdateStatus(String var1);

        public Builder createdTimestamp(Instant var1);

        public Builder lastModifiedTimestamp(Instant var1);

        public Builder publicKey(String var1);

        public Builder publicKeys(Collection<String> var1);

        public Builder publicKeys(String ... var1);

        public Builder securityConfiguration(String var1);

        public Builder arguments(Map<String, String> var1);
    }
}

