/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.glue.GlueAsyncClient;
import software.amazon.awssdk.services.glue.model.ListMlTransformsRequest;
import software.amazon.awssdk.services.glue.model.ListMlTransformsResponse;

public class ListMLTransformsPublisher
implements SdkPublisher<ListMlTransformsResponse> {
    private final GlueAsyncClient client;
    private final ListMlTransformsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListMLTransformsPublisher(GlueAsyncClient client, ListMlTransformsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListMLTransformsPublisher(GlueAsyncClient client, ListMlTransformsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListMlTransformsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListMlTransformsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListMlTransformsResponseFetcher
    implements AsyncPageFetcher<ListMlTransformsResponse> {
        private ListMlTransformsResponseFetcher() {
        }

        public boolean hasNextPage(ListMlTransformsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListMlTransformsResponse> nextPage(ListMlTransformsResponse previousPage) {
            if (previousPage == null) {
                return ListMLTransformsPublisher.this.client.listMLTransforms(ListMLTransformsPublisher.this.firstRequest);
            }
            return ListMLTransformsPublisher.this.client.listMLTransforms((ListMlTransformsRequest)((Object)ListMLTransformsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

