/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.glue.model.GlueResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateRegistryResponse
extends GlueResponse
implements ToCopyableBuilder<Builder, UpdateRegistryResponse> {
    private static final SdkField<String> REGISTRY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RegistryName").getter(UpdateRegistryResponse.getter(UpdateRegistryResponse::registryName)).setter(UpdateRegistryResponse.setter(Builder::registryName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RegistryName").build()}).build();
    private static final SdkField<String> REGISTRY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RegistryArn").getter(UpdateRegistryResponse.getter(UpdateRegistryResponse::registryArn)).setter(UpdateRegistryResponse.setter(Builder::registryArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RegistryArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REGISTRY_NAME_FIELD, REGISTRY_ARN_FIELD));
    private final String registryName;
    private final String registryArn;

    private UpdateRegistryResponse(BuilderImpl builder) {
        super(builder);
        this.registryName = builder.registryName;
        this.registryArn = builder.registryArn;
    }

    public String registryName() {
        return this.registryName;
    }

    public String registryArn() {
        return this.registryArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.registryName());
        hashCode = 31 * hashCode + Objects.hashCode(this.registryArn());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateRegistryResponse)) {
            return false;
        }
        UpdateRegistryResponse other = (UpdateRegistryResponse)((Object)obj);
        return Objects.equals(this.registryName(), other.registryName()) && Objects.equals(this.registryArn(), other.registryArn());
    }

    public String toString() {
        return ToString.builder((String)"UpdateRegistryResponse").add("RegistryName", (Object)this.registryName()).add("RegistryArn", (Object)this.registryArn()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RegistryName": {
                return Optional.ofNullable(clazz.cast(this.registryName()));
            }
            case "RegistryArn": {
                return Optional.ofNullable(clazz.cast(this.registryArn()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateRegistryResponse, T> g) {
        return obj -> g.apply((UpdateRegistryResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GlueResponse.BuilderImpl
    implements Builder {
        private String registryName;
        private String registryArn;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateRegistryResponse model) {
            super(model);
            this.registryName(model.registryName);
            this.registryArn(model.registryArn);
        }

        public final String getRegistryName() {
            return this.registryName;
        }

        @Override
        public final Builder registryName(String registryName) {
            this.registryName = registryName;
            return this;
        }

        public final void setRegistryName(String registryName) {
            this.registryName = registryName;
        }

        public final String getRegistryArn() {
            return this.registryArn;
        }

        @Override
        public final Builder registryArn(String registryArn) {
            this.registryArn = registryArn;
            return this;
        }

        public final void setRegistryArn(String registryArn) {
            this.registryArn = registryArn;
        }

        @Override
        public UpdateRegistryResponse build() {
            return new UpdateRegistryResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends GlueResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateRegistryResponse> {
        public Builder registryName(String var1);

        public Builder registryArn(String var1);
    }
}

