/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.glue.model.GlueResponse;
import software.amazon.awssdk.services.glue.model.MappingEntry;
import software.amazon.awssdk.services.glue.model.MappingListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetMappingResponse
extends GlueResponse
implements ToCopyableBuilder<Builder, GetMappingResponse> {
    private static final SdkField<List<MappingEntry>> MAPPING_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Mapping").getter(GetMappingResponse.getter(GetMappingResponse::mapping)).setter(GetMappingResponse.setter(Builder::mapping)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Mapping").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MappingEntry::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MAPPING_FIELD));
    private final List<MappingEntry> mapping;

    private GetMappingResponse(BuilderImpl builder) {
        super(builder);
        this.mapping = builder.mapping;
    }

    public boolean hasMapping() {
        return this.mapping != null && !(this.mapping instanceof SdkAutoConstructList);
    }

    public List<MappingEntry> mapping() {
        return this.mapping;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMapping() ? this.mapping() : null);
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetMappingResponse)) {
            return false;
        }
        GetMappingResponse other = (GetMappingResponse)((Object)obj);
        return this.hasMapping() == other.hasMapping() && Objects.equals(this.mapping(), other.mapping());
    }

    public String toString() {
        return ToString.builder((String)"GetMappingResponse").add("Mapping", this.hasMapping() ? this.mapping() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Mapping": {
                return Optional.ofNullable(clazz.cast(this.mapping()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetMappingResponse, T> g) {
        return obj -> g.apply((GetMappingResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GlueResponse.BuilderImpl
    implements Builder {
        private List<MappingEntry> mapping = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetMappingResponse model) {
            super(model);
            this.mapping(model.mapping);
        }

        public final Collection<MappingEntry.Builder> getMapping() {
            if (this.mapping instanceof SdkAutoConstructList) {
                return null;
            }
            return this.mapping != null ? (Collection)this.mapping.stream().map(MappingEntry::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder mapping(Collection<MappingEntry> mapping) {
            this.mapping = MappingListCopier.copy(mapping);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder mapping(MappingEntry ... mapping) {
            this.mapping(Arrays.asList(mapping));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder mapping(Consumer<MappingEntry.Builder> ... mapping) {
            this.mapping(Stream.of(mapping).map(c -> (MappingEntry)((MappingEntry.Builder)MappingEntry.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setMapping(Collection<MappingEntry.BuilderImpl> mapping) {
            this.mapping = MappingListCopier.copyFromBuilder(mapping);
        }

        @Override
        public GetMappingResponse build() {
            return new GetMappingResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends GlueResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetMappingResponse> {
        public Builder mapping(Collection<MappingEntry> var1);

        public Builder mapping(MappingEntry ... var1);

        public Builder mapping(Consumer<MappingEntry.Builder> ... var1);
    }
}

