/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.glue.model.GlueRequest;
import software.amazon.awssdk.services.glue.model.ResourceShareType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetDatabasesRequest
extends GlueRequest
implements ToCopyableBuilder<Builder, GetDatabasesRequest> {
    private static final SdkField<String> CATALOG_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CatalogId").getter(GetDatabasesRequest.getter(GetDatabasesRequest::catalogId)).setter(GetDatabasesRequest.setter(Builder::catalogId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CatalogId").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(GetDatabasesRequest.getter(GetDatabasesRequest::nextToken)).setter(GetDatabasesRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxResults").getter(GetDatabasesRequest.getter(GetDatabasesRequest::maxResults)).setter(GetDatabasesRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()}).build();
    private static final SdkField<String> RESOURCE_SHARE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceShareType").getter(GetDatabasesRequest.getter(GetDatabasesRequest::resourceShareTypeAsString)).setter(GetDatabasesRequest.setter(Builder::resourceShareType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceShareType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CATALOG_ID_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD, RESOURCE_SHARE_TYPE_FIELD));
    private final String catalogId;
    private final String nextToken;
    private final Integer maxResults;
    private final String resourceShareType;

    private GetDatabasesRequest(BuilderImpl builder) {
        super(builder);
        this.catalogId = builder.catalogId;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
        this.resourceShareType = builder.resourceShareType;
    }

    public String catalogId() {
        return this.catalogId;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Integer maxResults() {
        return this.maxResults;
    }

    public ResourceShareType resourceShareType() {
        return ResourceShareType.fromValue(this.resourceShareType);
    }

    public String resourceShareTypeAsString() {
        return this.resourceShareType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.catalogId());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceShareTypeAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDatabasesRequest)) {
            return false;
        }
        GetDatabasesRequest other = (GetDatabasesRequest)((Object)obj);
        return Objects.equals(this.catalogId(), other.catalogId()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.resourceShareTypeAsString(), other.resourceShareTypeAsString());
    }

    public String toString() {
        return ToString.builder((String)"GetDatabasesRequest").add("CatalogId", (Object)this.catalogId()).add("NextToken", (Object)this.nextToken()).add("MaxResults", (Object)this.maxResults()).add("ResourceShareType", (Object)this.resourceShareTypeAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CatalogId": {
                return Optional.ofNullable(clazz.cast(this.catalogId()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "ResourceShareType": {
                return Optional.ofNullable(clazz.cast(this.resourceShareTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetDatabasesRequest, T> g) {
        return obj -> g.apply((GetDatabasesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GlueRequest.BuilderImpl
    implements Builder {
        private String catalogId;
        private String nextToken;
        private Integer maxResults;
        private String resourceShareType;

        private BuilderImpl() {
        }

        private BuilderImpl(GetDatabasesRequest model) {
            super(model);
            this.catalogId(model.catalogId);
            this.nextToken(model.nextToken);
            this.maxResults(model.maxResults);
            this.resourceShareType(model.resourceShareType);
        }

        public final String getCatalogId() {
            return this.catalogId;
        }

        @Override
        public final Builder catalogId(String catalogId) {
            this.catalogId = catalogId;
            return this;
        }

        public final void setCatalogId(String catalogId) {
            this.catalogId = catalogId;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final String getResourceShareType() {
            return this.resourceShareType;
        }

        @Override
        public final Builder resourceShareType(String resourceShareType) {
            this.resourceShareType = resourceShareType;
            return this;
        }

        @Override
        public final Builder resourceShareType(ResourceShareType resourceShareType) {
            this.resourceShareType(resourceShareType == null ? null : resourceShareType.toString());
            return this;
        }

        public final void setResourceShareType(String resourceShareType) {
            this.resourceShareType = resourceShareType;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetDatabasesRequest build() {
            return new GetDatabasesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends GlueRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetDatabasesRequest> {
        public Builder catalogId(String var1);

        public Builder nextToken(String var1);

        public Builder maxResults(Integer var1);

        public Builder resourceShareType(String var1);

        public Builder resourceShareType(ResourceShareType var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

