/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Segment
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Segment> {
    private static final SdkField<Integer> SEGMENT_NUMBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("SegmentNumber").getter(Segment.getter(Segment::segmentNumber)).setter(Segment.setter(Builder::segmentNumber)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SegmentNumber").build()}).build();
    private static final SdkField<Integer> TOTAL_SEGMENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("TotalSegments").getter(Segment.getter(Segment::totalSegments)).setter(Segment.setter(Builder::totalSegments)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalSegments").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SEGMENT_NUMBER_FIELD, TOTAL_SEGMENTS_FIELD));
    private static final long serialVersionUID = 1L;
    private final Integer segmentNumber;
    private final Integer totalSegments;

    private Segment(BuilderImpl builder) {
        this.segmentNumber = builder.segmentNumber;
        this.totalSegments = builder.totalSegments;
    }

    public Integer segmentNumber() {
        return this.segmentNumber;
    }

    public Integer totalSegments() {
        return this.totalSegments;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.segmentNumber());
        hashCode = 31 * hashCode + Objects.hashCode(this.totalSegments());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Segment)) {
            return false;
        }
        Segment other = (Segment)obj;
        return Objects.equals(this.segmentNumber(), other.segmentNumber()) && Objects.equals(this.totalSegments(), other.totalSegments());
    }

    public String toString() {
        return ToString.builder((String)"Segment").add("SegmentNumber", (Object)this.segmentNumber()).add("TotalSegments", (Object)this.totalSegments()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SegmentNumber": {
                return Optional.ofNullable(clazz.cast(this.segmentNumber()));
            }
            case "TotalSegments": {
                return Optional.ofNullable(clazz.cast(this.totalSegments()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Segment, T> g) {
        return obj -> g.apply((Segment)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer segmentNumber;
        private Integer totalSegments;

        private BuilderImpl() {
        }

        private BuilderImpl(Segment model) {
            this.segmentNumber(model.segmentNumber);
            this.totalSegments(model.totalSegments);
        }

        public final Integer getSegmentNumber() {
            return this.segmentNumber;
        }

        @Override
        public final Builder segmentNumber(Integer segmentNumber) {
            this.segmentNumber = segmentNumber;
            return this;
        }

        public final void setSegmentNumber(Integer segmentNumber) {
            this.segmentNumber = segmentNumber;
        }

        public final Integer getTotalSegments() {
            return this.totalSegments;
        }

        @Override
        public final Builder totalSegments(Integer totalSegments) {
            this.totalSegments = totalSegments;
            return this;
        }

        public final void setTotalSegments(Integer totalSegments) {
            this.totalSegments = totalSegments;
        }

        public Segment build() {
            return new Segment(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Segment> {
        public Builder segmentNumber(Integer var1);

        public Builder totalSegments(Integer var1);
    }
}

