/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BooleanColumnStatisticsData
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, BooleanColumnStatisticsData> {
    private static final SdkField<Long> NUMBER_OF_TRUES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).getter(BooleanColumnStatisticsData.getter(BooleanColumnStatisticsData::numberOfTrues)).setter(BooleanColumnStatisticsData.setter(Builder::numberOfTrues)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberOfTrues").build()}).build();
    private static final SdkField<Long> NUMBER_OF_FALSES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).getter(BooleanColumnStatisticsData.getter(BooleanColumnStatisticsData::numberOfFalses)).setter(BooleanColumnStatisticsData.setter(Builder::numberOfFalses)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberOfFalses").build()}).build();
    private static final SdkField<Long> NUMBER_OF_NULLS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).getter(BooleanColumnStatisticsData.getter(BooleanColumnStatisticsData::numberOfNulls)).setter(BooleanColumnStatisticsData.setter(Builder::numberOfNulls)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberOfNulls").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NUMBER_OF_TRUES_FIELD, NUMBER_OF_FALSES_FIELD, NUMBER_OF_NULLS_FIELD));
    private static final long serialVersionUID = 1L;
    private final Long numberOfTrues;
    private final Long numberOfFalses;
    private final Long numberOfNulls;

    private BooleanColumnStatisticsData(BuilderImpl builder) {
        this.numberOfTrues = builder.numberOfTrues;
        this.numberOfFalses = builder.numberOfFalses;
        this.numberOfNulls = builder.numberOfNulls;
    }

    public Long numberOfTrues() {
        return this.numberOfTrues;
    }

    public Long numberOfFalses() {
        return this.numberOfFalses;
    }

    public Long numberOfNulls() {
        return this.numberOfNulls;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.numberOfTrues());
        hashCode = 31 * hashCode + Objects.hashCode(this.numberOfFalses());
        hashCode = 31 * hashCode + Objects.hashCode(this.numberOfNulls());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BooleanColumnStatisticsData)) {
            return false;
        }
        BooleanColumnStatisticsData other = (BooleanColumnStatisticsData)obj;
        return Objects.equals(this.numberOfTrues(), other.numberOfTrues()) && Objects.equals(this.numberOfFalses(), other.numberOfFalses()) && Objects.equals(this.numberOfNulls(), other.numberOfNulls());
    }

    public String toString() {
        return ToString.builder((String)"BooleanColumnStatisticsData").add("NumberOfTrues", (Object)this.numberOfTrues()).add("NumberOfFalses", (Object)this.numberOfFalses()).add("NumberOfNulls", (Object)this.numberOfNulls()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NumberOfTrues": {
                return Optional.ofNullable(clazz.cast(this.numberOfTrues()));
            }
            case "NumberOfFalses": {
                return Optional.ofNullable(clazz.cast(this.numberOfFalses()));
            }
            case "NumberOfNulls": {
                return Optional.ofNullable(clazz.cast(this.numberOfNulls()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BooleanColumnStatisticsData, T> g) {
        return obj -> g.apply((BooleanColumnStatisticsData)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Long numberOfTrues;
        private Long numberOfFalses;
        private Long numberOfNulls;

        private BuilderImpl() {
        }

        private BuilderImpl(BooleanColumnStatisticsData model) {
            this.numberOfTrues(model.numberOfTrues);
            this.numberOfFalses(model.numberOfFalses);
            this.numberOfNulls(model.numberOfNulls);
        }

        public final Long getNumberOfTrues() {
            return this.numberOfTrues;
        }

        @Override
        public final Builder numberOfTrues(Long numberOfTrues) {
            this.numberOfTrues = numberOfTrues;
            return this;
        }

        public final void setNumberOfTrues(Long numberOfTrues) {
            this.numberOfTrues = numberOfTrues;
        }

        public final Long getNumberOfFalses() {
            return this.numberOfFalses;
        }

        @Override
        public final Builder numberOfFalses(Long numberOfFalses) {
            this.numberOfFalses = numberOfFalses;
            return this;
        }

        public final void setNumberOfFalses(Long numberOfFalses) {
            this.numberOfFalses = numberOfFalses;
        }

        public final Long getNumberOfNulls() {
            return this.numberOfNulls;
        }

        @Override
        public final Builder numberOfNulls(Long numberOfNulls) {
            this.numberOfNulls = numberOfNulls;
            return this;
        }

        public final void setNumberOfNulls(Long numberOfNulls) {
            this.numberOfNulls = numberOfNulls;
        }

        public BooleanColumnStatisticsData build() {
            return new BooleanColumnStatisticsData(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, BooleanColumnStatisticsData> {
        public Builder numberOfTrues(Long var1);

        public Builder numberOfFalses(Long var1);

        public Builder numberOfNulls(Long var1);
    }
}

