/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.glue.model.GlueRequest;
import software.amazon.awssdk.services.glue.model.PartitionIndex;
import software.amazon.awssdk.services.glue.model.PartitionIndexListCopier;
import software.amazon.awssdk.services.glue.model.TableInput;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateTableRequest
extends GlueRequest
implements ToCopyableBuilder<Builder, CreateTableRequest> {
    private static final SdkField<String> CATALOG_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateTableRequest.getter(CreateTableRequest::catalogId)).setter(CreateTableRequest.setter(Builder::catalogId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CatalogId").build()}).build();
    private static final SdkField<String> DATABASE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateTableRequest.getter(CreateTableRequest::databaseName)).setter(CreateTableRequest.setter(Builder::databaseName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatabaseName").build()}).build();
    private static final SdkField<TableInput> TABLE_INPUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(CreateTableRequest.getter(CreateTableRequest::tableInput)).setter(CreateTableRequest.setter(Builder::tableInput)).constructor(TableInput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TableInput").build()}).build();
    private static final SdkField<List<PartitionIndex>> PARTITION_INDEXES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(CreateTableRequest.getter(CreateTableRequest::partitionIndexes)).setter(CreateTableRequest.setter(Builder::partitionIndexes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PartitionIndexes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PartitionIndex::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CATALOG_ID_FIELD, DATABASE_NAME_FIELD, TABLE_INPUT_FIELD, PARTITION_INDEXES_FIELD));
    private final String catalogId;
    private final String databaseName;
    private final TableInput tableInput;
    private final List<PartitionIndex> partitionIndexes;

    private CreateTableRequest(BuilderImpl builder) {
        super(builder);
        this.catalogId = builder.catalogId;
        this.databaseName = builder.databaseName;
        this.tableInput = builder.tableInput;
        this.partitionIndexes = builder.partitionIndexes;
    }

    public String catalogId() {
        return this.catalogId;
    }

    public String databaseName() {
        return this.databaseName;
    }

    public TableInput tableInput() {
        return this.tableInput;
    }

    public boolean hasPartitionIndexes() {
        return this.partitionIndexes != null && !(this.partitionIndexes instanceof SdkAutoConstructList);
    }

    public List<PartitionIndex> partitionIndexes() {
        return this.partitionIndexes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.catalogId());
        hashCode = 31 * hashCode + Objects.hashCode(this.databaseName());
        hashCode = 31 * hashCode + Objects.hashCode(this.tableInput());
        hashCode = 31 * hashCode + Objects.hashCode(this.partitionIndexes());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateTableRequest)) {
            return false;
        }
        CreateTableRequest other = (CreateTableRequest)((Object)obj);
        return Objects.equals(this.catalogId(), other.catalogId()) && Objects.equals(this.databaseName(), other.databaseName()) && Objects.equals(this.tableInput(), other.tableInput()) && Objects.equals(this.partitionIndexes(), other.partitionIndexes());
    }

    public String toString() {
        return ToString.builder((String)"CreateTableRequest").add("CatalogId", (Object)this.catalogId()).add("DatabaseName", (Object)this.databaseName()).add("TableInput", (Object)this.tableInput()).add("PartitionIndexes", this.partitionIndexes()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CatalogId": {
                return Optional.ofNullable(clazz.cast(this.catalogId()));
            }
            case "DatabaseName": {
                return Optional.ofNullable(clazz.cast(this.databaseName()));
            }
            case "TableInput": {
                return Optional.ofNullable(clazz.cast(this.tableInput()));
            }
            case "PartitionIndexes": {
                return Optional.ofNullable(clazz.cast(this.partitionIndexes()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateTableRequest, T> g) {
        return obj -> g.apply((CreateTableRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GlueRequest.BuilderImpl
    implements Builder {
        private String catalogId;
        private String databaseName;
        private TableInput tableInput;
        private List<PartitionIndex> partitionIndexes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateTableRequest model) {
            super(model);
            this.catalogId(model.catalogId);
            this.databaseName(model.databaseName);
            this.tableInput(model.tableInput);
            this.partitionIndexes(model.partitionIndexes);
        }

        public final String getCatalogId() {
            return this.catalogId;
        }

        @Override
        public final Builder catalogId(String catalogId) {
            this.catalogId = catalogId;
            return this;
        }

        public final void setCatalogId(String catalogId) {
            this.catalogId = catalogId;
        }

        public final String getDatabaseName() {
            return this.databaseName;
        }

        @Override
        public final Builder databaseName(String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        public final void setDatabaseName(String databaseName) {
            this.databaseName = databaseName;
        }

        public final TableInput.Builder getTableInput() {
            return this.tableInput != null ? this.tableInput.toBuilder() : null;
        }

        @Override
        public final Builder tableInput(TableInput tableInput) {
            this.tableInput = tableInput;
            return this;
        }

        public final void setTableInput(TableInput.BuilderImpl tableInput) {
            this.tableInput = tableInput != null ? tableInput.build() : null;
        }

        public final Collection<PartitionIndex.Builder> getPartitionIndexes() {
            return this.partitionIndexes != null ? (Collection)this.partitionIndexes.stream().map(PartitionIndex::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder partitionIndexes(Collection<PartitionIndex> partitionIndexes) {
            this.partitionIndexes = PartitionIndexListCopier.copy(partitionIndexes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder partitionIndexes(PartitionIndex ... partitionIndexes) {
            this.partitionIndexes(Arrays.asList(partitionIndexes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder partitionIndexes(Consumer<PartitionIndex.Builder> ... partitionIndexes) {
            this.partitionIndexes(Stream.of(partitionIndexes).map(c -> (PartitionIndex)((PartitionIndex.Builder)PartitionIndex.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setPartitionIndexes(Collection<PartitionIndex.BuilderImpl> partitionIndexes) {
            this.partitionIndexes = PartitionIndexListCopier.copyFromBuilder(partitionIndexes);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateTableRequest build() {
            return new CreateTableRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends GlueRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateTableRequest> {
        public Builder catalogId(String var1);

        public Builder databaseName(String var1);

        public Builder tableInput(TableInput var1);

        default public Builder tableInput(Consumer<TableInput.Builder> tableInput) {
            return this.tableInput((TableInput)((TableInput.Builder)TableInput.builder().applyMutation(tableInput)).build());
        }

        public Builder partitionIndexes(Collection<PartitionIndex> var1);

        public Builder partitionIndexes(PartitionIndex ... var1);

        public Builder partitionIndexes(Consumer<PartitionIndex.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

