/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents a collection of related data organized in columns and rows.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Table implements SdkPojo, Serializable, ToCopyableBuilder<Table.Builder, Table> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Table::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> DATABASE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Table::databaseName)).setter(setter(Builder::databaseName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatabaseName").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Table::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> OWNER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Table::owner)).setter(setter(Builder::owner))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Owner").build()).build();

    private static final SdkField<Instant> CREATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(Table::createTime)).setter(setter(Builder::createTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreateTime").build()).build();

    private static final SdkField<Instant> UPDATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(Table::updateTime)).setter(setter(Builder::updateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdateTime").build()).build();

    private static final SdkField<Instant> LAST_ACCESS_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(Table::lastAccessTime)).setter(setter(Builder::lastAccessTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastAccessTime").build()).build();

    private static final SdkField<Instant> LAST_ANALYZED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(Table::lastAnalyzedTime)).setter(setter(Builder::lastAnalyzedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastAnalyzedTime").build()).build();

    private static final SdkField<Integer> RETENTION_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(Table::retention)).setter(setter(Builder::retention))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Retention").build()).build();

    private static final SdkField<StorageDescriptor> STORAGE_DESCRIPTOR_FIELD = SdkField
            .<StorageDescriptor> builder(MarshallingType.SDK_POJO).getter(getter(Table::storageDescriptor))
            .setter(setter(Builder::storageDescriptor)).constructor(StorageDescriptor::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StorageDescriptor").build()).build();

    private static final SdkField<List<Column>> PARTITION_KEYS_FIELD = SdkField
            .<List<Column>> builder(MarshallingType.LIST)
            .getter(getter(Table::partitionKeys))
            .setter(setter(Builder::partitionKeys))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PartitionKeys").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Column> builder(MarshallingType.SDK_POJO)
                                            .constructor(Column::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> VIEW_ORIGINAL_TEXT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Table::viewOriginalText)).setter(setter(Builder::viewOriginalText))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ViewOriginalText").build()).build();

    private static final SdkField<String> VIEW_EXPANDED_TEXT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Table::viewExpandedText)).setter(setter(Builder::viewExpandedText))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ViewExpandedText").build()).build();

    private static final SdkField<String> TABLE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Table::tableType)).setter(setter(Builder::tableType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TableType").build()).build();

    private static final SdkField<Map<String, String>> PARAMETERS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .getter(getter(Table::parameters))
            .setter(setter(Builder::parameters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Parameters").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> CREATED_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Table::createdBy)).setter(setter(Builder::createdBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedBy").build()).build();

    private static final SdkField<Boolean> IS_REGISTERED_WITH_LAKE_FORMATION_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(Table::isRegisteredWithLakeFormation))
            .setter(setter(Builder::isRegisteredWithLakeFormation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsRegisteredWithLakeFormation")
                    .build()).build();

    private static final SdkField<TableIdentifier> TARGET_TABLE_FIELD = SdkField
            .<TableIdentifier> builder(MarshallingType.SDK_POJO).getter(getter(Table::targetTable))
            .setter(setter(Builder::targetTable)).constructor(TableIdentifier::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetTable").build()).build();

    private static final SdkField<String> CATALOG_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Table::catalogId)).setter(setter(Builder::catalogId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CatalogId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD,
            DATABASE_NAME_FIELD, DESCRIPTION_FIELD, OWNER_FIELD, CREATE_TIME_FIELD, UPDATE_TIME_FIELD, LAST_ACCESS_TIME_FIELD,
            LAST_ANALYZED_TIME_FIELD, RETENTION_FIELD, STORAGE_DESCRIPTOR_FIELD, PARTITION_KEYS_FIELD, VIEW_ORIGINAL_TEXT_FIELD,
            VIEW_EXPANDED_TEXT_FIELD, TABLE_TYPE_FIELD, PARAMETERS_FIELD, CREATED_BY_FIELD,
            IS_REGISTERED_WITH_LAKE_FORMATION_FIELD, TARGET_TABLE_FIELD, CATALOG_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String databaseName;

    private final String description;

    private final String owner;

    private final Instant createTime;

    private final Instant updateTime;

    private final Instant lastAccessTime;

    private final Instant lastAnalyzedTime;

    private final Integer retention;

    private final StorageDescriptor storageDescriptor;

    private final List<Column> partitionKeys;

    private final String viewOriginalText;

    private final String viewExpandedText;

    private final String tableType;

    private final Map<String, String> parameters;

    private final String createdBy;

    private final Boolean isRegisteredWithLakeFormation;

    private final TableIdentifier targetTable;

    private final String catalogId;

    private Table(BuilderImpl builder) {
        this.name = builder.name;
        this.databaseName = builder.databaseName;
        this.description = builder.description;
        this.owner = builder.owner;
        this.createTime = builder.createTime;
        this.updateTime = builder.updateTime;
        this.lastAccessTime = builder.lastAccessTime;
        this.lastAnalyzedTime = builder.lastAnalyzedTime;
        this.retention = builder.retention;
        this.storageDescriptor = builder.storageDescriptor;
        this.partitionKeys = builder.partitionKeys;
        this.viewOriginalText = builder.viewOriginalText;
        this.viewExpandedText = builder.viewExpandedText;
        this.tableType = builder.tableType;
        this.parameters = builder.parameters;
        this.createdBy = builder.createdBy;
        this.isRegisteredWithLakeFormation = builder.isRegisteredWithLakeFormation;
        this.targetTable = builder.targetTable;
        this.catalogId = builder.catalogId;
    }

    /**
     * <p>
     * The table name. For Hive compatibility, this must be entirely lowercase.
     * </p>
     * 
     * @return The table name. For Hive compatibility, this must be entirely lowercase.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * The name of the database where the table metadata resides. For Hive compatibility, this must be all lowercase.
     * </p>
     * 
     * @return The name of the database where the table metadata resides. For Hive compatibility, this must be all
     *         lowercase.
     */
    public String databaseName() {
        return databaseName;
    }

    /**
     * <p>
     * A description of the table.
     * </p>
     * 
     * @return A description of the table.
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * The owner of the table.
     * </p>
     * 
     * @return The owner of the table.
     */
    public String owner() {
        return owner;
    }

    /**
     * <p>
     * The time when the table definition was created in the Data Catalog.
     * </p>
     * 
     * @return The time when the table definition was created in the Data Catalog.
     */
    public Instant createTime() {
        return createTime;
    }

    /**
     * <p>
     * The last time that the table was updated.
     * </p>
     * 
     * @return The last time that the table was updated.
     */
    public Instant updateTime() {
        return updateTime;
    }

    /**
     * <p>
     * The last time that the table was accessed. This is usually taken from HDFS, and might not be reliable.
     * </p>
     * 
     * @return The last time that the table was accessed. This is usually taken from HDFS, and might not be reliable.
     */
    public Instant lastAccessTime() {
        return lastAccessTime;
    }

    /**
     * <p>
     * The last time that column statistics were computed for this table.
     * </p>
     * 
     * @return The last time that column statistics were computed for this table.
     */
    public Instant lastAnalyzedTime() {
        return lastAnalyzedTime;
    }

    /**
     * <p>
     * The retention time for this table.
     * </p>
     * 
     * @return The retention time for this table.
     */
    public Integer retention() {
        return retention;
    }

    /**
     * <p>
     * A storage descriptor containing information about the physical storage of this table.
     * </p>
     * 
     * @return A storage descriptor containing information about the physical storage of this table.
     */
    public StorageDescriptor storageDescriptor() {
        return storageDescriptor;
    }

    /**
     * Returns true if the PartitionKeys property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasPartitionKeys() {
        return partitionKeys != null && !(partitionKeys instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of columns by which the table is partitioned. Only primitive types are supported as partition keys.
     * </p>
     * <p>
     * When you create a table used by Amazon Athena, and you do not specify any <code>partitionKeys</code>, you must at
     * least set the value of <code>partitionKeys</code> to an empty list. For example:
     * </p>
     * <p>
     * <code>"PartitionKeys": []</code>
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasPartitionKeys()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of columns by which the table is partitioned. Only primitive types are supported as partition
     *         keys.</p>
     *         <p>
     *         When you create a table used by Amazon Athena, and you do not specify any <code>partitionKeys</code>, you
     *         must at least set the value of <code>partitionKeys</code> to an empty list. For example:
     *         </p>
     *         <p>
     *         <code>"PartitionKeys": []</code>
     */
    public List<Column> partitionKeys() {
        return partitionKeys;
    }

    /**
     * <p>
     * If the table is a view, the original text of the view; otherwise <code>null</code>.
     * </p>
     * 
     * @return If the table is a view, the original text of the view; otherwise <code>null</code>.
     */
    public String viewOriginalText() {
        return viewOriginalText;
    }

    /**
     * <p>
     * If the table is a view, the expanded text of the view; otherwise <code>null</code>.
     * </p>
     * 
     * @return If the table is a view, the expanded text of the view; otherwise <code>null</code>.
     */
    public String viewExpandedText() {
        return viewExpandedText;
    }

    /**
     * <p>
     * The type of this table (<code>EXTERNAL_TABLE</code>, <code>VIRTUAL_VIEW</code>, etc.).
     * </p>
     * 
     * @return The type of this table (<code>EXTERNAL_TABLE</code>, <code>VIRTUAL_VIEW</code>, etc.).
     */
    public String tableType() {
        return tableType;
    }

    /**
     * Returns true if the Parameters property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasParameters() {
        return parameters != null && !(parameters instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * These key-value pairs define properties associated with the table.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasParameters()} to see if a value was sent in this field.
     * </p>
     * 
     * @return These key-value pairs define properties associated with the table.
     */
    public Map<String, String> parameters() {
        return parameters;
    }

    /**
     * <p>
     * The person or entity who created the table.
     * </p>
     * 
     * @return The person or entity who created the table.
     */
    public String createdBy() {
        return createdBy;
    }

    /**
     * <p>
     * Indicates whether the table has been registered with AWS Lake Formation.
     * </p>
     * 
     * @return Indicates whether the table has been registered with AWS Lake Formation.
     */
    public Boolean isRegisteredWithLakeFormation() {
        return isRegisteredWithLakeFormation;
    }

    /**
     * <p>
     * A <code>TableIdentifier</code> structure that describes a target table for resource linking.
     * </p>
     * 
     * @return A <code>TableIdentifier</code> structure that describes a target table for resource linking.
     */
    public TableIdentifier targetTable() {
        return targetTable;
    }

    /**
     * <p>
     * The ID of the Data Catalog in which the table resides.
     * </p>
     * 
     * @return The ID of the Data Catalog in which the table resides.
     */
    public String catalogId() {
        return catalogId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(databaseName());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(owner());
        hashCode = 31 * hashCode + Objects.hashCode(createTime());
        hashCode = 31 * hashCode + Objects.hashCode(updateTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastAccessTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastAnalyzedTime());
        hashCode = 31 * hashCode + Objects.hashCode(retention());
        hashCode = 31 * hashCode + Objects.hashCode(storageDescriptor());
        hashCode = 31 * hashCode + Objects.hashCode(partitionKeys());
        hashCode = 31 * hashCode + Objects.hashCode(viewOriginalText());
        hashCode = 31 * hashCode + Objects.hashCode(viewExpandedText());
        hashCode = 31 * hashCode + Objects.hashCode(tableType());
        hashCode = 31 * hashCode + Objects.hashCode(parameters());
        hashCode = 31 * hashCode + Objects.hashCode(createdBy());
        hashCode = 31 * hashCode + Objects.hashCode(isRegisteredWithLakeFormation());
        hashCode = 31 * hashCode + Objects.hashCode(targetTable());
        hashCode = 31 * hashCode + Objects.hashCode(catalogId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Table)) {
            return false;
        }
        Table other = (Table) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(databaseName(), other.databaseName())
                && Objects.equals(description(), other.description()) && Objects.equals(owner(), other.owner())
                && Objects.equals(createTime(), other.createTime()) && Objects.equals(updateTime(), other.updateTime())
                && Objects.equals(lastAccessTime(), other.lastAccessTime())
                && Objects.equals(lastAnalyzedTime(), other.lastAnalyzedTime()) && Objects.equals(retention(), other.retention())
                && Objects.equals(storageDescriptor(), other.storageDescriptor())
                && Objects.equals(partitionKeys(), other.partitionKeys())
                && Objects.equals(viewOriginalText(), other.viewOriginalText())
                && Objects.equals(viewExpandedText(), other.viewExpandedText()) && Objects.equals(tableType(), other.tableType())
                && Objects.equals(parameters(), other.parameters()) && Objects.equals(createdBy(), other.createdBy())
                && Objects.equals(isRegisteredWithLakeFormation(), other.isRegisteredWithLakeFormation())
                && Objects.equals(targetTable(), other.targetTable()) && Objects.equals(catalogId(), other.catalogId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("Table").add("Name", name()).add("DatabaseName", databaseName())
                .add("Description", description()).add("Owner", owner()).add("CreateTime", createTime())
                .add("UpdateTime", updateTime()).add("LastAccessTime", lastAccessTime())
                .add("LastAnalyzedTime", lastAnalyzedTime()).add("Retention", retention())
                .add("StorageDescriptor", storageDescriptor()).add("PartitionKeys", partitionKeys())
                .add("ViewOriginalText", viewOriginalText()).add("ViewExpandedText", viewExpandedText())
                .add("TableType", tableType()).add("Parameters", parameters()).add("CreatedBy", createdBy())
                .add("IsRegisteredWithLakeFormation", isRegisteredWithLakeFormation()).add("TargetTable", targetTable())
                .add("CatalogId", catalogId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "DatabaseName":
            return Optional.ofNullable(clazz.cast(databaseName()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "Owner":
            return Optional.ofNullable(clazz.cast(owner()));
        case "CreateTime":
            return Optional.ofNullable(clazz.cast(createTime()));
        case "UpdateTime":
            return Optional.ofNullable(clazz.cast(updateTime()));
        case "LastAccessTime":
            return Optional.ofNullable(clazz.cast(lastAccessTime()));
        case "LastAnalyzedTime":
            return Optional.ofNullable(clazz.cast(lastAnalyzedTime()));
        case "Retention":
            return Optional.ofNullable(clazz.cast(retention()));
        case "StorageDescriptor":
            return Optional.ofNullable(clazz.cast(storageDescriptor()));
        case "PartitionKeys":
            return Optional.ofNullable(clazz.cast(partitionKeys()));
        case "ViewOriginalText":
            return Optional.ofNullable(clazz.cast(viewOriginalText()));
        case "ViewExpandedText":
            return Optional.ofNullable(clazz.cast(viewExpandedText()));
        case "TableType":
            return Optional.ofNullable(clazz.cast(tableType()));
        case "Parameters":
            return Optional.ofNullable(clazz.cast(parameters()));
        case "CreatedBy":
            return Optional.ofNullable(clazz.cast(createdBy()));
        case "IsRegisteredWithLakeFormation":
            return Optional.ofNullable(clazz.cast(isRegisteredWithLakeFormation()));
        case "TargetTable":
            return Optional.ofNullable(clazz.cast(targetTable()));
        case "CatalogId":
            return Optional.ofNullable(clazz.cast(catalogId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Table, T> g) {
        return obj -> g.apply((Table) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Table> {
        /**
         * <p>
         * The table name. For Hive compatibility, this must be entirely lowercase.
         * </p>
         * 
         * @param name
         *        The table name. For Hive compatibility, this must be entirely lowercase.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The name of the database where the table metadata resides. For Hive compatibility, this must be all
         * lowercase.
         * </p>
         * 
         * @param databaseName
         *        The name of the database where the table metadata resides. For Hive compatibility, this must be all
         *        lowercase.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder databaseName(String databaseName);

        /**
         * <p>
         * A description of the table.
         * </p>
         * 
         * @param description
         *        A description of the table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The owner of the table.
         * </p>
         * 
         * @param owner
         *        The owner of the table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder owner(String owner);

        /**
         * <p>
         * The time when the table definition was created in the Data Catalog.
         * </p>
         * 
         * @param createTime
         *        The time when the table definition was created in the Data Catalog.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createTime(Instant createTime);

        /**
         * <p>
         * The last time that the table was updated.
         * </p>
         * 
         * @param updateTime
         *        The last time that the table was updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updateTime(Instant updateTime);

        /**
         * <p>
         * The last time that the table was accessed. This is usually taken from HDFS, and might not be reliable.
         * </p>
         * 
         * @param lastAccessTime
         *        The last time that the table was accessed. This is usually taken from HDFS, and might not be reliable.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastAccessTime(Instant lastAccessTime);

        /**
         * <p>
         * The last time that column statistics were computed for this table.
         * </p>
         * 
         * @param lastAnalyzedTime
         *        The last time that column statistics were computed for this table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastAnalyzedTime(Instant lastAnalyzedTime);

        /**
         * <p>
         * The retention time for this table.
         * </p>
         * 
         * @param retention
         *        The retention time for this table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder retention(Integer retention);

        /**
         * <p>
         * A storage descriptor containing information about the physical storage of this table.
         * </p>
         * 
         * @param storageDescriptor
         *        A storage descriptor containing information about the physical storage of this table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder storageDescriptor(StorageDescriptor storageDescriptor);

        /**
         * <p>
         * A storage descriptor containing information about the physical storage of this table.
         * </p>
         * This is a convenience that creates an instance of the {@link StorageDescriptor.Builder} avoiding the need to
         * create one manually via {@link StorageDescriptor#builder()}.
         *
         * When the {@link Consumer} completes, {@link StorageDescriptor.Builder#build()} is called immediately and its
         * result is passed to {@link #storageDescriptor(StorageDescriptor)}.
         * 
         * @param storageDescriptor
         *        a consumer that will call methods on {@link StorageDescriptor.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #storageDescriptor(StorageDescriptor)
         */
        default Builder storageDescriptor(Consumer<StorageDescriptor.Builder> storageDescriptor) {
            return storageDescriptor(StorageDescriptor.builder().applyMutation(storageDescriptor).build());
        }

        /**
         * <p>
         * A list of columns by which the table is partitioned. Only primitive types are supported as partition keys.
         * </p>
         * <p>
         * When you create a table used by Amazon Athena, and you do not specify any <code>partitionKeys</code>, you
         * must at least set the value of <code>partitionKeys</code> to an empty list. For example:
         * </p>
         * <p>
         * <code>"PartitionKeys": []</code>
         * </p>
         * 
         * @param partitionKeys
         *        A list of columns by which the table is partitioned. Only primitive types are supported as partition
         *        keys.</p>
         *        <p>
         *        When you create a table used by Amazon Athena, and you do not specify any <code>partitionKeys</code>,
         *        you must at least set the value of <code>partitionKeys</code> to an empty list. For example:
         *        </p>
         *        <p>
         *        <code>"PartitionKeys": []</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder partitionKeys(Collection<Column> partitionKeys);

        /**
         * <p>
         * A list of columns by which the table is partitioned. Only primitive types are supported as partition keys.
         * </p>
         * <p>
         * When you create a table used by Amazon Athena, and you do not specify any <code>partitionKeys</code>, you
         * must at least set the value of <code>partitionKeys</code> to an empty list. For example:
         * </p>
         * <p>
         * <code>"PartitionKeys": []</code>
         * </p>
         * 
         * @param partitionKeys
         *        A list of columns by which the table is partitioned. Only primitive types are supported as partition
         *        keys.</p>
         *        <p>
         *        When you create a table used by Amazon Athena, and you do not specify any <code>partitionKeys</code>,
         *        you must at least set the value of <code>partitionKeys</code> to an empty list. For example:
         *        </p>
         *        <p>
         *        <code>"PartitionKeys": []</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder partitionKeys(Column... partitionKeys);

        /**
         * <p>
         * A list of columns by which the table is partitioned. Only primitive types are supported as partition keys.
         * </p>
         * <p>
         * When you create a table used by Amazon Athena, and you do not specify any <code>partitionKeys</code>, you
         * must at least set the value of <code>partitionKeys</code> to an empty list. For example:
         * </p>
         * <p>
         * <code>"PartitionKeys": []</code>
         * </p>
         * This is a convenience that creates an instance of the {@link List<Column>.Builder} avoiding the need to
         * create one manually via {@link List<Column>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Column>.Builder#build()} is called immediately and its
         * result is passed to {@link #partitionKeys(List<Column>)}.
         * 
         * @param partitionKeys
         *        a consumer that will call methods on {@link List<Column>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #partitionKeys(List<Column>)
         */
        Builder partitionKeys(Consumer<Column.Builder>... partitionKeys);

        /**
         * <p>
         * If the table is a view, the original text of the view; otherwise <code>null</code>.
         * </p>
         * 
         * @param viewOriginalText
         *        If the table is a view, the original text of the view; otherwise <code>null</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder viewOriginalText(String viewOriginalText);

        /**
         * <p>
         * If the table is a view, the expanded text of the view; otherwise <code>null</code>.
         * </p>
         * 
         * @param viewExpandedText
         *        If the table is a view, the expanded text of the view; otherwise <code>null</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder viewExpandedText(String viewExpandedText);

        /**
         * <p>
         * The type of this table (<code>EXTERNAL_TABLE</code>, <code>VIRTUAL_VIEW</code>, etc.).
         * </p>
         * 
         * @param tableType
         *        The type of this table (<code>EXTERNAL_TABLE</code>, <code>VIRTUAL_VIEW</code>, etc.).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tableType(String tableType);

        /**
         * <p>
         * These key-value pairs define properties associated with the table.
         * </p>
         * 
         * @param parameters
         *        These key-value pairs define properties associated with the table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameters(Map<String, String> parameters);

        /**
         * <p>
         * The person or entity who created the table.
         * </p>
         * 
         * @param createdBy
         *        The person or entity who created the table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdBy(String createdBy);

        /**
         * <p>
         * Indicates whether the table has been registered with AWS Lake Formation.
         * </p>
         * 
         * @param isRegisteredWithLakeFormation
         *        Indicates whether the table has been registered with AWS Lake Formation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isRegisteredWithLakeFormation(Boolean isRegisteredWithLakeFormation);

        /**
         * <p>
         * A <code>TableIdentifier</code> structure that describes a target table for resource linking.
         * </p>
         * 
         * @param targetTable
         *        A <code>TableIdentifier</code> structure that describes a target table for resource linking.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetTable(TableIdentifier targetTable);

        /**
         * <p>
         * A <code>TableIdentifier</code> structure that describes a target table for resource linking.
         * </p>
         * This is a convenience that creates an instance of the {@link TableIdentifier.Builder} avoiding the need to
         * create one manually via {@link TableIdentifier#builder()}.
         *
         * When the {@link Consumer} completes, {@link TableIdentifier.Builder#build()} is called immediately and its
         * result is passed to {@link #targetTable(TableIdentifier)}.
         * 
         * @param targetTable
         *        a consumer that will call methods on {@link TableIdentifier.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #targetTable(TableIdentifier)
         */
        default Builder targetTable(Consumer<TableIdentifier.Builder> targetTable) {
            return targetTable(TableIdentifier.builder().applyMutation(targetTable).build());
        }

        /**
         * <p>
         * The ID of the Data Catalog in which the table resides.
         * </p>
         * 
         * @param catalogId
         *        The ID of the Data Catalog in which the table resides.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder catalogId(String catalogId);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String databaseName;

        private String description;

        private String owner;

        private Instant createTime;

        private Instant updateTime;

        private Instant lastAccessTime;

        private Instant lastAnalyzedTime;

        private Integer retention;

        private StorageDescriptor storageDescriptor;

        private List<Column> partitionKeys = DefaultSdkAutoConstructList.getInstance();

        private String viewOriginalText;

        private String viewExpandedText;

        private String tableType;

        private Map<String, String> parameters = DefaultSdkAutoConstructMap.getInstance();

        private String createdBy;

        private Boolean isRegisteredWithLakeFormation;

        private TableIdentifier targetTable;

        private String catalogId;

        private BuilderImpl() {
        }

        private BuilderImpl(Table model) {
            name(model.name);
            databaseName(model.databaseName);
            description(model.description);
            owner(model.owner);
            createTime(model.createTime);
            updateTime(model.updateTime);
            lastAccessTime(model.lastAccessTime);
            lastAnalyzedTime(model.lastAnalyzedTime);
            retention(model.retention);
            storageDescriptor(model.storageDescriptor);
            partitionKeys(model.partitionKeys);
            viewOriginalText(model.viewOriginalText);
            viewExpandedText(model.viewExpandedText);
            tableType(model.tableType);
            parameters(model.parameters);
            createdBy(model.createdBy);
            isRegisteredWithLakeFormation(model.isRegisteredWithLakeFormation);
            targetTable(model.targetTable);
            catalogId(model.catalogId);
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDatabaseName() {
            return databaseName;
        }

        @Override
        public final Builder databaseName(String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        public final void setDatabaseName(String databaseName) {
            this.databaseName = databaseName;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getOwner() {
            return owner;
        }

        @Override
        public final Builder owner(String owner) {
            this.owner = owner;
            return this;
        }

        public final void setOwner(String owner) {
            this.owner = owner;
        }

        public final Instant getCreateTime() {
            return createTime;
        }

        @Override
        public final Builder createTime(Instant createTime) {
            this.createTime = createTime;
            return this;
        }

        public final void setCreateTime(Instant createTime) {
            this.createTime = createTime;
        }

        public final Instant getUpdateTime() {
            return updateTime;
        }

        @Override
        public final Builder updateTime(Instant updateTime) {
            this.updateTime = updateTime;
            return this;
        }

        public final void setUpdateTime(Instant updateTime) {
            this.updateTime = updateTime;
        }

        public final Instant getLastAccessTime() {
            return lastAccessTime;
        }

        @Override
        public final Builder lastAccessTime(Instant lastAccessTime) {
            this.lastAccessTime = lastAccessTime;
            return this;
        }

        public final void setLastAccessTime(Instant lastAccessTime) {
            this.lastAccessTime = lastAccessTime;
        }

        public final Instant getLastAnalyzedTime() {
            return lastAnalyzedTime;
        }

        @Override
        public final Builder lastAnalyzedTime(Instant lastAnalyzedTime) {
            this.lastAnalyzedTime = lastAnalyzedTime;
            return this;
        }

        public final void setLastAnalyzedTime(Instant lastAnalyzedTime) {
            this.lastAnalyzedTime = lastAnalyzedTime;
        }

        public final Integer getRetention() {
            return retention;
        }

        @Override
        public final Builder retention(Integer retention) {
            this.retention = retention;
            return this;
        }

        public final void setRetention(Integer retention) {
            this.retention = retention;
        }

        public final StorageDescriptor.Builder getStorageDescriptor() {
            return storageDescriptor != null ? storageDescriptor.toBuilder() : null;
        }

        @Override
        public final Builder storageDescriptor(StorageDescriptor storageDescriptor) {
            this.storageDescriptor = storageDescriptor;
            return this;
        }

        public final void setStorageDescriptor(StorageDescriptor.BuilderImpl storageDescriptor) {
            this.storageDescriptor = storageDescriptor != null ? storageDescriptor.build() : null;
        }

        public final Collection<Column.Builder> getPartitionKeys() {
            return partitionKeys != null ? partitionKeys.stream().map(Column::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder partitionKeys(Collection<Column> partitionKeys) {
            this.partitionKeys = ColumnListCopier.copy(partitionKeys);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder partitionKeys(Column... partitionKeys) {
            partitionKeys(Arrays.asList(partitionKeys));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder partitionKeys(Consumer<Column.Builder>... partitionKeys) {
            partitionKeys(Stream.of(partitionKeys).map(c -> Column.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setPartitionKeys(Collection<Column.BuilderImpl> partitionKeys) {
            this.partitionKeys = ColumnListCopier.copyFromBuilder(partitionKeys);
        }

        public final String getViewOriginalText() {
            return viewOriginalText;
        }

        @Override
        public final Builder viewOriginalText(String viewOriginalText) {
            this.viewOriginalText = viewOriginalText;
            return this;
        }

        public final void setViewOriginalText(String viewOriginalText) {
            this.viewOriginalText = viewOriginalText;
        }

        public final String getViewExpandedText() {
            return viewExpandedText;
        }

        @Override
        public final Builder viewExpandedText(String viewExpandedText) {
            this.viewExpandedText = viewExpandedText;
            return this;
        }

        public final void setViewExpandedText(String viewExpandedText) {
            this.viewExpandedText = viewExpandedText;
        }

        public final String getTableType() {
            return tableType;
        }

        @Override
        public final Builder tableType(String tableType) {
            this.tableType = tableType;
            return this;
        }

        public final void setTableType(String tableType) {
            this.tableType = tableType;
        }

        public final Map<String, String> getParameters() {
            return parameters;
        }

        @Override
        public final Builder parameters(Map<String, String> parameters) {
            this.parameters = ParametersMapCopier.copy(parameters);
            return this;
        }

        public final void setParameters(Map<String, String> parameters) {
            this.parameters = ParametersMapCopier.copy(parameters);
        }

        public final String getCreatedBy() {
            return createdBy;
        }

        @Override
        public final Builder createdBy(String createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public final void setCreatedBy(String createdBy) {
            this.createdBy = createdBy;
        }

        public final Boolean getIsRegisteredWithLakeFormation() {
            return isRegisteredWithLakeFormation;
        }

        @Override
        public final Builder isRegisteredWithLakeFormation(Boolean isRegisteredWithLakeFormation) {
            this.isRegisteredWithLakeFormation = isRegisteredWithLakeFormation;
            return this;
        }

        public final void setIsRegisteredWithLakeFormation(Boolean isRegisteredWithLakeFormation) {
            this.isRegisteredWithLakeFormation = isRegisteredWithLakeFormation;
        }

        public final TableIdentifier.Builder getTargetTable() {
            return targetTable != null ? targetTable.toBuilder() : null;
        }

        @Override
        public final Builder targetTable(TableIdentifier targetTable) {
            this.targetTable = targetTable;
            return this;
        }

        public final void setTargetTable(TableIdentifier.BuilderImpl targetTable) {
            this.targetTable = targetTable != null ? targetTable.build() : null;
        }

        public final String getCatalogId() {
            return catalogId;
        }

        @Override
        public final Builder catalogId(String catalogId) {
            this.catalogId = catalogId;
            return this;
        }

        public final void setCatalogId(String catalogId) {
            this.catalogId = catalogId;
        }

        @Override
        public Table build() {
            return new Table(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
