/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class SearchTablesResponse extends GlueResponse implements
        ToCopyableBuilder<SearchTablesResponse.Builder, SearchTablesResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(SearchTablesResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<List<Table>> TABLE_LIST_FIELD = SdkField
            .<List<Table>> builder(MarshallingType.LIST)
            .getter(getter(SearchTablesResponse::tableList))
            .setter(setter(Builder::tableList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TableList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Table> builder(MarshallingType.SDK_POJO)
                                            .constructor(Table::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            TABLE_LIST_FIELD));

    private final String nextToken;

    private final List<Table> tableList;

    private SearchTablesResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.tableList = builder.tableList;
    }

    /**
     * <p>
     * A continuation token, present if the current list segment is not the last.
     * </p>
     * 
     * @return A continuation token, present if the current list segment is not the last.
     */
    public String nextToken() {
        return nextToken;
    }

    /**
     * Returns true if the TableList property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasTableList() {
        return tableList != null && !(tableList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of the requested <code>Table</code> objects. The <code>SearchTables</code> response returns only the
     * tables that you have access to.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTableList()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of the requested <code>Table</code> objects. The <code>SearchTables</code> response returns only
     *         the tables that you have access to.
     */
    public List<Table> tableList() {
        return tableList;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(tableList());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchTablesResponse)) {
            return false;
        }
        SearchTablesResponse other = (SearchTablesResponse) obj;
        return Objects.equals(nextToken(), other.nextToken()) && Objects.equals(tableList(), other.tableList());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("SearchTablesResponse").add("NextToken", nextToken()).add("TableList", tableList()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "TableList":
            return Optional.ofNullable(clazz.cast(tableList()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SearchTablesResponse, T> g) {
        return obj -> g.apply((SearchTablesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GlueResponse.Builder, SdkPojo, CopyableBuilder<Builder, SearchTablesResponse> {
        /**
         * <p>
         * A continuation token, present if the current list segment is not the last.
         * </p>
         * 
         * @param nextToken
         *        A continuation token, present if the current list segment is not the last.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * A list of the requested <code>Table</code> objects. The <code>SearchTables</code> response returns only the
         * tables that you have access to.
         * </p>
         * 
         * @param tableList
         *        A list of the requested <code>Table</code> objects. The <code>SearchTables</code> response returns
         *        only the tables that you have access to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tableList(Collection<Table> tableList);

        /**
         * <p>
         * A list of the requested <code>Table</code> objects. The <code>SearchTables</code> response returns only the
         * tables that you have access to.
         * </p>
         * 
         * @param tableList
         *        A list of the requested <code>Table</code> objects. The <code>SearchTables</code> response returns
         *        only the tables that you have access to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tableList(Table... tableList);

        /**
         * <p>
         * A list of the requested <code>Table</code> objects. The <code>SearchTables</code> response returns only the
         * tables that you have access to.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Table>
         * .Builder} avoiding the need to create one manually via {@link List<Table>
         * #builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Table>
         * .Builder#build()} is called immediately and its result is passed to {@link #tableList(List
         * <Table>
         * )}.
         * 
         * @param tableList
         *        a consumer that will call methods on {@link List<Table>
         *        .Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tableList(List
         *      <Table>
         *      )
         */
        Builder tableList(Consumer<Table.Builder>... tableList);
    }

    static final class BuilderImpl extends GlueResponse.BuilderImpl implements Builder {
        private String nextToken;

        private List<Table> tableList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SearchTablesResponse model) {
            super(model);
            nextToken(model.nextToken);
            tableList(model.tableList);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Collection<Table.Builder> getTableList() {
            return tableList != null ? tableList.stream().map(Table::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tableList(Collection<Table> tableList) {
            this.tableList = TableListCopier.copy(tableList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tableList(Table... tableList) {
            tableList(Arrays.asList(tableList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tableList(Consumer<Table.Builder>... tableList) {
            tableList(Stream.of(tableList).map(c -> Table.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTableList(Collection<Table.BuilderImpl> tableList) {
            this.tableList = TableListCopier.copyFromBuilder(tableList);
        }

        @Override
        public SearchTablesResponse build() {
            return new SearchTablesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
