/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class SearchTablesRequest extends GlueRequest implements
        ToCopyableBuilder<SearchTablesRequest.Builder, SearchTablesRequest> {
    private static final SdkField<String> CATALOG_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(SearchTablesRequest::catalogId)).setter(setter(Builder::catalogId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CatalogId").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(SearchTablesRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<List<PropertyPredicate>> FILTERS_FIELD = SdkField
            .<List<PropertyPredicate>> builder(MarshallingType.LIST)
            .getter(getter(SearchTablesRequest::filters))
            .setter(setter(Builder::filters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<PropertyPredicate> builder(MarshallingType.SDK_POJO)
                                            .constructor(PropertyPredicate::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> SEARCH_TEXT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(SearchTablesRequest::searchText)).setter(setter(Builder::searchText))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SearchText").build()).build();

    private static final SdkField<List<SortCriterion>> SORT_CRITERIA_FIELD = SdkField
            .<List<SortCriterion>> builder(MarshallingType.LIST)
            .getter(getter(SearchTablesRequest::sortCriteria))
            .setter(setter(Builder::sortCriteria))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SortCriteria").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SortCriterion> builder(MarshallingType.SDK_POJO)
                                            .constructor(SortCriterion::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(SearchTablesRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final SdkField<String> RESOURCE_SHARE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(SearchTablesRequest::resourceShareTypeAsString)).setter(setter(Builder::resourceShareType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceShareType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(CATALOG_ID_FIELD, NEXT_TOKEN_FIELD, FILTERS_FIELD, SEARCH_TEXT_FIELD, SORT_CRITERIA_FIELD, MAX_RESULTS_FIELD,
                    RESOURCE_SHARE_TYPE_FIELD));

    private final String catalogId;

    private final String nextToken;

    private final List<PropertyPredicate> filters;

    private final String searchText;

    private final List<SortCriterion> sortCriteria;

    private final Integer maxResults;

    private final String resourceShareType;

    private SearchTablesRequest(BuilderImpl builder) {
        super(builder);
        this.catalogId = builder.catalogId;
        this.nextToken = builder.nextToken;
        this.filters = builder.filters;
        this.searchText = builder.searchText;
        this.sortCriteria = builder.sortCriteria;
        this.maxResults = builder.maxResults;
        this.resourceShareType = builder.resourceShareType;
    }

    /**
     * <p>
     * A unique identifier, consisting of <code> <i>account_id</i> </code>.
     * </p>
     * 
     * @return A unique identifier, consisting of <code> <i>account_id</i> </code>.
     */
    public String catalogId() {
        return catalogId;
    }

    /**
     * <p>
     * A continuation token, included if this is a continuation call.
     * </p>
     * 
     * @return A continuation token, included if this is a continuation call.
     */
    public String nextToken() {
        return nextToken;
    }

    /**
     * Returns true if the Filters property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasFilters() {
        return filters != null && !(filters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of key-value pairs, and a comparator used to filter the search results. Returns all entities matching the
     * predicate.
     * </p>
     * <p>
     * The <code>Comparator</code> member of the <code>PropertyPredicate</code> struct is used only for time fields, and
     * can be omitted for other field types. Also, when comparing string values, such as when <code>Key=Name</code>, a
     * fuzzy match algorithm is used. The <code>Key</code> field (for example, the value of the <code>Name</code> field)
     * is split on certain punctuation characters, for example, -, :, #, etc. into tokens. Then each token is
     * exact-match compared with the <code>Value</code> member of <code>PropertyPredicate</code>. For example, if
     * <code>Key=Name</code> and <code>Value=link</code>, tables named <code>customer-link</code> and
     * <code>xx-link-yy</code> are returned, but <code>xxlinkyy</code> is not returned.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasFilters()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of key-value pairs, and a comparator used to filter the search results. Returns all entities
     *         matching the predicate.</p>
     *         <p>
     *         The <code>Comparator</code> member of the <code>PropertyPredicate</code> struct is used only for time
     *         fields, and can be omitted for other field types. Also, when comparing string values, such as when
     *         <code>Key=Name</code>, a fuzzy match algorithm is used. The <code>Key</code> field (for example, the
     *         value of the <code>Name</code> field) is split on certain punctuation characters, for example, -, :, #,
     *         etc. into tokens. Then each token is exact-match compared with the <code>Value</code> member of
     *         <code>PropertyPredicate</code>. For example, if <code>Key=Name</code> and <code>Value=link</code>, tables
     *         named <code>customer-link</code> and <code>xx-link-yy</code> are returned, but <code>xxlinkyy</code> is
     *         not returned.
     */
    public List<PropertyPredicate> filters() {
        return filters;
    }

    /**
     * <p>
     * A string used for a text search.
     * </p>
     * <p>
     * Specifying a value in quotes filters based on an exact match to the value.
     * </p>
     * 
     * @return A string used for a text search.</p>
     *         <p>
     *         Specifying a value in quotes filters based on an exact match to the value.
     */
    public String searchText() {
        return searchText;
    }

    /**
     * Returns true if the SortCriteria property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasSortCriteria() {
        return sortCriteria != null && !(sortCriteria instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of criteria for sorting the results by a field name, in an ascending or descending order.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasSortCriteria()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of criteria for sorting the results by a field name, in an ascending or descending order.
     */
    public List<SortCriterion> sortCriteria() {
        return sortCriteria;
    }

    /**
     * <p>
     * The maximum number of tables to return in a single response.
     * </p>
     * 
     * @return The maximum number of tables to return in a single response.
     */
    public Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * Allows you to specify that you want to search the tables shared with your account. The allowable values are
     * <code>FOREIGN</code> or <code>ALL</code>.
     * </p>
     * <ul>
     * <li>
     * <p>
     * If set to <code>FOREIGN</code>, will search the tables shared with your account.
     * </p>
     * </li>
     * <li>
     * <p>
     * If set to <code>ALL</code>, will search the tables shared with your account, as well as the tables in yor local
     * account.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resourceShareType}
     * will return {@link ResourceShareType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #resourceShareTypeAsString}.
     * </p>
     * 
     * @return Allows you to specify that you want to search the tables shared with your account. The allowable values
     *         are <code>FOREIGN</code> or <code>ALL</code>. </p>
     *         <ul>
     *         <li>
     *         <p>
     *         If set to <code>FOREIGN</code>, will search the tables shared with your account.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         If set to <code>ALL</code>, will search the tables shared with your account, as well as the tables in yor
     *         local account.
     *         </p>
     *         </li>
     * @see ResourceShareType
     */
    public ResourceShareType resourceShareType() {
        return ResourceShareType.fromValue(resourceShareType);
    }

    /**
     * <p>
     * Allows you to specify that you want to search the tables shared with your account. The allowable values are
     * <code>FOREIGN</code> or <code>ALL</code>.
     * </p>
     * <ul>
     * <li>
     * <p>
     * If set to <code>FOREIGN</code>, will search the tables shared with your account.
     * </p>
     * </li>
     * <li>
     * <p>
     * If set to <code>ALL</code>, will search the tables shared with your account, as well as the tables in yor local
     * account.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resourceShareType}
     * will return {@link ResourceShareType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #resourceShareTypeAsString}.
     * </p>
     * 
     * @return Allows you to specify that you want to search the tables shared with your account. The allowable values
     *         are <code>FOREIGN</code> or <code>ALL</code>. </p>
     *         <ul>
     *         <li>
     *         <p>
     *         If set to <code>FOREIGN</code>, will search the tables shared with your account.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         If set to <code>ALL</code>, will search the tables shared with your account, as well as the tables in yor
     *         local account.
     *         </p>
     *         </li>
     * @see ResourceShareType
     */
    public String resourceShareTypeAsString() {
        return resourceShareType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(catalogId());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(filters());
        hashCode = 31 * hashCode + Objects.hashCode(searchText());
        hashCode = 31 * hashCode + Objects.hashCode(sortCriteria());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(resourceShareTypeAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchTablesRequest)) {
            return false;
        }
        SearchTablesRequest other = (SearchTablesRequest) obj;
        return Objects.equals(catalogId(), other.catalogId()) && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(filters(), other.filters()) && Objects.equals(searchText(), other.searchText())
                && Objects.equals(sortCriteria(), other.sortCriteria()) && Objects.equals(maxResults(), other.maxResults())
                && Objects.equals(resourceShareTypeAsString(), other.resourceShareTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("SearchTablesRequest").add("CatalogId", catalogId()).add("NextToken", nextToken())
                .add("Filters", filters()).add("SearchText", searchText()).add("SortCriteria", sortCriteria())
                .add("MaxResults", maxResults()).add("ResourceShareType", resourceShareTypeAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CatalogId":
            return Optional.ofNullable(clazz.cast(catalogId()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "Filters":
            return Optional.ofNullable(clazz.cast(filters()));
        case "SearchText":
            return Optional.ofNullable(clazz.cast(searchText()));
        case "SortCriteria":
            return Optional.ofNullable(clazz.cast(sortCriteria()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "ResourceShareType":
            return Optional.ofNullable(clazz.cast(resourceShareTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SearchTablesRequest, T> g) {
        return obj -> g.apply((SearchTablesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GlueRequest.Builder, SdkPojo, CopyableBuilder<Builder, SearchTablesRequest> {
        /**
         * <p>
         * A unique identifier, consisting of <code> <i>account_id</i> </code>.
         * </p>
         * 
         * @param catalogId
         *        A unique identifier, consisting of <code> <i>account_id</i> </code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder catalogId(String catalogId);

        /**
         * <p>
         * A continuation token, included if this is a continuation call.
         * </p>
         * 
         * @param nextToken
         *        A continuation token, included if this is a continuation call.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * A list of key-value pairs, and a comparator used to filter the search results. Returns all entities matching
         * the predicate.
         * </p>
         * <p>
         * The <code>Comparator</code> member of the <code>PropertyPredicate</code> struct is used only for time fields,
         * and can be omitted for other field types. Also, when comparing string values, such as when
         * <code>Key=Name</code>, a fuzzy match algorithm is used. The <code>Key</code> field (for example, the value of
         * the <code>Name</code> field) is split on certain punctuation characters, for example, -, :, #, etc. into
         * tokens. Then each token is exact-match compared with the <code>Value</code> member of
         * <code>PropertyPredicate</code>. For example, if <code>Key=Name</code> and <code>Value=link</code>, tables
         * named <code>customer-link</code> and <code>xx-link-yy</code> are returned, but <code>xxlinkyy</code> is not
         * returned.
         * </p>
         * 
         * @param filters
         *        A list of key-value pairs, and a comparator used to filter the search results. Returns all entities
         *        matching the predicate.</p>
         *        <p>
         *        The <code>Comparator</code> member of the <code>PropertyPredicate</code> struct is used only for time
         *        fields, and can be omitted for other field types. Also, when comparing string values, such as when
         *        <code>Key=Name</code>, a fuzzy match algorithm is used. The <code>Key</code> field (for example, the
         *        value of the <code>Name</code> field) is split on certain punctuation characters, for example, -, :,
         *        #, etc. into tokens. Then each token is exact-match compared with the <code>Value</code> member of
         *        <code>PropertyPredicate</code>. For example, if <code>Key=Name</code> and <code>Value=link</code>,
         *        tables named <code>customer-link</code> and <code>xx-link-yy</code> are returned, but
         *        <code>xxlinkyy</code> is not returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Collection<PropertyPredicate> filters);

        /**
         * <p>
         * A list of key-value pairs, and a comparator used to filter the search results. Returns all entities matching
         * the predicate.
         * </p>
         * <p>
         * The <code>Comparator</code> member of the <code>PropertyPredicate</code> struct is used only for time fields,
         * and can be omitted for other field types. Also, when comparing string values, such as when
         * <code>Key=Name</code>, a fuzzy match algorithm is used. The <code>Key</code> field (for example, the value of
         * the <code>Name</code> field) is split on certain punctuation characters, for example, -, :, #, etc. into
         * tokens. Then each token is exact-match compared with the <code>Value</code> member of
         * <code>PropertyPredicate</code>. For example, if <code>Key=Name</code> and <code>Value=link</code>, tables
         * named <code>customer-link</code> and <code>xx-link-yy</code> are returned, but <code>xxlinkyy</code> is not
         * returned.
         * </p>
         * 
         * @param filters
         *        A list of key-value pairs, and a comparator used to filter the search results. Returns all entities
         *        matching the predicate.</p>
         *        <p>
         *        The <code>Comparator</code> member of the <code>PropertyPredicate</code> struct is used only for time
         *        fields, and can be omitted for other field types. Also, when comparing string values, such as when
         *        <code>Key=Name</code>, a fuzzy match algorithm is used. The <code>Key</code> field (for example, the
         *        value of the <code>Name</code> field) is split on certain punctuation characters, for example, -, :,
         *        #, etc. into tokens. Then each token is exact-match compared with the <code>Value</code> member of
         *        <code>PropertyPredicate</code>. For example, if <code>Key=Name</code> and <code>Value=link</code>,
         *        tables named <code>customer-link</code> and <code>xx-link-yy</code> are returned, but
         *        <code>xxlinkyy</code> is not returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(PropertyPredicate... filters);

        /**
         * <p>
         * A list of key-value pairs, and a comparator used to filter the search results. Returns all entities matching
         * the predicate.
         * </p>
         * <p>
         * The <code>Comparator</code> member of the <code>PropertyPredicate</code> struct is used only for time fields,
         * and can be omitted for other field types. Also, when comparing string values, such as when
         * <code>Key=Name</code>, a fuzzy match algorithm is used. The <code>Key</code> field (for example, the value of
         * the <code>Name</code> field) is split on certain punctuation characters, for example, -, :, #, etc. into
         * tokens. Then each token is exact-match compared with the <code>Value</code> member of
         * <code>PropertyPredicate</code>. For example, if <code>Key=Name</code> and <code>Value=link</code>, tables
         * named <code>customer-link</code> and <code>xx-link-yy</code> are returned, but <code>xxlinkyy</code> is not
         * returned.
         * </p>
         * This is a convenience that creates an instance of the {@link List<PropertyPredicate>.Builder} avoiding the
         * need to create one manually via {@link List<PropertyPredicate>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<PropertyPredicate>.Builder#build()} is called immediately
         * and its result is passed to {@link #filters(List<PropertyPredicate>)}.
         * 
         * @param filters
         *        a consumer that will call methods on {@link List<PropertyPredicate>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filters(List<PropertyPredicate>)
         */
        Builder filters(Consumer<PropertyPredicate.Builder>... filters);

        /**
         * <p>
         * A string used for a text search.
         * </p>
         * <p>
         * Specifying a value in quotes filters based on an exact match to the value.
         * </p>
         * 
         * @param searchText
         *        A string used for a text search.</p>
         *        <p>
         *        Specifying a value in quotes filters based on an exact match to the value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder searchText(String searchText);

        /**
         * <p>
         * A list of criteria for sorting the results by a field name, in an ascending or descending order.
         * </p>
         * 
         * @param sortCriteria
         *        A list of criteria for sorting the results by a field name, in an ascending or descending order.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sortCriteria(Collection<SortCriterion> sortCriteria);

        /**
         * <p>
         * A list of criteria for sorting the results by a field name, in an ascending or descending order.
         * </p>
         * 
         * @param sortCriteria
         *        A list of criteria for sorting the results by a field name, in an ascending or descending order.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sortCriteria(SortCriterion... sortCriteria);

        /**
         * <p>
         * A list of criteria for sorting the results by a field name, in an ascending or descending order.
         * </p>
         * This is a convenience that creates an instance of the {@link List<SortCriterion>.Builder} avoiding the need
         * to create one manually via {@link List<SortCriterion>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<SortCriterion>.Builder#build()} is called immediately and
         * its result is passed to {@link #sortCriteria(List<SortCriterion>)}.
         * 
         * @param sortCriteria
         *        a consumer that will call methods on {@link List<SortCriterion>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sortCriteria(List<SortCriterion>)
         */
        Builder sortCriteria(Consumer<SortCriterion.Builder>... sortCriteria);

        /**
         * <p>
         * The maximum number of tables to return in a single response.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of tables to return in a single response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * Allows you to specify that you want to search the tables shared with your account. The allowable values are
         * <code>FOREIGN</code> or <code>ALL</code>.
         * </p>
         * <ul>
         * <li>
         * <p>
         * If set to <code>FOREIGN</code>, will search the tables shared with your account.
         * </p>
         * </li>
         * <li>
         * <p>
         * If set to <code>ALL</code>, will search the tables shared with your account, as well as the tables in yor
         * local account.
         * </p>
         * </li>
         * </ul>
         * 
         * @param resourceShareType
         *        Allows you to specify that you want to search the tables shared with your account. The allowable
         *        values are <code>FOREIGN</code> or <code>ALL</code>. </p>
         *        <ul>
         *        <li>
         *        <p>
         *        If set to <code>FOREIGN</code>, will search the tables shared with your account.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If set to <code>ALL</code>, will search the tables shared with your account, as well as the tables in
         *        yor local account.
         *        </p>
         *        </li>
         * @see ResourceShareType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceShareType
         */
        Builder resourceShareType(String resourceShareType);

        /**
         * <p>
         * Allows you to specify that you want to search the tables shared with your account. The allowable values are
         * <code>FOREIGN</code> or <code>ALL</code>.
         * </p>
         * <ul>
         * <li>
         * <p>
         * If set to <code>FOREIGN</code>, will search the tables shared with your account.
         * </p>
         * </li>
         * <li>
         * <p>
         * If set to <code>ALL</code>, will search the tables shared with your account, as well as the tables in yor
         * local account.
         * </p>
         * </li>
         * </ul>
         * 
         * @param resourceShareType
         *        Allows you to specify that you want to search the tables shared with your account. The allowable
         *        values are <code>FOREIGN</code> or <code>ALL</code>. </p>
         *        <ul>
         *        <li>
         *        <p>
         *        If set to <code>FOREIGN</code>, will search the tables shared with your account.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If set to <code>ALL</code>, will search the tables shared with your account, as well as the tables in
         *        yor local account.
         *        </p>
         *        </li>
         * @see ResourceShareType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceShareType
         */
        Builder resourceShareType(ResourceShareType resourceShareType);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends GlueRequest.BuilderImpl implements Builder {
        private String catalogId;

        private String nextToken;

        private List<PropertyPredicate> filters = DefaultSdkAutoConstructList.getInstance();

        private String searchText;

        private List<SortCriterion> sortCriteria = DefaultSdkAutoConstructList.getInstance();

        private Integer maxResults;

        private String resourceShareType;

        private BuilderImpl() {
        }

        private BuilderImpl(SearchTablesRequest model) {
            super(model);
            catalogId(model.catalogId);
            nextToken(model.nextToken);
            filters(model.filters);
            searchText(model.searchText);
            sortCriteria(model.sortCriteria);
            maxResults(model.maxResults);
            resourceShareType(model.resourceShareType);
        }

        public final String getCatalogId() {
            return catalogId;
        }

        @Override
        public final Builder catalogId(String catalogId) {
            this.catalogId = catalogId;
            return this;
        }

        public final void setCatalogId(String catalogId) {
            this.catalogId = catalogId;
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Collection<PropertyPredicate.Builder> getFilters() {
            return filters != null ? filters.stream().map(PropertyPredicate::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder filters(Collection<PropertyPredicate> filters) {
            this.filters = SearchPropertyPredicatesCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(PropertyPredicate... filters) {
            filters(Arrays.asList(filters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Consumer<PropertyPredicate.Builder>... filters) {
            filters(Stream.of(filters).map(c -> PropertyPredicate.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setFilters(Collection<PropertyPredicate.BuilderImpl> filters) {
            this.filters = SearchPropertyPredicatesCopier.copyFromBuilder(filters);
        }

        public final String getSearchText() {
            return searchText;
        }

        @Override
        public final Builder searchText(String searchText) {
            this.searchText = searchText;
            return this;
        }

        public final void setSearchText(String searchText) {
            this.searchText = searchText;
        }

        public final Collection<SortCriterion.Builder> getSortCriteria() {
            return sortCriteria != null ? sortCriteria.stream().map(SortCriterion::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder sortCriteria(Collection<SortCriterion> sortCriteria) {
            this.sortCriteria = SortCriteriaCopier.copy(sortCriteria);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sortCriteria(SortCriterion... sortCriteria) {
            sortCriteria(Arrays.asList(sortCriteria));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sortCriteria(Consumer<SortCriterion.Builder>... sortCriteria) {
            sortCriteria(Stream.of(sortCriteria).map(c -> SortCriterion.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setSortCriteria(Collection<SortCriterion.BuilderImpl> sortCriteria) {
            this.sortCriteria = SortCriteriaCopier.copyFromBuilder(sortCriteria);
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final String getResourceShareType() {
            return resourceShareType;
        }

        @Override
        public final Builder resourceShareType(String resourceShareType) {
            this.resourceShareType = resourceShareType;
            return this;
        }

        @Override
        public final Builder resourceShareType(ResourceShareType resourceShareType) {
            this.resourceShareType(resourceShareType == null ? null : resourceShareType.toString());
            return this;
        }

        public final void setResourceShareType(String resourceShareType) {
            this.resourceShareType = resourceShareType;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public SearchTablesRequest build() {
            return new SearchTablesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
