/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListDevEndpointsResponse extends GlueResponse implements
        ToCopyableBuilder<ListDevEndpointsResponse.Builder, ListDevEndpointsResponse> {
    private static final SdkField<List<String>> DEV_ENDPOINT_NAMES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(ListDevEndpointsResponse::devEndpointNames))
            .setter(setter(Builder::devEndpointNames))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DevEndpointNames").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListDevEndpointsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEV_ENDPOINT_NAMES_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<String> devEndpointNames;

    private final String nextToken;

    private ListDevEndpointsResponse(BuilderImpl builder) {
        super(builder);
        this.devEndpointNames = builder.devEndpointNames;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the DevEndpointNames property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasDevEndpointNames() {
        return devEndpointNames != null && !(devEndpointNames instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The names of all the <code>DevEndpoint</code>s in the account, or the <code>DevEndpoint</code>s with the
     * specified tags.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasDevEndpointNames()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The names of all the <code>DevEndpoint</code>s in the account, or the <code>DevEndpoint</code>s with the
     *         specified tags.
     */
    public List<String> devEndpointNames() {
        return devEndpointNames;
    }

    /**
     * <p>
     * A continuation token, if the returned list does not contain the last metric available.
     * </p>
     * 
     * @return A continuation token, if the returned list does not contain the last metric available.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(devEndpointNames());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDevEndpointsResponse)) {
            return false;
        }
        ListDevEndpointsResponse other = (ListDevEndpointsResponse) obj;
        return Objects.equals(devEndpointNames(), other.devEndpointNames()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListDevEndpointsResponse").add("DevEndpointNames", devEndpointNames())
                .add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DevEndpointNames":
            return Optional.ofNullable(clazz.cast(devEndpointNames()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListDevEndpointsResponse, T> g) {
        return obj -> g.apply((ListDevEndpointsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GlueResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListDevEndpointsResponse> {
        /**
         * <p>
         * The names of all the <code>DevEndpoint</code>s in the account, or the <code>DevEndpoint</code>s with the
         * specified tags.
         * </p>
         * 
         * @param devEndpointNames
         *        The names of all the <code>DevEndpoint</code>s in the account, or the <code>DevEndpoint</code>s with
         *        the specified tags.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder devEndpointNames(Collection<String> devEndpointNames);

        /**
         * <p>
         * The names of all the <code>DevEndpoint</code>s in the account, or the <code>DevEndpoint</code>s with the
         * specified tags.
         * </p>
         * 
         * @param devEndpointNames
         *        The names of all the <code>DevEndpoint</code>s in the account, or the <code>DevEndpoint</code>s with
         *        the specified tags.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder devEndpointNames(String... devEndpointNames);

        /**
         * <p>
         * A continuation token, if the returned list does not contain the last metric available.
         * </p>
         * 
         * @param nextToken
         *        A continuation token, if the returned list does not contain the last metric available.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends GlueResponse.BuilderImpl implements Builder {
        private List<String> devEndpointNames = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListDevEndpointsResponse model) {
            super(model);
            devEndpointNames(model.devEndpointNames);
            nextToken(model.nextToken);
        }

        public final Collection<String> getDevEndpointNames() {
            return devEndpointNames;
        }

        @Override
        public final Builder devEndpointNames(Collection<String> devEndpointNames) {
            this.devEndpointNames = DevEndpointNameListCopier.copy(devEndpointNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder devEndpointNames(String... devEndpointNames) {
            devEndpointNames(Arrays.asList(devEndpointNames));
            return this;
        }

        public final void setDevEndpointNames(Collection<String> devEndpointNames) {
            this.devEndpointNames = DevEndpointNameListCopier.copy(devEndpointNames);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListDevEndpointsResponse build() {
            return new ListDevEndpointsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
