/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The database and table in the AWS Glue Data Catalog that is used for input or output data.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GlueTable implements SdkPojo, Serializable, ToCopyableBuilder<GlueTable.Builder, GlueTable> {
    private static final SdkField<String> DATABASE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GlueTable::databaseName)).setter(setter(Builder::databaseName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatabaseName").build()).build();

    private static final SdkField<String> TABLE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GlueTable::tableName)).setter(setter(Builder::tableName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TableName").build()).build();

    private static final SdkField<String> CATALOG_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GlueTable::catalogId)).setter(setter(Builder::catalogId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CatalogId").build()).build();

    private static final SdkField<String> CONNECTION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GlueTable::connectionName)).setter(setter(Builder::connectionName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATABASE_NAME_FIELD,
            TABLE_NAME_FIELD, CATALOG_ID_FIELD, CONNECTION_NAME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String databaseName;

    private final String tableName;

    private final String catalogId;

    private final String connectionName;

    private GlueTable(BuilderImpl builder) {
        this.databaseName = builder.databaseName;
        this.tableName = builder.tableName;
        this.catalogId = builder.catalogId;
        this.connectionName = builder.connectionName;
    }

    /**
     * <p>
     * A database name in the AWS Glue Data Catalog.
     * </p>
     * 
     * @return A database name in the AWS Glue Data Catalog.
     */
    public String databaseName() {
        return databaseName;
    }

    /**
     * <p>
     * A table name in the AWS Glue Data Catalog.
     * </p>
     * 
     * @return A table name in the AWS Glue Data Catalog.
     */
    public String tableName() {
        return tableName;
    }

    /**
     * <p>
     * A unique identifier for the AWS Glue Data Catalog.
     * </p>
     * 
     * @return A unique identifier for the AWS Glue Data Catalog.
     */
    public String catalogId() {
        return catalogId;
    }

    /**
     * <p>
     * The name of the connection to the AWS Glue Data Catalog.
     * </p>
     * 
     * @return The name of the connection to the AWS Glue Data Catalog.
     */
    public String connectionName() {
        return connectionName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(databaseName());
        hashCode = 31 * hashCode + Objects.hashCode(tableName());
        hashCode = 31 * hashCode + Objects.hashCode(catalogId());
        hashCode = 31 * hashCode + Objects.hashCode(connectionName());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GlueTable)) {
            return false;
        }
        GlueTable other = (GlueTable) obj;
        return Objects.equals(databaseName(), other.databaseName()) && Objects.equals(tableName(), other.tableName())
                && Objects.equals(catalogId(), other.catalogId()) && Objects.equals(connectionName(), other.connectionName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GlueTable").add("DatabaseName", databaseName()).add("TableName", tableName())
                .add("CatalogId", catalogId()).add("ConnectionName", connectionName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DatabaseName":
            return Optional.ofNullable(clazz.cast(databaseName()));
        case "TableName":
            return Optional.ofNullable(clazz.cast(tableName()));
        case "CatalogId":
            return Optional.ofNullable(clazz.cast(catalogId()));
        case "ConnectionName":
            return Optional.ofNullable(clazz.cast(connectionName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GlueTable, T> g) {
        return obj -> g.apply((GlueTable) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, GlueTable> {
        /**
         * <p>
         * A database name in the AWS Glue Data Catalog.
         * </p>
         * 
         * @param databaseName
         *        A database name in the AWS Glue Data Catalog.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder databaseName(String databaseName);

        /**
         * <p>
         * A table name in the AWS Glue Data Catalog.
         * </p>
         * 
         * @param tableName
         *        A table name in the AWS Glue Data Catalog.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tableName(String tableName);

        /**
         * <p>
         * A unique identifier for the AWS Glue Data Catalog.
         * </p>
         * 
         * @param catalogId
         *        A unique identifier for the AWS Glue Data Catalog.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder catalogId(String catalogId);

        /**
         * <p>
         * The name of the connection to the AWS Glue Data Catalog.
         * </p>
         * 
         * @param connectionName
         *        The name of the connection to the AWS Glue Data Catalog.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectionName(String connectionName);
    }

    static final class BuilderImpl implements Builder {
        private String databaseName;

        private String tableName;

        private String catalogId;

        private String connectionName;

        private BuilderImpl() {
        }

        private BuilderImpl(GlueTable model) {
            databaseName(model.databaseName);
            tableName(model.tableName);
            catalogId(model.catalogId);
            connectionName(model.connectionName);
        }

        public final String getDatabaseName() {
            return databaseName;
        }

        @Override
        public final Builder databaseName(String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        public final void setDatabaseName(String databaseName) {
            this.databaseName = databaseName;
        }

        public final String getTableName() {
            return tableName;
        }

        @Override
        public final Builder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public final void setTableName(String tableName) {
            this.tableName = tableName;
        }

        public final String getCatalogId() {
            return catalogId;
        }

        @Override
        public final Builder catalogId(String catalogId) {
            this.catalogId = catalogId;
            return this;
        }

        public final void setCatalogId(String catalogId) {
            this.catalogId = catalogId;
        }

        public final String getConnectionName() {
            return connectionName;
        }

        @Override
        public final Builder connectionName(String connectionName) {
            this.connectionName = connectionName;
            return this;
        }

        public final void setConnectionName(String connectionName) {
            this.connectionName = connectionName;
        }

        @Override
        public GlueTable build() {
            return new GlueTable(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
