/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetMlTransformsResponse extends GlueResponse implements
        ToCopyableBuilder<GetMlTransformsResponse.Builder, GetMlTransformsResponse> {
    private static final SdkField<List<MLTransform>> TRANSFORMS_FIELD = SdkField
            .<List<MLTransform>> builder(MarshallingType.LIST)
            .getter(getter(GetMlTransformsResponse::transforms))
            .setter(setter(Builder::transforms))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Transforms").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<MLTransform> builder(MarshallingType.SDK_POJO)
                                            .constructor(MLTransform::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetMlTransformsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRANSFORMS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<MLTransform> transforms;

    private final String nextToken;

    private GetMlTransformsResponse(BuilderImpl builder) {
        super(builder);
        this.transforms = builder.transforms;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the Transforms property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasTransforms() {
        return transforms != null && !(transforms instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of machine learning transforms.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTransforms()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of machine learning transforms.
     */
    public List<MLTransform> transforms() {
        return transforms;
    }

    /**
     * <p>
     * A pagination token, if more results are available.
     * </p>
     * 
     * @return A pagination token, if more results are available.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(transforms());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetMlTransformsResponse)) {
            return false;
        }
        GetMlTransformsResponse other = (GetMlTransformsResponse) obj;
        return Objects.equals(transforms(), other.transforms()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GetMlTransformsResponse").add("Transforms", transforms()).add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Transforms":
            return Optional.ofNullable(clazz.cast(transforms()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetMlTransformsResponse, T> g) {
        return obj -> g.apply((GetMlTransformsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GlueResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetMlTransformsResponse> {
        /**
         * <p>
         * A list of machine learning transforms.
         * </p>
         * 
         * @param transforms
         *        A list of machine learning transforms.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transforms(Collection<MLTransform> transforms);

        /**
         * <p>
         * A list of machine learning transforms.
         * </p>
         * 
         * @param transforms
         *        A list of machine learning transforms.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transforms(MLTransform... transforms);

        /**
         * <p>
         * A list of machine learning transforms.
         * </p>
         * This is a convenience that creates an instance of the {@link List<MLTransform>.Builder} avoiding the need to
         * create one manually via {@link List<MLTransform>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<MLTransform>.Builder#build()} is called immediately and its
         * result is passed to {@link #transforms(List<MLTransform>)}.
         * 
         * @param transforms
         *        a consumer that will call methods on {@link List<MLTransform>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #transforms(List<MLTransform>)
         */
        Builder transforms(Consumer<MLTransform.Builder>... transforms);

        /**
         * <p>
         * A pagination token, if more results are available.
         * </p>
         * 
         * @param nextToken
         *        A pagination token, if more results are available.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends GlueResponse.BuilderImpl implements Builder {
        private List<MLTransform> transforms = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetMlTransformsResponse model) {
            super(model);
            transforms(model.transforms);
            nextToken(model.nextToken);
        }

        public final Collection<MLTransform.Builder> getTransforms() {
            return transforms != null ? transforms.stream().map(MLTransform::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder transforms(Collection<MLTransform> transforms) {
            this.transforms = TransformListCopier.copy(transforms);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder transforms(MLTransform... transforms) {
            transforms(Arrays.asList(transforms));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder transforms(Consumer<MLTransform.Builder>... transforms) {
            transforms(Stream.of(transforms).map(c -> MLTransform.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setTransforms(Collection<MLTransform.BuilderImpl> transforms) {
            this.transforms = TransformListCopier.copyFromBuilder(transforms);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public GetMlTransformsResponse build() {
            return new GetMlTransformsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
