/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetCatalogImportStatusResponse extends GlueResponse implements
        ToCopyableBuilder<GetCatalogImportStatusResponse.Builder, GetCatalogImportStatusResponse> {
    private static final SdkField<CatalogImportStatus> IMPORT_STATUS_FIELD = SdkField
            .<CatalogImportStatus> builder(MarshallingType.SDK_POJO).getter(getter(GetCatalogImportStatusResponse::importStatus))
            .setter(setter(Builder::importStatus)).constructor(CatalogImportStatus::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImportStatus").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IMPORT_STATUS_FIELD));

    private final CatalogImportStatus importStatus;

    private GetCatalogImportStatusResponse(BuilderImpl builder) {
        super(builder);
        this.importStatus = builder.importStatus;
    }

    /**
     * <p>
     * The status of the specified catalog migration.
     * </p>
     * 
     * @return The status of the specified catalog migration.
     */
    public CatalogImportStatus importStatus() {
        return importStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(importStatus());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetCatalogImportStatusResponse)) {
            return false;
        }
        GetCatalogImportStatusResponse other = (GetCatalogImportStatusResponse) obj;
        return Objects.equals(importStatus(), other.importStatus());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GetCatalogImportStatusResponse").add("ImportStatus", importStatus()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ImportStatus":
            return Optional.ofNullable(clazz.cast(importStatus()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetCatalogImportStatusResponse, T> g) {
        return obj -> g.apply((GetCatalogImportStatusResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GlueResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetCatalogImportStatusResponse> {
        /**
         * <p>
         * The status of the specified catalog migration.
         * </p>
         * 
         * @param importStatus
         *        The status of the specified catalog migration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder importStatus(CatalogImportStatus importStatus);

        /**
         * <p>
         * The status of the specified catalog migration.
         * </p>
         * This is a convenience that creates an instance of the {@link CatalogImportStatus.Builder} avoiding the need
         * to create one manually via {@link CatalogImportStatus#builder()}.
         *
         * When the {@link Consumer} completes, {@link CatalogImportStatus.Builder#build()} is called immediately and
         * its result is passed to {@link #importStatus(CatalogImportStatus)}.
         * 
         * @param importStatus
         *        a consumer that will call methods on {@link CatalogImportStatus.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #importStatus(CatalogImportStatus)
         */
        default Builder importStatus(Consumer<CatalogImportStatus.Builder> importStatus) {
            return importStatus(CatalogImportStatus.builder().applyMutation(importStatus).build());
        }
    }

    static final class BuilderImpl extends GlueResponse.BuilderImpl implements Builder {
        private CatalogImportStatus importStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(GetCatalogImportStatusResponse model) {
            super(model);
            importStatus(model.importStatus);
        }

        public final CatalogImportStatus.Builder getImportStatus() {
            return importStatus != null ? importStatus.toBuilder() : null;
        }

        @Override
        public final Builder importStatus(CatalogImportStatus importStatus) {
            this.importStatus = importStatus;
            return this;
        }

        public final void setImportStatus(CatalogImportStatus.BuilderImpl importStatus) {
            this.importStatus = importStatus != null ? importStatus.build() : null;
        }

        @Override
        public GetCatalogImportStatusResponse build() {
            return new GetCatalogImportStatusResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
