/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Defines a decimal column statistics data.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DecimalColumnStatisticsData implements SdkPojo, Serializable,
        ToCopyableBuilder<DecimalColumnStatisticsData.Builder, DecimalColumnStatisticsData> {
    private static final SdkField<DecimalNumber> MINIMUM_VALUE_FIELD = SdkField.<DecimalNumber> builder(MarshallingType.SDK_POJO)
            .getter(getter(DecimalColumnStatisticsData::minimumValue)).setter(setter(Builder::minimumValue))
            .constructor(DecimalNumber::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MinimumValue").build()).build();

    private static final SdkField<DecimalNumber> MAXIMUM_VALUE_FIELD = SdkField.<DecimalNumber> builder(MarshallingType.SDK_POJO)
            .getter(getter(DecimalColumnStatisticsData::maximumValue)).setter(setter(Builder::maximumValue))
            .constructor(DecimalNumber::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaximumValue").build()).build();

    private static final SdkField<Long> NUMBER_OF_NULLS_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .getter(getter(DecimalColumnStatisticsData::numberOfNulls)).setter(setter(Builder::numberOfNulls))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberOfNulls").build()).build();

    private static final SdkField<Long> NUMBER_OF_DISTINCT_VALUES_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .getter(getter(DecimalColumnStatisticsData::numberOfDistinctValues)).setter(setter(Builder::numberOfDistinctValues))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberOfDistinctValues").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MINIMUM_VALUE_FIELD,
            MAXIMUM_VALUE_FIELD, NUMBER_OF_NULLS_FIELD, NUMBER_OF_DISTINCT_VALUES_FIELD));

    private static final long serialVersionUID = 1L;

    private final DecimalNumber minimumValue;

    private final DecimalNumber maximumValue;

    private final Long numberOfNulls;

    private final Long numberOfDistinctValues;

    private DecimalColumnStatisticsData(BuilderImpl builder) {
        this.minimumValue = builder.minimumValue;
        this.maximumValue = builder.maximumValue;
        this.numberOfNulls = builder.numberOfNulls;
        this.numberOfDistinctValues = builder.numberOfDistinctValues;
    }

    /**
     * <p>
     * Minimum value of the column.
     * </p>
     * 
     * @return Minimum value of the column.
     */
    public DecimalNumber minimumValue() {
        return minimumValue;
    }

    /**
     * <p>
     * Maximum value of the column.
     * </p>
     * 
     * @return Maximum value of the column.
     */
    public DecimalNumber maximumValue() {
        return maximumValue;
    }

    /**
     * <p>
     * Number of nulls.
     * </p>
     * 
     * @return Number of nulls.
     */
    public Long numberOfNulls() {
        return numberOfNulls;
    }

    /**
     * <p>
     * Number of distinct values.
     * </p>
     * 
     * @return Number of distinct values.
     */
    public Long numberOfDistinctValues() {
        return numberOfDistinctValues;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(minimumValue());
        hashCode = 31 * hashCode + Objects.hashCode(maximumValue());
        hashCode = 31 * hashCode + Objects.hashCode(numberOfNulls());
        hashCode = 31 * hashCode + Objects.hashCode(numberOfDistinctValues());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DecimalColumnStatisticsData)) {
            return false;
        }
        DecimalColumnStatisticsData other = (DecimalColumnStatisticsData) obj;
        return Objects.equals(minimumValue(), other.minimumValue()) && Objects.equals(maximumValue(), other.maximumValue())
                && Objects.equals(numberOfNulls(), other.numberOfNulls())
                && Objects.equals(numberOfDistinctValues(), other.numberOfDistinctValues());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DecimalColumnStatisticsData").add("MinimumValue", minimumValue())
                .add("MaximumValue", maximumValue()).add("NumberOfNulls", numberOfNulls())
                .add("NumberOfDistinctValues", numberOfDistinctValues()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MinimumValue":
            return Optional.ofNullable(clazz.cast(minimumValue()));
        case "MaximumValue":
            return Optional.ofNullable(clazz.cast(maximumValue()));
        case "NumberOfNulls":
            return Optional.ofNullable(clazz.cast(numberOfNulls()));
        case "NumberOfDistinctValues":
            return Optional.ofNullable(clazz.cast(numberOfDistinctValues()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DecimalColumnStatisticsData, T> g) {
        return obj -> g.apply((DecimalColumnStatisticsData) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DecimalColumnStatisticsData> {
        /**
         * <p>
         * Minimum value of the column.
         * </p>
         * 
         * @param minimumValue
         *        Minimum value of the column.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minimumValue(DecimalNumber minimumValue);

        /**
         * <p>
         * Minimum value of the column.
         * </p>
         * This is a convenience that creates an instance of the {@link DecimalNumber.Builder} avoiding the need to
         * create one manually via {@link DecimalNumber#builder()}.
         *
         * When the {@link Consumer} completes, {@link DecimalNumber.Builder#build()} is called immediately and its
         * result is passed to {@link #minimumValue(DecimalNumber)}.
         * 
         * @param minimumValue
         *        a consumer that will call methods on {@link DecimalNumber.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #minimumValue(DecimalNumber)
         */
        default Builder minimumValue(Consumer<DecimalNumber.Builder> minimumValue) {
            return minimumValue(DecimalNumber.builder().applyMutation(minimumValue).build());
        }

        /**
         * <p>
         * Maximum value of the column.
         * </p>
         * 
         * @param maximumValue
         *        Maximum value of the column.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maximumValue(DecimalNumber maximumValue);

        /**
         * <p>
         * Maximum value of the column.
         * </p>
         * This is a convenience that creates an instance of the {@link DecimalNumber.Builder} avoiding the need to
         * create one manually via {@link DecimalNumber#builder()}.
         *
         * When the {@link Consumer} completes, {@link DecimalNumber.Builder#build()} is called immediately and its
         * result is passed to {@link #maximumValue(DecimalNumber)}.
         * 
         * @param maximumValue
         *        a consumer that will call methods on {@link DecimalNumber.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #maximumValue(DecimalNumber)
         */
        default Builder maximumValue(Consumer<DecimalNumber.Builder> maximumValue) {
            return maximumValue(DecimalNumber.builder().applyMutation(maximumValue).build());
        }

        /**
         * <p>
         * Number of nulls.
         * </p>
         * 
         * @param numberOfNulls
         *        Number of nulls.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numberOfNulls(Long numberOfNulls);

        /**
         * <p>
         * Number of distinct values.
         * </p>
         * 
         * @param numberOfDistinctValues
         *        Number of distinct values.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numberOfDistinctValues(Long numberOfDistinctValues);
    }

    static final class BuilderImpl implements Builder {
        private DecimalNumber minimumValue;

        private DecimalNumber maximumValue;

        private Long numberOfNulls;

        private Long numberOfDistinctValues;

        private BuilderImpl() {
        }

        private BuilderImpl(DecimalColumnStatisticsData model) {
            minimumValue(model.minimumValue);
            maximumValue(model.maximumValue);
            numberOfNulls(model.numberOfNulls);
            numberOfDistinctValues(model.numberOfDistinctValues);
        }

        public final DecimalNumber.Builder getMinimumValue() {
            return minimumValue != null ? minimumValue.toBuilder() : null;
        }

        @Override
        public final Builder minimumValue(DecimalNumber minimumValue) {
            this.minimumValue = minimumValue;
            return this;
        }

        public final void setMinimumValue(DecimalNumber.BuilderImpl minimumValue) {
            this.minimumValue = minimumValue != null ? minimumValue.build() : null;
        }

        public final DecimalNumber.Builder getMaximumValue() {
            return maximumValue != null ? maximumValue.toBuilder() : null;
        }

        @Override
        public final Builder maximumValue(DecimalNumber maximumValue) {
            this.maximumValue = maximumValue;
            return this;
        }

        public final void setMaximumValue(DecimalNumber.BuilderImpl maximumValue) {
            this.maximumValue = maximumValue != null ? maximumValue.build() : null;
        }

        public final Long getNumberOfNulls() {
            return numberOfNulls;
        }

        @Override
        public final Builder numberOfNulls(Long numberOfNulls) {
            this.numberOfNulls = numberOfNulls;
            return this;
        }

        public final void setNumberOfNulls(Long numberOfNulls) {
            this.numberOfNulls = numberOfNulls;
        }

        public final Long getNumberOfDistinctValues() {
            return numberOfDistinctValues;
        }

        @Override
        public final Builder numberOfDistinctValues(Long numberOfDistinctValues) {
            this.numberOfDistinctValues = numberOfDistinctValues;
            return this;
        }

        public final void setNumberOfDistinctValues(Long numberOfDistinctValues) {
            this.numberOfDistinctValues = numberOfDistinctValues;
        }

        @Override
        public DecimalColumnStatisticsData build() {
            return new DecimalColumnStatisticsData(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
