/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateScriptResponse extends GlueResponse implements
        ToCopyableBuilder<CreateScriptResponse.Builder, CreateScriptResponse> {
    private static final SdkField<String> PYTHON_SCRIPT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateScriptResponse::pythonScript)).setter(setter(Builder::pythonScript))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PythonScript").build()).build();

    private static final SdkField<String> SCALA_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateScriptResponse::scalaCode)).setter(setter(Builder::scalaCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScalaCode").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PYTHON_SCRIPT_FIELD,
            SCALA_CODE_FIELD));

    private final String pythonScript;

    private final String scalaCode;

    private CreateScriptResponse(BuilderImpl builder) {
        super(builder);
        this.pythonScript = builder.pythonScript;
        this.scalaCode = builder.scalaCode;
    }

    /**
     * <p>
     * The Python script generated from the DAG.
     * </p>
     * 
     * @return The Python script generated from the DAG.
     */
    public String pythonScript() {
        return pythonScript;
    }

    /**
     * <p>
     * The Scala code generated from the DAG.
     * </p>
     * 
     * @return The Scala code generated from the DAG.
     */
    public String scalaCode() {
        return scalaCode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(pythonScript());
        hashCode = 31 * hashCode + Objects.hashCode(scalaCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateScriptResponse)) {
            return false;
        }
        CreateScriptResponse other = (CreateScriptResponse) obj;
        return Objects.equals(pythonScript(), other.pythonScript()) && Objects.equals(scalaCode(), other.scalaCode());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CreateScriptResponse").add("PythonScript", pythonScript()).add("ScalaCode", scalaCode()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PythonScript":
            return Optional.ofNullable(clazz.cast(pythonScript()));
        case "ScalaCode":
            return Optional.ofNullable(clazz.cast(scalaCode()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateScriptResponse, T> g) {
        return obj -> g.apply((CreateScriptResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GlueResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreateScriptResponse> {
        /**
         * <p>
         * The Python script generated from the DAG.
         * </p>
         * 
         * @param pythonScript
         *        The Python script generated from the DAG.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pythonScript(String pythonScript);

        /**
         * <p>
         * The Scala code generated from the DAG.
         * </p>
         * 
         * @param scalaCode
         *        The Scala code generated from the DAG.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scalaCode(String scalaCode);
    }

    static final class BuilderImpl extends GlueResponse.BuilderImpl implements Builder {
        private String pythonScript;

        private String scalaCode;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateScriptResponse model) {
            super(model);
            pythonScript(model.pythonScript);
            scalaCode(model.scalaCode);
        }

        public final String getPythonScript() {
            return pythonScript;
        }

        @Override
        public final Builder pythonScript(String pythonScript) {
            this.pythonScript = pythonScript;
            return this;
        }

        public final void setPythonScript(String pythonScript) {
            this.pythonScript = pythonScript;
        }

        public final String getScalaCode() {
            return scalaCode;
        }

        @Override
        public final Builder scalaCode(String scalaCode) {
            this.scalaCode = scalaCode;
            return this;
        }

        public final void setScalaCode(String scalaCode) {
            this.scalaCode = scalaCode;
        }

        @Override
        public CreateScriptResponse build() {
            return new CreateScriptResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
