/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateDevEndpointRequest extends GlueRequest implements
        ToCopyableBuilder<CreateDevEndpointRequest.Builder, CreateDevEndpointRequest> {
    private static final SdkField<String> ENDPOINT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateDevEndpointRequest::endpointName)).setter(setter(Builder::endpointName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointName").build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateDevEndpointRequest::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()).build();

    private static final SdkField<List<String>> SECURITY_GROUP_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(CreateDevEndpointRequest::securityGroupIds))
            .setter(setter(Builder::securityGroupIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityGroupIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> SUBNET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateDevEndpointRequest::subnetId)).setter(setter(Builder::subnetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetId").build()).build();

    private static final SdkField<String> PUBLIC_KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateDevEndpointRequest::publicKey)).setter(setter(Builder::publicKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PublicKey").build()).build();

    private static final SdkField<List<String>> PUBLIC_KEYS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(CreateDevEndpointRequest::publicKeys))
            .setter(setter(Builder::publicKeys))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PublicKeys").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Integer> NUMBER_OF_NODES_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(CreateDevEndpointRequest::numberOfNodes)).setter(setter(Builder::numberOfNodes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberOfNodes").build()).build();

    private static final SdkField<String> WORKER_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateDevEndpointRequest::workerTypeAsString)).setter(setter(Builder::workerType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkerType").build()).build();

    private static final SdkField<String> GLUE_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateDevEndpointRequest::glueVersion)).setter(setter(Builder::glueVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GlueVersion").build()).build();

    private static final SdkField<Integer> NUMBER_OF_WORKERS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(CreateDevEndpointRequest::numberOfWorkers)).setter(setter(Builder::numberOfWorkers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberOfWorkers").build()).build();

    private static final SdkField<String> EXTRA_PYTHON_LIBS_S3_PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateDevEndpointRequest::extraPythonLibsS3Path)).setter(setter(Builder::extraPythonLibsS3Path))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExtraPythonLibsS3Path").build())
            .build();

    private static final SdkField<String> EXTRA_JARS_S3_PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateDevEndpointRequest::extraJarsS3Path)).setter(setter(Builder::extraJarsS3Path))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExtraJarsS3Path").build()).build();

    private static final SdkField<String> SECURITY_CONFIGURATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateDevEndpointRequest::securityConfiguration)).setter(setter(Builder::securityConfiguration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityConfiguration").build())
            .build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .getter(getter(CreateDevEndpointRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Map<String, String>> ARGUMENTS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .getter(getter(CreateDevEndpointRequest::arguments))
            .setter(setter(Builder::arguments))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arguments").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(ENDPOINT_NAME_FIELD, ROLE_ARN_FIELD, SECURITY_GROUP_IDS_FIELD, SUBNET_ID_FIELD,
                    PUBLIC_KEY_FIELD, PUBLIC_KEYS_FIELD, NUMBER_OF_NODES_FIELD, WORKER_TYPE_FIELD, GLUE_VERSION_FIELD,
                    NUMBER_OF_WORKERS_FIELD, EXTRA_PYTHON_LIBS_S3_PATH_FIELD, EXTRA_JARS_S3_PATH_FIELD,
                    SECURITY_CONFIGURATION_FIELD, TAGS_FIELD, ARGUMENTS_FIELD));

    private final String endpointName;

    private final String roleArn;

    private final List<String> securityGroupIds;

    private final String subnetId;

    private final String publicKey;

    private final List<String> publicKeys;

    private final Integer numberOfNodes;

    private final String workerType;

    private final String glueVersion;

    private final Integer numberOfWorkers;

    private final String extraPythonLibsS3Path;

    private final String extraJarsS3Path;

    private final String securityConfiguration;

    private final Map<String, String> tags;

    private final Map<String, String> arguments;

    private CreateDevEndpointRequest(BuilderImpl builder) {
        super(builder);
        this.endpointName = builder.endpointName;
        this.roleArn = builder.roleArn;
        this.securityGroupIds = builder.securityGroupIds;
        this.subnetId = builder.subnetId;
        this.publicKey = builder.publicKey;
        this.publicKeys = builder.publicKeys;
        this.numberOfNodes = builder.numberOfNodes;
        this.workerType = builder.workerType;
        this.glueVersion = builder.glueVersion;
        this.numberOfWorkers = builder.numberOfWorkers;
        this.extraPythonLibsS3Path = builder.extraPythonLibsS3Path;
        this.extraJarsS3Path = builder.extraJarsS3Path;
        this.securityConfiguration = builder.securityConfiguration;
        this.tags = builder.tags;
        this.arguments = builder.arguments;
    }

    /**
     * <p>
     * The name to be assigned to the new <code>DevEndpoint</code>.
     * </p>
     * 
     * @return The name to be assigned to the new <code>DevEndpoint</code>.
     */
    public String endpointName() {
        return endpointName;
    }

    /**
     * <p>
     * The IAM role for the <code>DevEndpoint</code>.
     * </p>
     * 
     * @return The IAM role for the <code>DevEndpoint</code>.
     */
    public String roleArn() {
        return roleArn;
    }

    /**
     * Returns true if the SecurityGroupIds property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasSecurityGroupIds() {
        return securityGroupIds != null && !(securityGroupIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Security group IDs for the security groups to be used by the new <code>DevEndpoint</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasSecurityGroupIds()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Security group IDs for the security groups to be used by the new <code>DevEndpoint</code>.
     */
    public List<String> securityGroupIds() {
        return securityGroupIds;
    }

    /**
     * <p>
     * The subnet ID for the new <code>DevEndpoint</code> to use.
     * </p>
     * 
     * @return The subnet ID for the new <code>DevEndpoint</code> to use.
     */
    public String subnetId() {
        return subnetId;
    }

    /**
     * <p>
     * The public key to be used by this <code>DevEndpoint</code> for authentication. This attribute is provided for
     * backward compatibility because the recommended attribute to use is public keys.
     * </p>
     * 
     * @return The public key to be used by this <code>DevEndpoint</code> for authentication. This attribute is provided
     *         for backward compatibility because the recommended attribute to use is public keys.
     */
    public String publicKey() {
        return publicKey;
    }

    /**
     * Returns true if the PublicKeys property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasPublicKeys() {
        return publicKeys != null && !(publicKeys instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of public keys to be used by the development endpoints for authentication. The use of this attribute is
     * preferred over a single public key because the public keys allow you to have a different private key per client.
     * </p>
     * <note>
     * <p>
     * If you previously created an endpoint with a public key, you must remove that key to be able to set a list of
     * public keys. Call the <code>UpdateDevEndpoint</code> API with the public key content in the
     * <code>deletePublicKeys</code> attribute, and the list of new keys in the <code>addPublicKeys</code> attribute.
     * </p>
     * </note>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasPublicKeys()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of public keys to be used by the development endpoints for authentication. The use of this
     *         attribute is preferred over a single public key because the public keys allow you to have a different
     *         private key per client.</p> <note>
     *         <p>
     *         If you previously created an endpoint with a public key, you must remove that key to be able to set a
     *         list of public keys. Call the <code>UpdateDevEndpoint</code> API with the public key content in the
     *         <code>deletePublicKeys</code> attribute, and the list of new keys in the <code>addPublicKeys</code>
     *         attribute.
     *         </p>
     */
    public List<String> publicKeys() {
        return publicKeys;
    }

    /**
     * <p>
     * The number of AWS Glue Data Processing Units (DPUs) to allocate to this <code>DevEndpoint</code>.
     * </p>
     * 
     * @return The number of AWS Glue Data Processing Units (DPUs) to allocate to this <code>DevEndpoint</code>.
     */
    public Integer numberOfNodes() {
        return numberOfNodes;
    }

    /**
     * <p>
     * The type of predefined worker that is allocated to the development endpoint. Accepts a value of Standard, G.1X,
     * or G.2X.
     * </p>
     * <ul>
     * <li>
     * <p>
     * For the <code>Standard</code> worker type, each worker provides 4 vCPU, 16 GB of memory and a 50GB disk, and 2
     * executors per worker.
     * </p>
     * </li>
     * <li>
     * <p>
     * For the <code>G.1X</code> worker type, each worker maps to 1 DPU (4 vCPU, 16 GB of memory, 64 GB disk), and
     * provides 1 executor per worker. We recommend this worker type for memory-intensive jobs.
     * </p>
     * </li>
     * <li>
     * <p>
     * For the <code>G.2X</code> worker type, each worker maps to 2 DPU (8 vCPU, 32 GB of memory, 128 GB disk), and
     * provides 1 executor per worker. We recommend this worker type for memory-intensive jobs.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Known issue: when a development endpoint is created with the <code>G.2X</code> <code>WorkerType</code>
     * configuration, the Spark drivers for the development endpoint will run on 4 vCPU, 16 GB of memory, and a 64 GB
     * disk.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #workerType} will
     * return {@link WorkerType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #workerTypeAsString}.
     * </p>
     * 
     * @return The type of predefined worker that is allocated to the development endpoint. Accepts a value of Standard,
     *         G.1X, or G.2X.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         For the <code>Standard</code> worker type, each worker provides 4 vCPU, 16 GB of memory and a 50GB disk,
     *         and 2 executors per worker.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For the <code>G.1X</code> worker type, each worker maps to 1 DPU (4 vCPU, 16 GB of memory, 64 GB disk),
     *         and provides 1 executor per worker. We recommend this worker type for memory-intensive jobs.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For the <code>G.2X</code> worker type, each worker maps to 2 DPU (8 vCPU, 32 GB of memory, 128 GB disk),
     *         and provides 1 executor per worker. We recommend this worker type for memory-intensive jobs.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         Known issue: when a development endpoint is created with the <code>G.2X</code> <code>WorkerType</code>
     *         configuration, the Spark drivers for the development endpoint will run on 4 vCPU, 16 GB of memory, and a
     *         64 GB disk.
     * @see WorkerType
     */
    public WorkerType workerType() {
        return WorkerType.fromValue(workerType);
    }

    /**
     * <p>
     * The type of predefined worker that is allocated to the development endpoint. Accepts a value of Standard, G.1X,
     * or G.2X.
     * </p>
     * <ul>
     * <li>
     * <p>
     * For the <code>Standard</code> worker type, each worker provides 4 vCPU, 16 GB of memory and a 50GB disk, and 2
     * executors per worker.
     * </p>
     * </li>
     * <li>
     * <p>
     * For the <code>G.1X</code> worker type, each worker maps to 1 DPU (4 vCPU, 16 GB of memory, 64 GB disk), and
     * provides 1 executor per worker. We recommend this worker type for memory-intensive jobs.
     * </p>
     * </li>
     * <li>
     * <p>
     * For the <code>G.2X</code> worker type, each worker maps to 2 DPU (8 vCPU, 32 GB of memory, 128 GB disk), and
     * provides 1 executor per worker. We recommend this worker type for memory-intensive jobs.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Known issue: when a development endpoint is created with the <code>G.2X</code> <code>WorkerType</code>
     * configuration, the Spark drivers for the development endpoint will run on 4 vCPU, 16 GB of memory, and a 64 GB
     * disk.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #workerType} will
     * return {@link WorkerType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #workerTypeAsString}.
     * </p>
     * 
     * @return The type of predefined worker that is allocated to the development endpoint. Accepts a value of Standard,
     *         G.1X, or G.2X.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         For the <code>Standard</code> worker type, each worker provides 4 vCPU, 16 GB of memory and a 50GB disk,
     *         and 2 executors per worker.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For the <code>G.1X</code> worker type, each worker maps to 1 DPU (4 vCPU, 16 GB of memory, 64 GB disk),
     *         and provides 1 executor per worker. We recommend this worker type for memory-intensive jobs.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For the <code>G.2X</code> worker type, each worker maps to 2 DPU (8 vCPU, 32 GB of memory, 128 GB disk),
     *         and provides 1 executor per worker. We recommend this worker type for memory-intensive jobs.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         Known issue: when a development endpoint is created with the <code>G.2X</code> <code>WorkerType</code>
     *         configuration, the Spark drivers for the development endpoint will run on 4 vCPU, 16 GB of memory, and a
     *         64 GB disk.
     * @see WorkerType
     */
    public String workerTypeAsString() {
        return workerType;
    }

    /**
     * <p>
     * Glue version determines the versions of Apache Spark and Python that AWS Glue supports. The Python version
     * indicates the version supported for running your ETL scripts on development endpoints.
     * </p>
     * <p>
     * For more information about the available AWS Glue versions and corresponding Spark and Python versions, see <a
     * href="https://docs.aws.amazon.com/glue/latest/dg/add-job.html">Glue version</a> in the developer guide.
     * </p>
     * <p>
     * Development endpoints that are created without specifying a Glue version default to Glue 0.9.
     * </p>
     * <p>
     * You can specify a version of Python support for development endpoints by using the <code>Arguments</code>
     * parameter in the <code>CreateDevEndpoint</code> or <code>UpdateDevEndpoint</code> APIs. If no arguments are
     * provided, the version defaults to Python 2.
     * </p>
     * 
     * @return Glue version determines the versions of Apache Spark and Python that AWS Glue supports. The Python
     *         version indicates the version supported for running your ETL scripts on development endpoints. </p>
     *         <p>
     *         For more information about the available AWS Glue versions and corresponding Spark and Python versions,
     *         see <a href="https://docs.aws.amazon.com/glue/latest/dg/add-job.html">Glue version</a> in the developer
     *         guide.
     *         </p>
     *         <p>
     *         Development endpoints that are created without specifying a Glue version default to Glue 0.9.
     *         </p>
     *         <p>
     *         You can specify a version of Python support for development endpoints by using the <code>Arguments</code>
     *         parameter in the <code>CreateDevEndpoint</code> or <code>UpdateDevEndpoint</code> APIs. If no arguments
     *         are provided, the version defaults to Python 2.
     */
    public String glueVersion() {
        return glueVersion;
    }

    /**
     * <p>
     * The number of workers of a defined <code>workerType</code> that are allocated to the development endpoint.
     * </p>
     * <p>
     * The maximum number of workers you can define are 299 for <code>G.1X</code>, and 149 for <code>G.2X</code>.
     * </p>
     * 
     * @return The number of workers of a defined <code>workerType</code> that are allocated to the development
     *         endpoint.</p>
     *         <p>
     *         The maximum number of workers you can define are 299 for <code>G.1X</code>, and 149 for <code>G.2X</code>.
     */
    public Integer numberOfWorkers() {
        return numberOfWorkers;
    }

    /**
     * <p>
     * The paths to one or more Python libraries in an Amazon S3 bucket that should be loaded in your
     * <code>DevEndpoint</code>. Multiple values must be complete paths separated by a comma.
     * </p>
     * <note>
     * <p>
     * You can only use pure Python libraries with a <code>DevEndpoint</code>. Libraries that rely on C extensions, such
     * as the <a href="http://pandas.pydata.org/">pandas</a> Python data analysis library, are not yet supported.
     * </p>
     * </note>
     * 
     * @return The paths to one or more Python libraries in an Amazon S3 bucket that should be loaded in your
     *         <code>DevEndpoint</code>. Multiple values must be complete paths separated by a comma.</p> <note>
     *         <p>
     *         You can only use pure Python libraries with a <code>DevEndpoint</code>. Libraries that rely on C
     *         extensions, such as the <a href="http://pandas.pydata.org/">pandas</a> Python data analysis library, are
     *         not yet supported.
     *         </p>
     */
    public String extraPythonLibsS3Path() {
        return extraPythonLibsS3Path;
    }

    /**
     * <p>
     * The path to one or more Java <code>.jar</code> files in an S3 bucket that should be loaded in your
     * <code>DevEndpoint</code>.
     * </p>
     * 
     * @return The path to one or more Java <code>.jar</code> files in an S3 bucket that should be loaded in your
     *         <code>DevEndpoint</code>.
     */
    public String extraJarsS3Path() {
        return extraJarsS3Path;
    }

    /**
     * <p>
     * The name of the <code>SecurityConfiguration</code> structure to be used with this <code>DevEndpoint</code>.
     * </p>
     * 
     * @return The name of the <code>SecurityConfiguration</code> structure to be used with this
     *         <code>DevEndpoint</code>.
     */
    public String securityConfiguration() {
        return securityConfiguration;
    }

    /**
     * Returns true if the Tags property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The tags to use with this DevEndpoint. You may use tags to limit access to the DevEndpoint. For more information
     * about tags in AWS Glue, see <a href="https://docs.aws.amazon.com/glue/latest/dg/monitor-tags.html">AWS Tags in
     * AWS Glue</a> in the developer guide.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The tags to use with this DevEndpoint. You may use tags to limit access to the DevEndpoint. For more
     *         information about tags in AWS Glue, see <a
     *         href="https://docs.aws.amazon.com/glue/latest/dg/monitor-tags.html">AWS Tags in AWS Glue</a> in the
     *         developer guide.
     */
    public Map<String, String> tags() {
        return tags;
    }

    /**
     * Returns true if the Arguments property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasArguments() {
        return arguments != null && !(arguments instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A map of arguments used to configure the <code>DevEndpoint</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasArguments()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A map of arguments used to configure the <code>DevEndpoint</code>.
     */
    public Map<String, String> arguments() {
        return arguments;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(endpointName());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(securityGroupIds());
        hashCode = 31 * hashCode + Objects.hashCode(subnetId());
        hashCode = 31 * hashCode + Objects.hashCode(publicKey());
        hashCode = 31 * hashCode + Objects.hashCode(publicKeys());
        hashCode = 31 * hashCode + Objects.hashCode(numberOfNodes());
        hashCode = 31 * hashCode + Objects.hashCode(workerTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(glueVersion());
        hashCode = 31 * hashCode + Objects.hashCode(numberOfWorkers());
        hashCode = 31 * hashCode + Objects.hashCode(extraPythonLibsS3Path());
        hashCode = 31 * hashCode + Objects.hashCode(extraJarsS3Path());
        hashCode = 31 * hashCode + Objects.hashCode(securityConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(tags());
        hashCode = 31 * hashCode + Objects.hashCode(arguments());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDevEndpointRequest)) {
            return false;
        }
        CreateDevEndpointRequest other = (CreateDevEndpointRequest) obj;
        return Objects.equals(endpointName(), other.endpointName()) && Objects.equals(roleArn(), other.roleArn())
                && Objects.equals(securityGroupIds(), other.securityGroupIds()) && Objects.equals(subnetId(), other.subnetId())
                && Objects.equals(publicKey(), other.publicKey()) && Objects.equals(publicKeys(), other.publicKeys())
                && Objects.equals(numberOfNodes(), other.numberOfNodes())
                && Objects.equals(workerTypeAsString(), other.workerTypeAsString())
                && Objects.equals(glueVersion(), other.glueVersion())
                && Objects.equals(numberOfWorkers(), other.numberOfWorkers())
                && Objects.equals(extraPythonLibsS3Path(), other.extraPythonLibsS3Path())
                && Objects.equals(extraJarsS3Path(), other.extraJarsS3Path())
                && Objects.equals(securityConfiguration(), other.securityConfiguration()) && Objects.equals(tags(), other.tags())
                && Objects.equals(arguments(), other.arguments());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CreateDevEndpointRequest").add("EndpointName", endpointName()).add("RoleArn", roleArn())
                .add("SecurityGroupIds", securityGroupIds()).add("SubnetId", subnetId()).add("PublicKey", publicKey())
                .add("PublicKeys", publicKeys()).add("NumberOfNodes", numberOfNodes()).add("WorkerType", workerTypeAsString())
                .add("GlueVersion", glueVersion()).add("NumberOfWorkers", numberOfWorkers())
                .add("ExtraPythonLibsS3Path", extraPythonLibsS3Path()).add("ExtraJarsS3Path", extraJarsS3Path())
                .add("SecurityConfiguration", securityConfiguration()).add("Tags", tags()).add("Arguments", arguments()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EndpointName":
            return Optional.ofNullable(clazz.cast(endpointName()));
        case "RoleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "SecurityGroupIds":
            return Optional.ofNullable(clazz.cast(securityGroupIds()));
        case "SubnetId":
            return Optional.ofNullable(clazz.cast(subnetId()));
        case "PublicKey":
            return Optional.ofNullable(clazz.cast(publicKey()));
        case "PublicKeys":
            return Optional.ofNullable(clazz.cast(publicKeys()));
        case "NumberOfNodes":
            return Optional.ofNullable(clazz.cast(numberOfNodes()));
        case "WorkerType":
            return Optional.ofNullable(clazz.cast(workerTypeAsString()));
        case "GlueVersion":
            return Optional.ofNullable(clazz.cast(glueVersion()));
        case "NumberOfWorkers":
            return Optional.ofNullable(clazz.cast(numberOfWorkers()));
        case "ExtraPythonLibsS3Path":
            return Optional.ofNullable(clazz.cast(extraPythonLibsS3Path()));
        case "ExtraJarsS3Path":
            return Optional.ofNullable(clazz.cast(extraJarsS3Path()));
        case "SecurityConfiguration":
            return Optional.ofNullable(clazz.cast(securityConfiguration()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "Arguments":
            return Optional.ofNullable(clazz.cast(arguments()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateDevEndpointRequest, T> g) {
        return obj -> g.apply((CreateDevEndpointRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GlueRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateDevEndpointRequest> {
        /**
         * <p>
         * The name to be assigned to the new <code>DevEndpoint</code>.
         * </p>
         * 
         * @param endpointName
         *        The name to be assigned to the new <code>DevEndpoint</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpointName(String endpointName);

        /**
         * <p>
         * The IAM role for the <code>DevEndpoint</code>.
         * </p>
         * 
         * @param roleArn
         *        The IAM role for the <code>DevEndpoint</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * Security group IDs for the security groups to be used by the new <code>DevEndpoint</code>.
         * </p>
         * 
         * @param securityGroupIds
         *        Security group IDs for the security groups to be used by the new <code>DevEndpoint</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroupIds(Collection<String> securityGroupIds);

        /**
         * <p>
         * Security group IDs for the security groups to be used by the new <code>DevEndpoint</code>.
         * </p>
         * 
         * @param securityGroupIds
         *        Security group IDs for the security groups to be used by the new <code>DevEndpoint</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroupIds(String... securityGroupIds);

        /**
         * <p>
         * The subnet ID for the new <code>DevEndpoint</code> to use.
         * </p>
         * 
         * @param subnetId
         *        The subnet ID for the new <code>DevEndpoint</code> to use.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnetId(String subnetId);

        /**
         * <p>
         * The public key to be used by this <code>DevEndpoint</code> for authentication. This attribute is provided for
         * backward compatibility because the recommended attribute to use is public keys.
         * </p>
         * 
         * @param publicKey
         *        The public key to be used by this <code>DevEndpoint</code> for authentication. This attribute is
         *        provided for backward compatibility because the recommended attribute to use is public keys.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder publicKey(String publicKey);

        /**
         * <p>
         * A list of public keys to be used by the development endpoints for authentication. The use of this attribute
         * is preferred over a single public key because the public keys allow you to have a different private key per
         * client.
         * </p>
         * <note>
         * <p>
         * If you previously created an endpoint with a public key, you must remove that key to be able to set a list of
         * public keys. Call the <code>UpdateDevEndpoint</code> API with the public key content in the
         * <code>deletePublicKeys</code> attribute, and the list of new keys in the <code>addPublicKeys</code>
         * attribute.
         * </p>
         * </note>
         * 
         * @param publicKeys
         *        A list of public keys to be used by the development endpoints for authentication. The use of this
         *        attribute is preferred over a single public key because the public keys allow you to have a different
         *        private key per client.</p> <note>
         *        <p>
         *        If you previously created an endpoint with a public key, you must remove that key to be able to set a
         *        list of public keys. Call the <code>UpdateDevEndpoint</code> API with the public key content in the
         *        <code>deletePublicKeys</code> attribute, and the list of new keys in the <code>addPublicKeys</code>
         *        attribute.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder publicKeys(Collection<String> publicKeys);

        /**
         * <p>
         * A list of public keys to be used by the development endpoints for authentication. The use of this attribute
         * is preferred over a single public key because the public keys allow you to have a different private key per
         * client.
         * </p>
         * <note>
         * <p>
         * If you previously created an endpoint with a public key, you must remove that key to be able to set a list of
         * public keys. Call the <code>UpdateDevEndpoint</code> API with the public key content in the
         * <code>deletePublicKeys</code> attribute, and the list of new keys in the <code>addPublicKeys</code>
         * attribute.
         * </p>
         * </note>
         * 
         * @param publicKeys
         *        A list of public keys to be used by the development endpoints for authentication. The use of this
         *        attribute is preferred over a single public key because the public keys allow you to have a different
         *        private key per client.</p> <note>
         *        <p>
         *        If you previously created an endpoint with a public key, you must remove that key to be able to set a
         *        list of public keys. Call the <code>UpdateDevEndpoint</code> API with the public key content in the
         *        <code>deletePublicKeys</code> attribute, and the list of new keys in the <code>addPublicKeys</code>
         *        attribute.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder publicKeys(String... publicKeys);

        /**
         * <p>
         * The number of AWS Glue Data Processing Units (DPUs) to allocate to this <code>DevEndpoint</code>.
         * </p>
         * 
         * @param numberOfNodes
         *        The number of AWS Glue Data Processing Units (DPUs) to allocate to this <code>DevEndpoint</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numberOfNodes(Integer numberOfNodes);

        /**
         * <p>
         * The type of predefined worker that is allocated to the development endpoint. Accepts a value of Standard,
         * G.1X, or G.2X.
         * </p>
         * <ul>
         * <li>
         * <p>
         * For the <code>Standard</code> worker type, each worker provides 4 vCPU, 16 GB of memory and a 50GB disk, and
         * 2 executors per worker.
         * </p>
         * </li>
         * <li>
         * <p>
         * For the <code>G.1X</code> worker type, each worker maps to 1 DPU (4 vCPU, 16 GB of memory, 64 GB disk), and
         * provides 1 executor per worker. We recommend this worker type for memory-intensive jobs.
         * </p>
         * </li>
         * <li>
         * <p>
         * For the <code>G.2X</code> worker type, each worker maps to 2 DPU (8 vCPU, 32 GB of memory, 128 GB disk), and
         * provides 1 executor per worker. We recommend this worker type for memory-intensive jobs.
         * </p>
         * </li>
         * </ul>
         * <p>
         * Known issue: when a development endpoint is created with the <code>G.2X</code> <code>WorkerType</code>
         * configuration, the Spark drivers for the development endpoint will run on 4 vCPU, 16 GB of memory, and a 64
         * GB disk.
         * </p>
         * 
         * @param workerType
         *        The type of predefined worker that is allocated to the development endpoint. Accepts a value of
         *        Standard, G.1X, or G.2X.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        For the <code>Standard</code> worker type, each worker provides 4 vCPU, 16 GB of memory and a 50GB
         *        disk, and 2 executors per worker.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        For the <code>G.1X</code> worker type, each worker maps to 1 DPU (4 vCPU, 16 GB of memory, 64 GB
         *        disk), and provides 1 executor per worker. We recommend this worker type for memory-intensive jobs.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        For the <code>G.2X</code> worker type, each worker maps to 2 DPU (8 vCPU, 32 GB of memory, 128 GB
         *        disk), and provides 1 executor per worker. We recommend this worker type for memory-intensive jobs.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        Known issue: when a development endpoint is created with the <code>G.2X</code> <code>WorkerType</code>
         *        configuration, the Spark drivers for the development endpoint will run on 4 vCPU, 16 GB of memory, and
         *        a 64 GB disk.
         * @see WorkerType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WorkerType
         */
        Builder workerType(String workerType);

        /**
         * <p>
         * The type of predefined worker that is allocated to the development endpoint. Accepts a value of Standard,
         * G.1X, or G.2X.
         * </p>
         * <ul>
         * <li>
         * <p>
         * For the <code>Standard</code> worker type, each worker provides 4 vCPU, 16 GB of memory and a 50GB disk, and
         * 2 executors per worker.
         * </p>
         * </li>
         * <li>
         * <p>
         * For the <code>G.1X</code> worker type, each worker maps to 1 DPU (4 vCPU, 16 GB of memory, 64 GB disk), and
         * provides 1 executor per worker. We recommend this worker type for memory-intensive jobs.
         * </p>
         * </li>
         * <li>
         * <p>
         * For the <code>G.2X</code> worker type, each worker maps to 2 DPU (8 vCPU, 32 GB of memory, 128 GB disk), and
         * provides 1 executor per worker. We recommend this worker type for memory-intensive jobs.
         * </p>
         * </li>
         * </ul>
         * <p>
         * Known issue: when a development endpoint is created with the <code>G.2X</code> <code>WorkerType</code>
         * configuration, the Spark drivers for the development endpoint will run on 4 vCPU, 16 GB of memory, and a 64
         * GB disk.
         * </p>
         * 
         * @param workerType
         *        The type of predefined worker that is allocated to the development endpoint. Accepts a value of
         *        Standard, G.1X, or G.2X.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        For the <code>Standard</code> worker type, each worker provides 4 vCPU, 16 GB of memory and a 50GB
         *        disk, and 2 executors per worker.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        For the <code>G.1X</code> worker type, each worker maps to 1 DPU (4 vCPU, 16 GB of memory, 64 GB
         *        disk), and provides 1 executor per worker. We recommend this worker type for memory-intensive jobs.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        For the <code>G.2X</code> worker type, each worker maps to 2 DPU (8 vCPU, 32 GB of memory, 128 GB
         *        disk), and provides 1 executor per worker. We recommend this worker type for memory-intensive jobs.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        Known issue: when a development endpoint is created with the <code>G.2X</code> <code>WorkerType</code>
         *        configuration, the Spark drivers for the development endpoint will run on 4 vCPU, 16 GB of memory, and
         *        a 64 GB disk.
         * @see WorkerType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WorkerType
         */
        Builder workerType(WorkerType workerType);

        /**
         * <p>
         * Glue version determines the versions of Apache Spark and Python that AWS Glue supports. The Python version
         * indicates the version supported for running your ETL scripts on development endpoints.
         * </p>
         * <p>
         * For more information about the available AWS Glue versions and corresponding Spark and Python versions, see
         * <a href="https://docs.aws.amazon.com/glue/latest/dg/add-job.html">Glue version</a> in the developer guide.
         * </p>
         * <p>
         * Development endpoints that are created without specifying a Glue version default to Glue 0.9.
         * </p>
         * <p>
         * You can specify a version of Python support for development endpoints by using the <code>Arguments</code>
         * parameter in the <code>CreateDevEndpoint</code> or <code>UpdateDevEndpoint</code> APIs. If no arguments are
         * provided, the version defaults to Python 2.
         * </p>
         * 
         * @param glueVersion
         *        Glue version determines the versions of Apache Spark and Python that AWS Glue supports. The Python
         *        version indicates the version supported for running your ETL scripts on development endpoints. </p>
         *        <p>
         *        For more information about the available AWS Glue versions and corresponding Spark and Python
         *        versions, see <a href="https://docs.aws.amazon.com/glue/latest/dg/add-job.html">Glue version</a> in
         *        the developer guide.
         *        </p>
         *        <p>
         *        Development endpoints that are created without specifying a Glue version default to Glue 0.9.
         *        </p>
         *        <p>
         *        You can specify a version of Python support for development endpoints by using the
         *        <code>Arguments</code> parameter in the <code>CreateDevEndpoint</code> or
         *        <code>UpdateDevEndpoint</code> APIs. If no arguments are provided, the version defaults to Python 2.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder glueVersion(String glueVersion);

        /**
         * <p>
         * The number of workers of a defined <code>workerType</code> that are allocated to the development endpoint.
         * </p>
         * <p>
         * The maximum number of workers you can define are 299 for <code>G.1X</code>, and 149 for <code>G.2X</code>.
         * </p>
         * 
         * @param numberOfWorkers
         *        The number of workers of a defined <code>workerType</code> that are allocated to the development
         *        endpoint.</p>
         *        <p>
         *        The maximum number of workers you can define are 299 for <code>G.1X</code>, and 149 for
         *        <code>G.2X</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numberOfWorkers(Integer numberOfWorkers);

        /**
         * <p>
         * The paths to one or more Python libraries in an Amazon S3 bucket that should be loaded in your
         * <code>DevEndpoint</code>. Multiple values must be complete paths separated by a comma.
         * </p>
         * <note>
         * <p>
         * You can only use pure Python libraries with a <code>DevEndpoint</code>. Libraries that rely on C extensions,
         * such as the <a href="http://pandas.pydata.org/">pandas</a> Python data analysis library, are not yet
         * supported.
         * </p>
         * </note>
         * 
         * @param extraPythonLibsS3Path
         *        The paths to one or more Python libraries in an Amazon S3 bucket that should be loaded in your
         *        <code>DevEndpoint</code>. Multiple values must be complete paths separated by a comma.</p> <note>
         *        <p>
         *        You can only use pure Python libraries with a <code>DevEndpoint</code>. Libraries that rely on C
         *        extensions, such as the <a href="http://pandas.pydata.org/">pandas</a> Python data analysis library,
         *        are not yet supported.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder extraPythonLibsS3Path(String extraPythonLibsS3Path);

        /**
         * <p>
         * The path to one or more Java <code>.jar</code> files in an S3 bucket that should be loaded in your
         * <code>DevEndpoint</code>.
         * </p>
         * 
         * @param extraJarsS3Path
         *        The path to one or more Java <code>.jar</code> files in an S3 bucket that should be loaded in your
         *        <code>DevEndpoint</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder extraJarsS3Path(String extraJarsS3Path);

        /**
         * <p>
         * The name of the <code>SecurityConfiguration</code> structure to be used with this <code>DevEndpoint</code>.
         * </p>
         * 
         * @param securityConfiguration
         *        The name of the <code>SecurityConfiguration</code> structure to be used with this
         *        <code>DevEndpoint</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityConfiguration(String securityConfiguration);

        /**
         * <p>
         * The tags to use with this DevEndpoint. You may use tags to limit access to the DevEndpoint. For more
         * information about tags in AWS Glue, see <a
         * href="https://docs.aws.amazon.com/glue/latest/dg/monitor-tags.html">AWS Tags in AWS Glue</a> in the developer
         * guide.
         * </p>
         * 
         * @param tags
         *        The tags to use with this DevEndpoint. You may use tags to limit access to the DevEndpoint. For more
         *        information about tags in AWS Glue, see <a
         *        href="https://docs.aws.amazon.com/glue/latest/dg/monitor-tags.html">AWS Tags in AWS Glue</a> in the
         *        developer guide.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p>
         * A map of arguments used to configure the <code>DevEndpoint</code>.
         * </p>
         * 
         * @param arguments
         *        A map of arguments used to configure the <code>DevEndpoint</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arguments(Map<String, String> arguments);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends GlueRequest.BuilderImpl implements Builder {
        private String endpointName;

        private String roleArn;

        private List<String> securityGroupIds = DefaultSdkAutoConstructList.getInstance();

        private String subnetId;

        private String publicKey;

        private List<String> publicKeys = DefaultSdkAutoConstructList.getInstance();

        private Integer numberOfNodes;

        private String workerType;

        private String glueVersion;

        private Integer numberOfWorkers;

        private String extraPythonLibsS3Path;

        private String extraJarsS3Path;

        private String securityConfiguration;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private Map<String, String> arguments = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDevEndpointRequest model) {
            super(model);
            endpointName(model.endpointName);
            roleArn(model.roleArn);
            securityGroupIds(model.securityGroupIds);
            subnetId(model.subnetId);
            publicKey(model.publicKey);
            publicKeys(model.publicKeys);
            numberOfNodes(model.numberOfNodes);
            workerType(model.workerType);
            glueVersion(model.glueVersion);
            numberOfWorkers(model.numberOfWorkers);
            extraPythonLibsS3Path(model.extraPythonLibsS3Path);
            extraJarsS3Path(model.extraJarsS3Path);
            securityConfiguration(model.securityConfiguration);
            tags(model.tags);
            arguments(model.arguments);
        }

        public final String getEndpointName() {
            return endpointName;
        }

        @Override
        public final Builder endpointName(String endpointName) {
            this.endpointName = endpointName;
            return this;
        }

        public final void setEndpointName(String endpointName) {
            this.endpointName = endpointName;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        public final Collection<String> getSecurityGroupIds() {
            return securityGroupIds;
        }

        @Override
        public final Builder securityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = StringListCopier.copy(securityGroupIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroupIds(String... securityGroupIds) {
            securityGroupIds(Arrays.asList(securityGroupIds));
            return this;
        }

        public final void setSecurityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = StringListCopier.copy(securityGroupIds);
        }

        public final String getSubnetId() {
            return subnetId;
        }

        @Override
        public final Builder subnetId(String subnetId) {
            this.subnetId = subnetId;
            return this;
        }

        public final void setSubnetId(String subnetId) {
            this.subnetId = subnetId;
        }

        public final String getPublicKey() {
            return publicKey;
        }

        @Override
        public final Builder publicKey(String publicKey) {
            this.publicKey = publicKey;
            return this;
        }

        public final void setPublicKey(String publicKey) {
            this.publicKey = publicKey;
        }

        public final Collection<String> getPublicKeys() {
            return publicKeys;
        }

        @Override
        public final Builder publicKeys(Collection<String> publicKeys) {
            this.publicKeys = PublicKeysListCopier.copy(publicKeys);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder publicKeys(String... publicKeys) {
            publicKeys(Arrays.asList(publicKeys));
            return this;
        }

        public final void setPublicKeys(Collection<String> publicKeys) {
            this.publicKeys = PublicKeysListCopier.copy(publicKeys);
        }

        public final Integer getNumberOfNodes() {
            return numberOfNodes;
        }

        @Override
        public final Builder numberOfNodes(Integer numberOfNodes) {
            this.numberOfNodes = numberOfNodes;
            return this;
        }

        public final void setNumberOfNodes(Integer numberOfNodes) {
            this.numberOfNodes = numberOfNodes;
        }

        public final String getWorkerType() {
            return workerType;
        }

        @Override
        public final Builder workerType(String workerType) {
            this.workerType = workerType;
            return this;
        }

        @Override
        public final Builder workerType(WorkerType workerType) {
            this.workerType(workerType == null ? null : workerType.toString());
            return this;
        }

        public final void setWorkerType(String workerType) {
            this.workerType = workerType;
        }

        public final String getGlueVersion() {
            return glueVersion;
        }

        @Override
        public final Builder glueVersion(String glueVersion) {
            this.glueVersion = glueVersion;
            return this;
        }

        public final void setGlueVersion(String glueVersion) {
            this.glueVersion = glueVersion;
        }

        public final Integer getNumberOfWorkers() {
            return numberOfWorkers;
        }

        @Override
        public final Builder numberOfWorkers(Integer numberOfWorkers) {
            this.numberOfWorkers = numberOfWorkers;
            return this;
        }

        public final void setNumberOfWorkers(Integer numberOfWorkers) {
            this.numberOfWorkers = numberOfWorkers;
        }

        public final String getExtraPythonLibsS3Path() {
            return extraPythonLibsS3Path;
        }

        @Override
        public final Builder extraPythonLibsS3Path(String extraPythonLibsS3Path) {
            this.extraPythonLibsS3Path = extraPythonLibsS3Path;
            return this;
        }

        public final void setExtraPythonLibsS3Path(String extraPythonLibsS3Path) {
            this.extraPythonLibsS3Path = extraPythonLibsS3Path;
        }

        public final String getExtraJarsS3Path() {
            return extraJarsS3Path;
        }

        @Override
        public final Builder extraJarsS3Path(String extraJarsS3Path) {
            this.extraJarsS3Path = extraJarsS3Path;
            return this;
        }

        public final void setExtraJarsS3Path(String extraJarsS3Path) {
            this.extraJarsS3Path = extraJarsS3Path;
        }

        public final String getSecurityConfiguration() {
            return securityConfiguration;
        }

        @Override
        public final Builder securityConfiguration(String securityConfiguration) {
            this.securityConfiguration = securityConfiguration;
            return this;
        }

        public final void setSecurityConfiguration(String securityConfiguration) {
            this.securityConfiguration = securityConfiguration;
        }

        public final Map<String, String> getTags() {
            return tags;
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
            return this;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
        }

        public final Map<String, String> getArguments() {
            return arguments;
        }

        @Override
        public final Builder arguments(Map<String, String> arguments) {
            this.arguments = MapValueCopier.copy(arguments);
            return this;
        }

        public final void setArguments(Map<String, String> arguments) {
            this.arguments = MapValueCopier.copy(arguments);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateDevEndpointRequest build() {
            return new CreateDevEndpointRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
