/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Metrics for a specified crawler.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CrawlerMetrics implements SdkPojo, Serializable, ToCopyableBuilder<CrawlerMetrics.Builder, CrawlerMetrics> {
    private static final SdkField<String> CRAWLER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CrawlerMetrics::crawlerName)).setter(setter(Builder::crawlerName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CrawlerName").build()).build();

    private static final SdkField<Double> TIME_LEFT_SECONDS_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .getter(getter(CrawlerMetrics::timeLeftSeconds)).setter(setter(Builder::timeLeftSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimeLeftSeconds").build()).build();

    private static final SdkField<Boolean> STILL_ESTIMATING_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(CrawlerMetrics::stillEstimating)).setter(setter(Builder::stillEstimating))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StillEstimating").build()).build();

    private static final SdkField<Double> LAST_RUNTIME_SECONDS_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .getter(getter(CrawlerMetrics::lastRuntimeSeconds)).setter(setter(Builder::lastRuntimeSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastRuntimeSeconds").build())
            .build();

    private static final SdkField<Double> MEDIAN_RUNTIME_SECONDS_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .getter(getter(CrawlerMetrics::medianRuntimeSeconds)).setter(setter(Builder::medianRuntimeSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MedianRuntimeSeconds").build())
            .build();

    private static final SdkField<Integer> TABLES_CREATED_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(CrawlerMetrics::tablesCreated)).setter(setter(Builder::tablesCreated))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TablesCreated").build()).build();

    private static final SdkField<Integer> TABLES_UPDATED_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(CrawlerMetrics::tablesUpdated)).setter(setter(Builder::tablesUpdated))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TablesUpdated").build()).build();

    private static final SdkField<Integer> TABLES_DELETED_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(CrawlerMetrics::tablesDeleted)).setter(setter(Builder::tablesDeleted))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TablesDeleted").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CRAWLER_NAME_FIELD,
            TIME_LEFT_SECONDS_FIELD, STILL_ESTIMATING_FIELD, LAST_RUNTIME_SECONDS_FIELD, MEDIAN_RUNTIME_SECONDS_FIELD,
            TABLES_CREATED_FIELD, TABLES_UPDATED_FIELD, TABLES_DELETED_FIELD));

    private static final long serialVersionUID = 1L;

    private final String crawlerName;

    private final Double timeLeftSeconds;

    private final Boolean stillEstimating;

    private final Double lastRuntimeSeconds;

    private final Double medianRuntimeSeconds;

    private final Integer tablesCreated;

    private final Integer tablesUpdated;

    private final Integer tablesDeleted;

    private CrawlerMetrics(BuilderImpl builder) {
        this.crawlerName = builder.crawlerName;
        this.timeLeftSeconds = builder.timeLeftSeconds;
        this.stillEstimating = builder.stillEstimating;
        this.lastRuntimeSeconds = builder.lastRuntimeSeconds;
        this.medianRuntimeSeconds = builder.medianRuntimeSeconds;
        this.tablesCreated = builder.tablesCreated;
        this.tablesUpdated = builder.tablesUpdated;
        this.tablesDeleted = builder.tablesDeleted;
    }

    /**
     * <p>
     * The name of the crawler.
     * </p>
     * 
     * @return The name of the crawler.
     */
    public String crawlerName() {
        return crawlerName;
    }

    /**
     * <p>
     * The estimated time left to complete a running crawl.
     * </p>
     * 
     * @return The estimated time left to complete a running crawl.
     */
    public Double timeLeftSeconds() {
        return timeLeftSeconds;
    }

    /**
     * <p>
     * True if the crawler is still estimating how long it will take to complete this run.
     * </p>
     * 
     * @return True if the crawler is still estimating how long it will take to complete this run.
     */
    public Boolean stillEstimating() {
        return stillEstimating;
    }

    /**
     * <p>
     * The duration of the crawler's most recent run, in seconds.
     * </p>
     * 
     * @return The duration of the crawler's most recent run, in seconds.
     */
    public Double lastRuntimeSeconds() {
        return lastRuntimeSeconds;
    }

    /**
     * <p>
     * The median duration of this crawler's runs, in seconds.
     * </p>
     * 
     * @return The median duration of this crawler's runs, in seconds.
     */
    public Double medianRuntimeSeconds() {
        return medianRuntimeSeconds;
    }

    /**
     * <p>
     * The number of tables created by this crawler.
     * </p>
     * 
     * @return The number of tables created by this crawler.
     */
    public Integer tablesCreated() {
        return tablesCreated;
    }

    /**
     * <p>
     * The number of tables updated by this crawler.
     * </p>
     * 
     * @return The number of tables updated by this crawler.
     */
    public Integer tablesUpdated() {
        return tablesUpdated;
    }

    /**
     * <p>
     * The number of tables deleted by this crawler.
     * </p>
     * 
     * @return The number of tables deleted by this crawler.
     */
    public Integer tablesDeleted() {
        return tablesDeleted;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(crawlerName());
        hashCode = 31 * hashCode + Objects.hashCode(timeLeftSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(stillEstimating());
        hashCode = 31 * hashCode + Objects.hashCode(lastRuntimeSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(medianRuntimeSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(tablesCreated());
        hashCode = 31 * hashCode + Objects.hashCode(tablesUpdated());
        hashCode = 31 * hashCode + Objects.hashCode(tablesDeleted());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CrawlerMetrics)) {
            return false;
        }
        CrawlerMetrics other = (CrawlerMetrics) obj;
        return Objects.equals(crawlerName(), other.crawlerName()) && Objects.equals(timeLeftSeconds(), other.timeLeftSeconds())
                && Objects.equals(stillEstimating(), other.stillEstimating())
                && Objects.equals(lastRuntimeSeconds(), other.lastRuntimeSeconds())
                && Objects.equals(medianRuntimeSeconds(), other.medianRuntimeSeconds())
                && Objects.equals(tablesCreated(), other.tablesCreated())
                && Objects.equals(tablesUpdated(), other.tablesUpdated())
                && Objects.equals(tablesDeleted(), other.tablesDeleted());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CrawlerMetrics").add("CrawlerName", crawlerName()).add("TimeLeftSeconds", timeLeftSeconds())
                .add("StillEstimating", stillEstimating()).add("LastRuntimeSeconds", lastRuntimeSeconds())
                .add("MedianRuntimeSeconds", medianRuntimeSeconds()).add("TablesCreated", tablesCreated())
                .add("TablesUpdated", tablesUpdated()).add("TablesDeleted", tablesDeleted()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CrawlerName":
            return Optional.ofNullable(clazz.cast(crawlerName()));
        case "TimeLeftSeconds":
            return Optional.ofNullable(clazz.cast(timeLeftSeconds()));
        case "StillEstimating":
            return Optional.ofNullable(clazz.cast(stillEstimating()));
        case "LastRuntimeSeconds":
            return Optional.ofNullable(clazz.cast(lastRuntimeSeconds()));
        case "MedianRuntimeSeconds":
            return Optional.ofNullable(clazz.cast(medianRuntimeSeconds()));
        case "TablesCreated":
            return Optional.ofNullable(clazz.cast(tablesCreated()));
        case "TablesUpdated":
            return Optional.ofNullable(clazz.cast(tablesUpdated()));
        case "TablesDeleted":
            return Optional.ofNullable(clazz.cast(tablesDeleted()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CrawlerMetrics, T> g) {
        return obj -> g.apply((CrawlerMetrics) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CrawlerMetrics> {
        /**
         * <p>
         * The name of the crawler.
         * </p>
         * 
         * @param crawlerName
         *        The name of the crawler.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder crawlerName(String crawlerName);

        /**
         * <p>
         * The estimated time left to complete a running crawl.
         * </p>
         * 
         * @param timeLeftSeconds
         *        The estimated time left to complete a running crawl.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timeLeftSeconds(Double timeLeftSeconds);

        /**
         * <p>
         * True if the crawler is still estimating how long it will take to complete this run.
         * </p>
         * 
         * @param stillEstimating
         *        True if the crawler is still estimating how long it will take to complete this run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stillEstimating(Boolean stillEstimating);

        /**
         * <p>
         * The duration of the crawler's most recent run, in seconds.
         * </p>
         * 
         * @param lastRuntimeSeconds
         *        The duration of the crawler's most recent run, in seconds.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastRuntimeSeconds(Double lastRuntimeSeconds);

        /**
         * <p>
         * The median duration of this crawler's runs, in seconds.
         * </p>
         * 
         * @param medianRuntimeSeconds
         *        The median duration of this crawler's runs, in seconds.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder medianRuntimeSeconds(Double medianRuntimeSeconds);

        /**
         * <p>
         * The number of tables created by this crawler.
         * </p>
         * 
         * @param tablesCreated
         *        The number of tables created by this crawler.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tablesCreated(Integer tablesCreated);

        /**
         * <p>
         * The number of tables updated by this crawler.
         * </p>
         * 
         * @param tablesUpdated
         *        The number of tables updated by this crawler.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tablesUpdated(Integer tablesUpdated);

        /**
         * <p>
         * The number of tables deleted by this crawler.
         * </p>
         * 
         * @param tablesDeleted
         *        The number of tables deleted by this crawler.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tablesDeleted(Integer tablesDeleted);
    }

    static final class BuilderImpl implements Builder {
        private String crawlerName;

        private Double timeLeftSeconds;

        private Boolean stillEstimating;

        private Double lastRuntimeSeconds;

        private Double medianRuntimeSeconds;

        private Integer tablesCreated;

        private Integer tablesUpdated;

        private Integer tablesDeleted;

        private BuilderImpl() {
        }

        private BuilderImpl(CrawlerMetrics model) {
            crawlerName(model.crawlerName);
            timeLeftSeconds(model.timeLeftSeconds);
            stillEstimating(model.stillEstimating);
            lastRuntimeSeconds(model.lastRuntimeSeconds);
            medianRuntimeSeconds(model.medianRuntimeSeconds);
            tablesCreated(model.tablesCreated);
            tablesUpdated(model.tablesUpdated);
            tablesDeleted(model.tablesDeleted);
        }

        public final String getCrawlerName() {
            return crawlerName;
        }

        @Override
        public final Builder crawlerName(String crawlerName) {
            this.crawlerName = crawlerName;
            return this;
        }

        public final void setCrawlerName(String crawlerName) {
            this.crawlerName = crawlerName;
        }

        public final Double getTimeLeftSeconds() {
            return timeLeftSeconds;
        }

        @Override
        public final Builder timeLeftSeconds(Double timeLeftSeconds) {
            this.timeLeftSeconds = timeLeftSeconds;
            return this;
        }

        public final void setTimeLeftSeconds(Double timeLeftSeconds) {
            this.timeLeftSeconds = timeLeftSeconds;
        }

        public final Boolean getStillEstimating() {
            return stillEstimating;
        }

        @Override
        public final Builder stillEstimating(Boolean stillEstimating) {
            this.stillEstimating = stillEstimating;
            return this;
        }

        public final void setStillEstimating(Boolean stillEstimating) {
            this.stillEstimating = stillEstimating;
        }

        public final Double getLastRuntimeSeconds() {
            return lastRuntimeSeconds;
        }

        @Override
        public final Builder lastRuntimeSeconds(Double lastRuntimeSeconds) {
            this.lastRuntimeSeconds = lastRuntimeSeconds;
            return this;
        }

        public final void setLastRuntimeSeconds(Double lastRuntimeSeconds) {
            this.lastRuntimeSeconds = lastRuntimeSeconds;
        }

        public final Double getMedianRuntimeSeconds() {
            return medianRuntimeSeconds;
        }

        @Override
        public final Builder medianRuntimeSeconds(Double medianRuntimeSeconds) {
            this.medianRuntimeSeconds = medianRuntimeSeconds;
            return this;
        }

        public final void setMedianRuntimeSeconds(Double medianRuntimeSeconds) {
            this.medianRuntimeSeconds = medianRuntimeSeconds;
        }

        public final Integer getTablesCreated() {
            return tablesCreated;
        }

        @Override
        public final Builder tablesCreated(Integer tablesCreated) {
            this.tablesCreated = tablesCreated;
            return this;
        }

        public final void setTablesCreated(Integer tablesCreated) {
            this.tablesCreated = tablesCreated;
        }

        public final Integer getTablesUpdated() {
            return tablesUpdated;
        }

        @Override
        public final Builder tablesUpdated(Integer tablesUpdated) {
            this.tablesUpdated = tablesUpdated;
            return this;
        }

        public final void setTablesUpdated(Integer tablesUpdated) {
            this.tablesUpdated = tablesUpdated;
        }

        public final Integer getTablesDeleted() {
            return tablesDeleted;
        }

        @Override
        public final Builder tablesDeleted(Integer tablesDeleted) {
            this.tablesDeleted = tablesDeleted;
            return this;
        }

        public final void setTablesDeleted(Integer tablesDeleted) {
            this.tablesDeleted = tablesDeleted;
        }

        @Override
        public CrawlerMetrics build() {
            return new CrawlerMetrics(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
