/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Defines a boolean column statistics.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BooleanColumnStatisticsData implements SdkPojo, Serializable,
        ToCopyableBuilder<BooleanColumnStatisticsData.Builder, BooleanColumnStatisticsData> {
    private static final SdkField<Long> NUMBER_OF_TRUES_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .getter(getter(BooleanColumnStatisticsData::numberOfTrues)).setter(setter(Builder::numberOfTrues))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberOfTrues").build()).build();

    private static final SdkField<Long> NUMBER_OF_FALSES_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .getter(getter(BooleanColumnStatisticsData::numberOfFalses)).setter(setter(Builder::numberOfFalses))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberOfFalses").build()).build();

    private static final SdkField<Long> NUMBER_OF_NULLS_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .getter(getter(BooleanColumnStatisticsData::numberOfNulls)).setter(setter(Builder::numberOfNulls))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberOfNulls").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NUMBER_OF_TRUES_FIELD,
            NUMBER_OF_FALSES_FIELD, NUMBER_OF_NULLS_FIELD));

    private static final long serialVersionUID = 1L;

    private final Long numberOfTrues;

    private final Long numberOfFalses;

    private final Long numberOfNulls;

    private BooleanColumnStatisticsData(BuilderImpl builder) {
        this.numberOfTrues = builder.numberOfTrues;
        this.numberOfFalses = builder.numberOfFalses;
        this.numberOfNulls = builder.numberOfNulls;
    }

    /**
     * <p>
     * Number of true value.
     * </p>
     * 
     * @return Number of true value.
     */
    public Long numberOfTrues() {
        return numberOfTrues;
    }

    /**
     * <p>
     * Number of false value.
     * </p>
     * 
     * @return Number of false value.
     */
    public Long numberOfFalses() {
        return numberOfFalses;
    }

    /**
     * <p>
     * Number of nulls.
     * </p>
     * 
     * @return Number of nulls.
     */
    public Long numberOfNulls() {
        return numberOfNulls;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(numberOfTrues());
        hashCode = 31 * hashCode + Objects.hashCode(numberOfFalses());
        hashCode = 31 * hashCode + Objects.hashCode(numberOfNulls());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BooleanColumnStatisticsData)) {
            return false;
        }
        BooleanColumnStatisticsData other = (BooleanColumnStatisticsData) obj;
        return Objects.equals(numberOfTrues(), other.numberOfTrues()) && Objects.equals(numberOfFalses(), other.numberOfFalses())
                && Objects.equals(numberOfNulls(), other.numberOfNulls());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("BooleanColumnStatisticsData").add("NumberOfTrues", numberOfTrues())
                .add("NumberOfFalses", numberOfFalses()).add("NumberOfNulls", numberOfNulls()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NumberOfTrues":
            return Optional.ofNullable(clazz.cast(numberOfTrues()));
        case "NumberOfFalses":
            return Optional.ofNullable(clazz.cast(numberOfFalses()));
        case "NumberOfNulls":
            return Optional.ofNullable(clazz.cast(numberOfNulls()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BooleanColumnStatisticsData, T> g) {
        return obj -> g.apply((BooleanColumnStatisticsData) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BooleanColumnStatisticsData> {
        /**
         * <p>
         * Number of true value.
         * </p>
         * 
         * @param numberOfTrues
         *        Number of true value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numberOfTrues(Long numberOfTrues);

        /**
         * <p>
         * Number of false value.
         * </p>
         * 
         * @param numberOfFalses
         *        Number of false value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numberOfFalses(Long numberOfFalses);

        /**
         * <p>
         * Number of nulls.
         * </p>
         * 
         * @param numberOfNulls
         *        Number of nulls.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numberOfNulls(Long numberOfNulls);
    }

    static final class BuilderImpl implements Builder {
        private Long numberOfTrues;

        private Long numberOfFalses;

        private Long numberOfNulls;

        private BuilderImpl() {
        }

        private BuilderImpl(BooleanColumnStatisticsData model) {
            numberOfTrues(model.numberOfTrues);
            numberOfFalses(model.numberOfFalses);
            numberOfNulls(model.numberOfNulls);
        }

        public final Long getNumberOfTrues() {
            return numberOfTrues;
        }

        @Override
        public final Builder numberOfTrues(Long numberOfTrues) {
            this.numberOfTrues = numberOfTrues;
            return this;
        }

        public final void setNumberOfTrues(Long numberOfTrues) {
            this.numberOfTrues = numberOfTrues;
        }

        public final Long getNumberOfFalses() {
            return numberOfFalses;
        }

        @Override
        public final Builder numberOfFalses(Long numberOfFalses) {
            this.numberOfFalses = numberOfFalses;
            return this;
        }

        public final void setNumberOfFalses(Long numberOfFalses) {
            this.numberOfFalses = numberOfFalses;
        }

        public final Long getNumberOfNulls() {
            return numberOfNulls;
        }

        @Override
        public final Builder numberOfNulls(Long numberOfNulls) {
            this.numberOfNulls = numberOfNulls;
            return this;
        }

        public final void setNumberOfNulls(Long numberOfNulls) {
            this.numberOfNulls = numberOfNulls;
        }

        @Override
        public BooleanColumnStatisticsData build() {
            return new BooleanColumnStatisticsData(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
